/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sharepointonline;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.SharePointOnlineConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.datasets.StorageTypeVerifier;
import com.dataiku.dip.datasets.sharepointonline.SharePointOnlineListDatasetMeta;
import com.dataiku.dip.datasets.sharepointonline.SharePointOnlineListDatasetTestHandler;
import com.dataiku.dip.datasets.sharepointonline.SharePointOnlineListOutput;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelibazure.com.google.gson.JsonElement;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.ColumnDefinition;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.models.ListItem;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.options.Option;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.options.QueryOption;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.GraphServiceClient;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.ListItemCollectionPage;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.ListItemCollectionRequest;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.requests.ListItemCollectionRequestBuilder;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.serializer.AdditionalDataManager;
import com.dataiku.dss.shadelibazure.okhttp3.Request;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class SharePointOnlineListDatasetHandler
implements RowOrientedDatasetHandler {
    public static final DatasetHandler.DatasetMeta<SharePointOnlineListDatasetHandler, Config> META = new SharePointOnlineListDatasetMeta();
    private static final Set<String> PRIVATE_COLUMNS = new HashSet<String>(Arrays.asList("_ColorTag", "ComplianceAssetId", "ID", "ContentType", "Modified", "Created", "Author", "Editor", "_UIVersionString", "Attachments", "Edit", "LinkTitleNoMenu", "LinkTitle", "DocIcon", "ItemChildCount", "FolderChildCount", "_ComplianceFlags", "_ComplianceTag", "_ComplianceTagWrittenTime", "_ComplianceTagUserId", "_IsRecord", "AppAuthor", "AppEditor"));
    private final AuthCtx authCtx;
    private final Dataset dataset;
    protected final Config config;
    private final String connectionName;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sharepointonlinelist");

    private boolean isColumnOfInterest(String columName) {
        if (columName == null) {
            return false;
        }
        return PRIVATE_COLUMNS.contains(columName);
    }

    public SharePointOnlineListDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        this.authCtx = authCtx;
        this.dataset = dataset;
        this.config = (Config)dataset.getParams();
        this.connectionName = dataset.getParams().getConnection();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public boolean isManaged() {
        return this.dataset.isManaged();
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return META;
    }

    @Override
    public void checkConfiguration() throws IllegalArgumentException, IOException, CodedException, DKUSecurityException {
    }

    @Override
    public String suggestName() throws CodedException, DKUSecurityException {
        return this.config.sharePointList;
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        return Lists.newArrayList((Object[])new Partition[]{new Partition(null)});
    }

    @Override
    public long getRecords() throws Exception {
        logger.info((Object)"getRecords");
        SharePointOnlineConnection connection = null;
        ConnectionsDAO connectionsDAO = (ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class);
        try {
            connection = connectionsDAO.getMandatoryConnectionAs(this.authCtx, this.connectionName, SharePointOnlineConnection.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (DKUSecurityException e) {
            throw new RuntimeException(e);
        }
        ProxySettings proxySettings = connection.getProxySettings();
        SharePointOnlineConnection.SharePointOnlineClient client = connection.getSharePointOnlineClient(this.authCtx, proxySettings);
        String sharePointSite = this.dataset.getParamsAs(Config.class).sharePointSite;
        String sharePointList = this.dataset.getParamsAs(Config.class).sharePointList;
        String siteId = this.dataset.getParamsAs(Config.class).siteId;
        String listId = this.dataset.getParamsAs(Config.class).listId;
        if (StringUtils.isEmpty((String)siteId)) {
            siteId = client.getSiteId(sharePointSite);
        }
        listId = client.getListId(siteId, sharePointList);
        long listLength = client.getListLength(siteId, listId);
        return listLength;
    }

    @Override
    public long getPartitionRecords(Partition p) throws Exception {
        logger.info((Object)("getPartitionRecords for " + p.toString()));
        return this.getRecords();
    }

    @Override
    public DatasetReadiness getReadiness(Partition p, @Nullable ComputableHashComputer.ReadinessComputationSession session) {
        return DatasetReadiness.ready(null);
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        return false;
    }

    @Override
    public boolean isParallelWritable() throws Exception {
        return false;
    }

    @Override
    public boolean executeFastPostCreateOperations() throws Exception {
        return false;
    }

    @Override
    public boolean executeSlowPostCreateOperations_NT() throws Exception {
        return false;
    }

    @Override
    public void executePreRenameOperations() throws IOException {
    }

    @Override
    public void createManaged() throws Exception {
    }

    @Override
    public void clearAllData() throws Exception {
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException, DKUSecurityException, CodedException {
        return new SharePointOnlineListDatasetTestHandler(this.authCtx, this);
    }

    @Override
    public InputSplit getPartitionSplit(Partition partition) throws Exception {
        return this.getSingleSplit();
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        return new FilterResultWithSplits().withMatchingPartition(new Partition(null)).withSplit((InputSplit)this.getSingleSplit());
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        this.checkConfiguration();
        return new SharePointOnlineListOutput(this.authCtx, this.dataset, targetPartition, warningsContext);
    }

    @Override
    public boolean outputHandlesClear() {
        return true;
    }

    @Override
    public RowsInputSplit getSingleSplit() throws Exception {
        return new SharePointOnlineListDataSplit(null);
    }

    @Override
    public RowsInputSplit getSampleSplit() throws Exception {
        return this.getSingleSplit();
    }

    private void initInputHandler() {
    }

    public static class Config
    implements DatasetHandler.DatasetParams {
        private static final long serialVersionUID = -1L;
        public String connection;
        public String sharePointSite;
        public String sharePointList;
        public String siteId;
        public String listId;
        public String siteSearch;
        public boolean notReadyIfEmpty;
        public boolean useBatchWrite;
        public boolean truncateInsteadOfDelete;
        public String path;
        public StorageTypeVerifier.DataTypeMismatchBehavior readDataTypeMismatchBehavior = StorageTypeVerifier.DataTypeMismatchBehavior.DISCARD_WARNING;
        public StorageTypeVerifier.DataTypeMismatchBehavior writeDataTypeMismatchBehavior = StorageTypeVerifier.DataTypeMismatchBehavior.DISCARD_WARNING;

        @Override
        public String getConnection() {
            return this.connection;
        }

        @Override
        public boolean isNotReadyIfEmpty() {
            return this.notReadyIfEmpty;
        }
    }

    class SharePointOnlineListDataSplit
    extends RowsInputSplit {
        protected InputFilter filter;

        SharePointOnlineListDataSplit(InputFilter filter) {
            this.filter = filter;
        }

        public String getDesc() {
            return "SharePoint Online List";
        }

        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            logger.info((Object)"Pushing from SharePoint List into DSS");
            SharePointOnlineConnection connection = null;
            ConnectionsDAO connectionsDAO = (ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class);
            try {
                connection = connectionsDAO.getMandatoryConnectionAs(SharePointOnlineListDatasetHandler.this.authCtx, SharePointOnlineListDatasetHandler.this.connectionName, SharePointOnlineConnection.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (DKUSecurityException e) {
                throw new RuntimeException(e);
            }
            long maxRecords = limit != null && limit.maxRecords > 0L ? limit.maxRecords : 0L;
            ProxySettings proxySettings = connection.getProxySettings();
            SharePointOnlineConnection.SharePointOnlineClient client = connection.getSharePointOnlineClient(SharePointOnlineListDatasetHandler.this.authCtx, proxySettings);
            GraphServiceClient<Request> graphClient = client.getGraphClient();
            LinkedList<QueryOption> requestOptions = null;
            String sharePointSite = SharePointOnlineListDatasetHandler.this.dataset.getParamsAs(Config.class).sharePointSite;
            String sharePointList = SharePointOnlineListDatasetHandler.this.dataset.getParamsAs(Config.class).sharePointList;
            String siteId = SharePointOnlineListDatasetHandler.this.dataset.getParamsAs(Config.class).siteId;
            String listId = SharePointOnlineListDatasetHandler.this.dataset.getParamsAs(Config.class).listId;
            if (StringUtils.isEmpty((String)siteId)) {
                siteId = client.getSiteId(sharePointSite);
            }
            if ((listId = client.getListId(siteId, sharePointList)) == null) {
                throw new Exception("The list ID could not be found. Check that the SharePoint list still exists. If it does, perform the site and list selection once again in the SharePoint dataset settings.");
            }
            List<ColumnDefinition> columnsDefinitions = client.getAllListColumns(siteId, listId);
            requestOptions = new LinkedList<QueryOption>();
            requestOptions.add(new QueryOption("expand", (Object)"field"));
            ListItemCollectionPage listPage = (ListItemCollectionPage)((ListItemCollectionRequest)graphClient.sites(siteId).lists(listId).items().buildRequest(requestOptions)).get();
            List listRows = listPage.getCurrentPage();
            logger.info((Object)("Rows to push to DSS: " + listRows.size()));
            ArrayList<Column> cols = new ArrayList<Column>();
            Boolean isFirstRow = true;
            long rowsPushed = 0L;
            while (listPage != null) {
                for (ListItem listRow : listRows) {
                    if (maxRecords > 0L && rowsPushed >= maxRecords) {
                        logger.info((Object)"push limit would be exceeded, stopping");
                        break;
                    }
                    Row row = rf.row();
                    AdditionalDataManager columns = listRow.fields.additionalDataManager();
                    String columnDisplayName = null;
                    for (ColumnDefinition columnDefinition : columnsDefinitions) {
                        JsonElement value;
                        if (SharePointOnlineListDatasetHandler.this.isColumnOfInterest(columnDefinition.name) || (columnDisplayName = columnDefinition.displayName) == null) continue;
                        if (isFirstRow.booleanValue()) {
                            cols.add(cf.column(columnDisplayName));
                        }
                        if ((value = (JsonElement)columns.get((Object)columnDefinition.name)) == null) continue;
                        String valueAsString = value.isJsonObject() || value.isJsonArray() ? value.toString() : value.getAsString();
                        row.put(cf.column(columnDisplayName), valueAsString);
                    }
                    isFirstRow = false;
                    out.emitRow(row);
                    ++rowsPushed;
                }
                ListItemCollectionRequestBuilder nextPage = (ListItemCollectionRequestBuilder)listPage.getNextPage();
                if (maxRecords > 0L && rowsPushed >= maxRecords) {
                    logger.info((Object)"push limit would be exceeded, stopping");
                    break;
                }
                if (nextPage == null) break;
                listPage = (ListItemCollectionPage)((ListItemCollectionRequest)nextPage.buildRequest(new Option[0])).get();
                listRows = listPage.getCurrentPage();
            }
            logger.info((Object)("Pushed " + rowsPushed + " SharePoint List rows into DSS"));
            return rowsPushed;
        }
    }
}

