/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.actual.k8s;

import com.dataiku.dip.containers.exec.kubernetes.CpuQuantity;
import com.dataiku.dip.containers.exec.kubernetes.MemoryQuantity;
import com.dataiku.dip.deployer.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.K8SAPIServiceDeployment;
import com.dataiku.dip.deployer.common.datamodel.actual.ComparisonItem;
import com.dataiku.dip.deployer.common.datamodel.actual.DeploymentResourceComparator;
import com.dataiku.dip.externalinfras.k8s.cli.DeploymentContainer;
import com.dataiku.dip.externalinfras.k8s.cli.GetDeploymentResponse;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class K8SDeploymentComparator {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.apideployer.datamodel.actual.k8s.k8s-deployment-comparator");

    private K8SDeploymentComparator() {
    }

    public static Set<String> reportOutOfSyncFields(String k8sDeploymentId, K8SAPIServiceDeployment expectedDeploymentSettings, GetDeploymentResponse actualDeploymentResponse, K8SAPIServiceDeployment.K8SDeploymentOverrideMask overrideSettings) {
        if (!Objects.equals(actualDeploymentResponse.apiVersion, "apps/v1")) {
            logger.warnV("Unsupported kubectl GetDeploymentResponse apiVersion: %s. Skipping computation of out-of-sync fields.", new Object[]{actualDeploymentResponse.apiVersion});
            return new HashSet<String>();
        }
        ArrayList<ComparisonItem> deploymentComparisonList = new ArrayList<ComparisonItem>();
        if (!expectedDeploymentSettings.deploymentScaling.hpa) {
            deploymentComparisonList.add(new ComparisonItem(actualDeploymentResponse.spec.replicas, expectedDeploymentSettings.deploymentScaling.initialReplicas, "Replica number", overrideSettings.deploymentScaling));
        }
        deploymentComparisonList.add(new ComparisonItem(actualDeploymentResponse.spec.progressDeadlineSeconds, expectedDeploymentSettings.deploymentScaling.progressDeadlineSeconds, "Progress deadline seconds", overrideSettings.deploymentScaling));
        HashSet<String> outOfSyncMessages = new HashSet<String>(DeploymentResourceComparator.compareResources(deploymentComparisonList));
        List<DeploymentContainer> containerSpecs = actualDeploymentResponse.spec.template.spec.containers;
        if (!containerSpecs.isEmpty()) {
            DeploymentContainer containerSpec = containerSpecs.get(0);
            outOfSyncMessages.addAll(K8SDeploymentComparator.reportContainerOutOfSyncFields(k8sDeploymentId, containerSpec, expectedDeploymentSettings.containerLimits, overrideSettings));
        }
        return outOfSyncMessages;
    }

    private static Set<String> reportContainerOutOfSyncFields(String k8sDeploymentId, DeploymentContainer actualContainerSpec, K8SAPIDeploymentInfra.K8SContainerLimits expectedContainerSpec, K8SAPIServiceDeployment.K8SDeploymentOverrideMask overrideSettings) {
        String errorMessage;
        HashSet<String> messages = new HashSet<String>();
        ArrayList<ComparisonItem> comparisonList = new ArrayList<ComparisonItem>();
        try {
            comparisonList.addAll(K8SDeploymentComparator.getCpuComparisonItems(actualContainerSpec, expectedContainerSpec, overrideSettings));
        }
        catch (Exception e) {
            errorMessage = "Couldn't calculate CPU request/limit out-of-sync fields";
            logger.warnV((Throwable)e, errorMessage, new Object[0]);
            messages.add(String.format("%s for kubernetes deployment '%s': %s", errorMessage, k8sDeploymentId, e.getMessage()));
        }
        try {
            comparisonList.addAll(K8SDeploymentComparator.getMemoryComparisonItems(actualContainerSpec, expectedContainerSpec, overrideSettings));
        }
        catch (Exception e) {
            errorMessage = "Couldn't calculate Memory request/limit out-of-sync fields";
            logger.warnV((Throwable)e, errorMessage, new Object[0]);
            messages.add(String.format("%s for kubernetes deployment '%s': %s", errorMessage, k8sDeploymentId, e.getMessage()));
        }
        messages.addAll(DeploymentResourceComparator.compareResources(comparisonList));
        return messages;
    }

    private static List<ComparisonItem> getMemoryComparisonItems(DeploymentContainer actualContainerSpec, K8SAPIDeploymentInfra.K8SContainerLimits expectedContainerSpec, K8SAPIServiceDeployment.K8SDeploymentOverrideMask overrideSettings) {
        Long actualMemoryLimit = actualContainerSpec.resources.limits != null && actualContainerSpec.resources.limits.memory != null ? Long.valueOf(new MemoryQuantity(actualContainerSpec.resources.limits.memory).getAsMib()) : null;
        Integer expectedMemoryLimit = expectedContainerSpec.memLimitMB >= 0 ? Integer.valueOf(expectedContainerSpec.memLimitMB) : null;
        Long actualMemoryRequest = actualContainerSpec.resources.requests != null && actualContainerSpec.resources.requests.memory != null ? Long.valueOf(new MemoryQuantity(actualContainerSpec.resources.requests.memory).getAsMib()) : null;
        Integer expectedMemoryRequest = expectedContainerSpec.memRequestMB >= 0 ? Integer.valueOf(expectedContainerSpec.memRequestMB) : null;
        return List.of(new ComparisonItem(actualMemoryRequest, expectedMemoryRequest, "Memory request", overrideSettings.containerLimits), new ComparisonItem(actualMemoryLimit, expectedMemoryLimit, "Memory limit", overrideSettings.containerLimits));
    }

    private static List<ComparisonItem> getCpuComparisonItems(DeploymentContainer actualContainerSpec, K8SAPIDeploymentInfra.K8SContainerLimits expectedContainerSpec, K8SAPIServiceDeployment.K8SDeploymentOverrideMask overrideSettings) {
        Float actualCpuLimit = actualContainerSpec.resources.limits != null && actualContainerSpec.resources.limits.cpu != null ? Float.valueOf(new CpuQuantity(actualContainerSpec.resources.limits.cpu).getAsFloat()) : null;
        Float expectedCpuLimit = expectedContainerSpec.cpuLimit >= 0.0 ? Float.valueOf(new CpuQuantity(Double.toString(expectedContainerSpec.cpuLimit)).getAsFloat()) : null;
        Float actualCpuRequest = actualContainerSpec.resources.requests != null && actualContainerSpec.resources.requests.cpu != null ? Float.valueOf(new CpuQuantity(actualContainerSpec.resources.requests.cpu).getAsFloat()) : null;
        Float expectedCpuRequest = expectedContainerSpec.cpuRequest >= 0.0 ? Float.valueOf(new CpuQuantity(Double.toString(expectedContainerSpec.cpuRequest)).getAsFloat()) : null;
        return List.of(new ComparisonItem(actualCpuRequest, expectedCpuRequest, "CPU request", overrideSettings.containerLimits), new ComparisonItem(actualCpuLimit, expectedCpuLimit, "CPU limit", overrideSettings.containerLimits));
    }
}

