/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.actual.snowpark;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.deployer.apideployer.deploymentinfo.SnowparkDeploymentInfo;
import com.dataiku.dip.externalinfras.snowpark.SnowparkUtils;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkDeployedEndpoint;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkDeployedUserFunction;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkDetailedService;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkServiceStatus;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SnowparkDeploymentRemoteSummary {
    @Nullable
    public final SnowparkDetailedService service;
    @Nullable
    public final SnowparkDeployedUserFunction udf;
    @Nullable
    public final SnowparkDeployedEndpoint endpoint;
    @Nullable
    public final List<SnowparkServiceStatus> serviceStatuses;

    private SnowparkDeploymentRemoteSummary(@Nullable SnowparkDetailedService service, @Nullable SnowparkDeployedUserFunction udf, @Nullable SnowparkDeployedEndpoint endpoint, @Nullable List<SnowparkServiceStatus> serviceStatuses) {
        this.service = service;
        this.udf = udf;
        this.endpoint = endpoint;
        this.serviceStatuses = serviceStatuses;
    }

    @Nonnull
    public static SnowparkDeploymentRemoteSummary buildFromRemoteConfig_NT(SnowparkDeploymentInfo deploymentInfo, SQLConnectionProvider.SQLConnectionWrapper sqlConnectionWrapper) throws SQLException, IOException, InterruptedException {
        SnowparkDeployedEndpoint endpoint;
        SnowparkDetailedService snowparkService = SnowparkUtils.getService_NT(sqlConnectionWrapper, deploymentInfo.snowparkServiceName);
        List<SnowparkServiceStatus> serviceStatuses = SnowparkUtils.getServiceStatuses_NT(sqlConnectionWrapper, deploymentInfo.snowparkServiceName);
        SnowparkDeployedUserFunction udf = SnowparkUtils.getUserFunction_NT(sqlConnectionWrapper, deploymentInfo.snowparkUdfName);
        if (snowparkService != null) {
            String string = snowparkService.name;
            Objects.requireNonNull(snowparkService);
            endpoint = SnowparkUtils.getPublicEndpoint_NT(sqlConnectionWrapper, string, "prediction-endpoint");
        } else {
            endpoint = null;
        }
        return new SnowparkDeploymentRemoteSummary(snowparkService, udf, endpoint, serviceStatuses);
    }
}

