/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.actual.vertexai.comparator;

import com.dataiku.dip.deployer.apideployer.datamodel.actual.AbstractFullyManagedResourceWithTagsComparator;
import com.dataiku.dip.deployer.common.datamodel.actual.DeploymentResourceComparator;
import com.dataiku.dip.externalinfras.vertexai.VertexAIUtils;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIEndpoint;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIEndpointConfig;
import com.dataiku.dip.utils.StringUtils;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.Endpoint;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class VertexAIEndpointComparator
implements DeploymentResourceComparator<Endpoint> {
    private final VertexAIEndpoint endpoint;
    private final VertexAIEndpointConfigComparator configComparator;

    public VertexAIEndpointComparator(VertexAIEndpoint endpoint) {
        this.endpoint = endpoint;
        this.configComparator = new VertexAIEndpointConfigComparator(endpoint.config);
    }

    @Override
    public Set<String> reportRecoverableOutOfSyncFields(@Nonnull Endpoint deployedEndpoint) {
        return this.configComparator.reportRecoverableOutOfSyncFields(deployedEndpoint);
    }

    @Override
    public Set<String> reportUnrecoverableOutOfSyncFields(@Nonnull Endpoint deployedEndpoint) {
        HashSet<String> outOfSyncFields = new HashSet<String>();
        outOfSyncFields.addAll(this.configComparator.reportUnrecoverableOutOfSyncFields(deployedEndpoint));
        if (deployedEndpoint.getDeployedModelsCount() > 1) {
            outOfSyncFields.add("There are more Deployed Models than expected associated to the Endpoint.");
        }
        if (!VertexAIUtils.areEndpointFullNamesEqual(this.endpoint.getFullName(), deployedEndpoint.getName(), true)) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Endpoint name", deployedEndpoint.getName(), this.endpoint.getFullName()));
        }
        return outOfSyncFields;
    }

    private static class VertexAIEndpointConfigComparator
    extends AbstractFullyManagedResourceWithTagsComparator {
        private final VertexAIEndpointConfig config;

        private VertexAIEndpointConfigComparator(VertexAIEndpointConfig config) {
            this.config = config;
        }

        @Override
        protected Map<String, String> getStoredTags() {
            return this.config.tags;
        }

        @Override
        protected String getSeparatorOfDssVersionsInTags() {
            return "-";
        }

        Set<String> reportRecoverableOutOfSyncFields(@Nonnull Endpoint deployedEndpoint) {
            HashSet<String> outOfSyncFields = new HashSet<String>();
            outOfSyncFields.addAll(this.reportOutOfSyncNonDSSTags(deployedEndpoint.getLabelsMap()));
            outOfSyncFields.addAll(this.reportMissingDSSTags(deployedEndpoint.getLabelsMap()));
            return outOfSyncFields;
        }

        Set<String> reportUnrecoverableOutOfSyncFields(@Nonnull Endpoint deployedEndpoint) {
            String storedNetworkFullName;
            HashSet<String> outOfSyncFields = new HashSet<String>();
            String deployedNetworkFullName = deployedEndpoint.getNetwork();
            if (!StringUtils.equalsOrBothBlank((String)deployedNetworkFullName, (String)(storedNetworkFullName = this.config.networkFullName))) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Network full name", deployedNetworkFullName, storedNetworkFullName));
            }
            return outOfSyncFields;
        }
    }
}

