/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.config;

import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.StaticAPIDeploymentInfra;
import com.dataiku.dip.utils.JSON;
import java.util.List;
import javax.annotation.Nonnull;

public class StaticDeployment
extends AbstractAPIServiceDeployment {
    public StaticAPIDeploymentInfra.HealthSettings healthSettings = new StaticAPIDeploymentInfra.HealthSettings();
    public StaticAPIDeploymentInfra.RollingUpdateSettings rollingUpdateSettings = new StaticAPIDeploymentInfra.RollingUpdateSettings();
    public StaticAPIDeploymentInfra.StaticAPINodeLogging apiNodeLogging = new StaticAPIDeploymentInfra.StaticAPINodeLogging();
    public StaticDeploymentOverrideMask overrideSettings = new StaticDeploymentOverrideMask();

    private StaticDeployment() {
    }

    public StaticDeployment(String id, String infraId, String publishedServiceId, String version, boolean enabled, VersionTag creationTag) {
        super(id, infraId, publishedServiceId, version, enabled, creationTag);
    }

    public StaticDeployment(String id, String infraId, String publishedServiceId, String version, boolean enabled, VersionTag creationTag, List<AbstractAPIServiceDeployment.AuthorizationItem> authorizationsToQueryThroughDeployer) {
        super(id, infraId, publishedServiceId, version, enabled, creationTag, authorizationsToQueryThroughDeployer);
    }

    public StaticDeployment(AbstractAPIServiceDeployment existingDeployment, String deploymentId, String infraId, boolean enabled, VersionTag creationTag) {
        super(existingDeployment, deploymentId, infraId, enabled, creationTag);
    }

    @Override
    @Nonnull
    public AbstractAPIDeploymentInfra.APINodeLogging getNodeLogging() {
        return this.apiNodeLogging;
    }

    @Override
    @Nonnull
    public AbstractAPIDeploymentInfra.APINodeLogging getNodeLogging(AbstractAPIDeploymentInfra infra) {
        if (this.overrideSettings.loggingSettings) {
            AbstractAPIDeploymentInfra.APINodeLogging infraNodeLogging = infra.getNodeLogging();
            AbstractAPIDeploymentInfra.APINodeLogging result = (AbstractAPIDeploymentInfra.APINodeLogging)JSON.deepCopy((Object)this.apiNodeLogging);
            result.fsLikeSettings.connectionName = infraNodeLogging.fsLikeSettings.connectionName;
            result.fsLikeSettings.pathWithinConnection = infraNodeLogging.fsLikeSettings.pathWithinConnection;
            result.fsLikeSettings.bucket = infraNodeLogging.fsLikeSettings.bucket;
            return result;
        }
        return infra.getNodeLogging();
    }

    public static class StaticDeploymentOverrideMask {
        boolean healthSettings;
        boolean rollingUpdateSettings;
        boolean loggingSettings;

        public void applyToDeployment(StaticDeployment target, StaticAPIDeploymentInfra source) {
            if (!this.healthSettings) {
                target.healthSettings = (StaticAPIDeploymentInfra.HealthSettings)JSON.deepCopy((Object)source.defaultHealthSettings);
            }
            if (!this.rollingUpdateSettings) {
                target.rollingUpdateSettings = (StaticAPIDeploymentInfra.RollingUpdateSettings)JSON.deepCopy((Object)source.defaultRollingUpdateSettings);
            }
            if (this.loggingSettings) {
                StaticAPIDeploymentInfra.StaticAPINodeLogging infraNodeLogging = source.defaultApiNodeLogging;
                target.apiNodeLogging.fsLikeSettings.connectionName = infraNodeLogging.fsLikeSettings.connectionName;
                target.apiNodeLogging.fsLikeSettings.pathWithinConnection = infraNodeLogging.fsLikeSettings.pathWithinConnection;
                target.apiNodeLogging.fsLikeSettings.bucket = infraNodeLogging.fsLikeSettings.bucket;
            } else {
                target.apiNodeLogging = (StaticAPIDeploymentInfra.StaticAPINodeLogging)JSON.deepCopy((Object)source.defaultApiNodeLogging);
            }
        }
    }
}

