/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.published;

import com.dataiku.common.server.APIKeyBase;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionCoreParams;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.APIServiceDeploymentMonitoringStatus;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.APIServiceEndpointMonitoring;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.PublishedApiServicePackageInfo;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.PublishedAPIService;
import com.dataiku.dip.deployer.apideployer.datamodel.config.ServiceVersionOriginInfo;
import com.dataiku.dip.deployer.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.deployer.apideployer.deployments.EmbeddedModelVersionIdentifier;
import com.dataiku.dip.deployer.apideployer.deployments.PublishedApiServicePackageInfoForGovernIdentification;
import com.dataiku.dip.deployer.apideployer.infra.ApiNodeInfrasService;
import com.dataiku.dip.deployer.apideployer.published.PublishedAPIServicesDAO;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractPublishedItemLightStatus;
import com.dataiku.dip.deployer.common.datamodel.actual.PublishedPackageInfo;
import com.dataiku.dip.deployer.common.datamodel.config.DesignNodeInfo;
import com.dataiku.dip.deployer.common.datamodel.config.PublishedItem;
import com.dataiku.dip.deployer.common.published.AbstractPublishedItemsService;
import com.dataiku.dip.deployer.common.published.FileBasedPublishedItemsDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.ZipUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.lambda.model.serverconfig.BundledSMVersion;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.dataiku.lambda.model.serverconfig.LambdaDesignPermissions;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServiceConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServiceGenTag;
import com.dataiku.lambda.model.serverconfig.PredictionEndpointConfig;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PublishedAPIServicesService
extends AbstractPublishedItemsService<AbstractAPIServiceDeployment, AbstractPublishedItemBasicInfo.PublishedAPIServiceBasicInfo, AbstractAPIDeploymentInfra> {
    @Autowired
    private PublishedAPIServicesDAO publishedAPIServicesDAO;
    @Autowired
    private ApiNodeInfrasService apiNodeInfrasService;
    @Autowired
    private APIServiceDeploymentsService apiServiceDeploymentsService;
    @Autowired
    private TransactionService transactionService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.publishedapiservices");

    public APIServiceDeploymentsService getDeploymentsService() {
        return this.apiServiceDeploymentsService;
    }

    @Override
    protected FileBasedPublishedItemsDAO getPublishedItemsDAO() {
        return this.publishedAPIServicesDAO;
    }

    protected ApiNodeInfrasService getInfrasService() {
        return this.apiNodeInfrasService;
    }

    public AbstractPublishedItemBasicInfo.PublishedAPIServiceBasicInfoList createItemBasicInfoList() {
        return new AbstractPublishedItemBasicInfo.PublishedAPIServiceBasicInfoList();
    }

    @Override
    protected AbstractPublishedItemLightStatus.PublishedAPIServiceLightStatus createItemLightStatus(List<PublishedPackageInfo> packages, List<? extends AbstractDeploymentBasicInfo> deployments, List<AbstractInfraBasicInfo> infras, PublishedItem item, boolean isServiceAdmin, boolean canDeploy, boolean canWrite) {
        return new AbstractPublishedItemLightStatus.PublishedAPIServiceLightStatus(packages, deployments, infras, this.basicInfoUnsafe(item), isServiceAdmin, canDeploy, canWrite);
    }

    @Override
    protected PublishedItem newPublishedItem() {
        return new PublishedAPIService();
    }

    public List<ApiEndpointQuery> readTestQueries_NT(String publishedItemId, String generationId, String endpointId) throws NotFoundException {
        File file = this.publishedPackageFile(publishedItemId, generationId);
        if (!file.exists()) {
            throw new NotFoundException("package not found");
        }
        try {
            return ZipUtils.readFileContentJSON(file, "testqueries-" + endpointId + ".json", new TypeToken<List<ApiEndpointQuery>>(){});
        }
        catch (Exception e) {
            logger.warn((Object)("Could not read test queries from " + String.valueOf(file) + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            return new ArrayList<ApiEndpointQuery>();
        }
    }

    public String readCode_NT(String publishedItemId, String generationId, LambdaEndpointConfig lec) throws NotFoundException {
        File file = this.publishedPackageFile(publishedItemId, generationId);
        if (!file.exists()) {
            throw new NotFoundException("package not found");
        }
        try {
            return ZipUtils.readFileContentString(file, "endpoint-" + lec.id + "/code." + lec.getCodeFileExtension());
        }
        catch (Exception e) {
            logger.warn((Object)("Could not read code from " + String.valueOf(file) + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            return null;
        }
    }

    public void publishVersionFromStream_NT_Check(String publishedApiServiceId, InputStream is, AuthCtx authCtx) throws UnauthorizedException, IOException {
        DesignNodeInfo designNodeInfo = new DesignNodeInfo();
        try (AutoDelete contextDir = DSSTempUtils.getTempFolder((String)String.format("deployer-tmp-get-%s-id", this.getPackageType()), (String)SecretKeyGenerator.generate((int)8));){
            File tempPackageArchive = new File((File)contextDir, "package.zip");
            FileUtils.copyInputStreamToFile((InputStream)is, (File)tempPackageArchive);
            LambdaServiceConfig lsc = ZipUtils.readFileContentJSON(tempPackageArchive, "config.json", LambdaServiceConfig.class);
            if (lsc == null) {
                throw ErrorContext.iae((String)"Zip file is not a valid service version (missing config.json)");
            }
            LambdaServiceGenTag genTag = ZipUtils.readFileContentJSON(tempPackageArchive, "tag.json", LambdaServiceGenTag.class);
            if (genTag == null) {
                throw ErrorContext.iae((String)"Zip file is not a valid service version (missing tag.json)");
            }
            LambdaDesignPermissions permissions = ZipUtils.readFileContentJSON(tempPackageArchive, "design-permissions.json", LambdaDesignPermissions.class);
            String versionId = genTag.generationId;
            designNodeInfo.installId = genTag.createdWithInstallId;
            designNodeInfo.nodeId = genTag.createdOnNodeId;
            designNodeInfo.url = genTag.createdOnNodeUrl;
            designNodeInfo.projectKey = genTag.originalProjectKey;
            boolean created = this.publishPackageFromTempArchive_NT_Check(publishedApiServiceId, versionId, tempPackageArchive, authCtx);
            this.writePackageOriginInfo(authCtx, publishedApiServiceId, versionId, designNodeInfo);
            if (created && permissions != null) {
                this.propagatePermissions(authCtx, publishedApiServiceId, versionId, permissions);
            }
        }
    }

    private void propagatePermissions(AuthCtx authCtx, String publishedApiServiceId, String versionId, @Nonnull LambdaDesignPermissions permissions) throws IOException {
        logger.infoV("Propagating all permissions from package version %s to published API service %s.", new Object[]{versionId, publishedApiServiceId});
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            PublishedAPIService publishedAPIService = (PublishedAPIService)this.getPublishedItemsDAO().getMandatoryUnsafe(publishedApiServiceId);
            publishedAPIService.permissions = this.computeInitialPermissionsFromCoreGroupPermissions(permissions.permissions);
            this.getPublishedItemsDAO().save(publishedAPIService);
            t.commit("Saving published API service (updating permissions) " + publishedApiServiceId);
        }
    }

    private void writePackageOriginInfo(AuthCtx authCtx, String publishedApiServiceId, String packageId, DesignNodeInfo designNodeInfo) throws IOException {
        File packageOriginInfoFile = this.packageOriginInfoFile(publishedApiServiceId, packageId);
        ServiceVersionOriginInfo serviceVersionOriginInfo = new ServiceVersionOriginInfo();
        serviceVersionOriginInfo.packageId = packageId;
        serviceVersionOriginInfo.publishedBy = authCtx.getIdentifier();
        serviceVersionOriginInfo.designNodeInfo = designNodeInfo;
        JSON.prettyToFile((Object)serviceVersionOriginInfo, (File)packageOriginInfoFile);
    }

    private File packageOriginInfoFile(String publishedApiServiceId, String packageId) {
        String packageOriginFilename = "package-" + packageId + "-origin-info.json";
        return DKUApp.getFile((File)this.publishedPackagesDir(publishedApiServiceId), (String[])new String[]{packageOriginFilename});
    }

    @Override
    public boolean hasCreatePermission(AuthCtx authCtx) {
        return ((DSSAuthCtx)authCtx).getPermissions().mayCreatePublishedAPIServices();
    }

    @Override
    public AbstractPublishedItemBasicInfo.PublishedAPIServiceBasicInfo basicInfoUnsafe(PublishedItem item) {
        return new AbstractPublishedItemBasicInfo.PublishedAPIServiceBasicInfo(item);
    }

    @Override
    public PublishedApiServicePackageInfo getPublishedPackageOrNull_Check_NT(String publishedServiceId, String generationId, AuthCtx authCtx) throws UnauthorizedException, IOException {
        File packageFile = this.getPublishedPackageFileOrNull_Check_NT(publishedServiceId, generationId, authCtx);
        if (packageFile == null) {
            return null;
        }
        try {
            return this.buildPublishedApiServicePackageInfoMandatory(packageFile, publishedServiceId, generationId);
        }
        catch (CodedException e) {
            logger.warnV((Throwable)e, "Cannot build published package info: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            return null;
        }
    }

    public PublishedApiServicePackageInfo getPublishedPackageOrNull(String publishedServiceId, String generationId) throws IOException {
        File packageFile = this.getPublishedPackageFileOrNull(publishedServiceId, generationId);
        if (packageFile == null) {
            return null;
        }
        try {
            return this.buildPublishedApiServicePackageInfoMandatory(packageFile, publishedServiceId, generationId);
        }
        catch (CodedException e) {
            logger.warnV("Cannot build published package info: " + ExceptionUtils.getMessageWithCauses((Throwable)e), new Object[]{e});
            return null;
        }
    }

    private PublishedApiServicePackageInfo buildPublishedApiServicePackageInfoMandatory(File packageFile, String publishedServiceId, String generationId) throws CodedException, IOException {
        LambdaServiceGenTag tag = ZipUtils.readFileContentJSON(packageFile, "tag.json", LambdaServiceGenTag.class);
        if (tag == null) {
            throw ErrorContext.iae((String)("Zip file is not a valid service version (missing tag.json): " + publishedServiceId + ", " + generationId));
        }
        LambdaServiceConfig lsc = ZipUtils.readFileContentJSON(packageFile, "config.json", LambdaServiceConfig.class);
        if (lsc == null) {
            throw ErrorContext.iae((String)("Zip file is not a valid service version (missing config.json): " + publishedServiceId + ", " + generationId));
        }
        String openAPIDocContent = ZipUtils.readFileContentString(packageFile, "swagger.json");
        PublishedApiServicePackageInfo ret = new PublishedApiServicePackageInfo();
        ret.endpoints = lsc.endpoints;
        ret.id = generationId;
        ret.releaseNotes = tag.releaseNotes;
        ret.stdModels = lsc.stdModels;
        ret.publishedOn = packageFile.lastModified();
        ret.publishedBy = tag.createdBy;
        ret.authMethod = lsc.getAuthMethod();
        ret.designNodeInfo = new DesignNodeInfo();
        ret.designNodeInfo.installId = tag.createdWithInstallId;
        ret.designNodeInfo.nodeId = tag.createdOnNodeId;
        ret.designNodeInfo.url = tag.createdOnNodeUrl;
        ret.designNodeInfo.projectKey = tag.originalProjectKey;
        ret.hasOpenAPIDoc = lsc.hasOpenAPIDoc;
        ret.openAPIDocContent = openAPIDocContent;
        ret.typeBadges = lsc.typeBadges;
        switch (ret.authMethod) {
            case PUBLIC: {
                break;
            }
            case API_KEYS: {
                for (APIKeyBase aPIKeyBase : lsc.authRealm.queryKeys) {
                    AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus.APIKeyBasicInfo akbi = new AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus.APIKeyBasicInfo();
                    akbi.key = aPIKeyBase.key;
                    akbi.label = aPIKeyBase.label;
                    ret.apiKeys.add(akbi);
                }
                break;
            }
            case OAUTH2: {
                ret.oauth2Config = lsc.oauth2Config;
            }
        }
        return ret;
    }

    @Override
    public PublishedApiServicePackageInfoForGovernIdentification getPublishedPackageInfoForGovernIdentification_NT(String publishedItemId, String packageId) throws IOException, CodedException {
        File packageFile = this.getPublishedPackageFileMandatory(publishedItemId, packageId);
        PublishedApiServicePackageInfo publishedPackageInfo = this.buildPublishedApiServicePackageInfoMandatory(packageFile, publishedItemId, packageId);
        if (StringUtils.isBlank((String)publishedPackageInfo.designNodeInfo.nodeId)) {
            throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_GOVERN_API_SERVICE_PACKAGE_MISSING_INFO, "API Service package has missing info in order to be identified in Govern: the Design instance Node may not be set, the package may be too old: " + publishedItemId + ", " + packageId);
        }
        PublishedApiServicePackageInfoForGovernIdentification publishedPackageInfoForGovernIdentification = new PublishedApiServicePackageInfoForGovernIdentification();
        publishedPackageInfoForGovernIdentification.originalNodeId = publishedPackageInfo.designNodeInfo.nodeId;
        if (publishedPackageInfo.stdModels == null) {
            return publishedPackageInfoForGovernIdentification;
        }
        for (BundledSMVersion bundledSMVersion : publishedPackageInfo.stdModels) {
            ResolvedCoreParams coreParams;
            if (bundledSMVersion.modelType != MLTask.MLTaskType.PREDICTION && bundledSMVersion.modelType != MLTask.MLTaskType.CLUSTERING || (coreParams = ZipUtils.readFileContentJSON(packageFile, "models/" + bundledSMVersion.originalProjectKey + "." + bundledSMVersion.originalSavedModelId + "/core_params.json", ResolvedCoreParams.class)) instanceof ResolvedPredictionCoreParams && ((ResolvedPredictionCoreParams)coreParams).isPartitioned()) continue;
            if (StringUtils.isBlank((String)bundledSMVersion.originalProjectKey) || StringUtils.isBlank((String)bundledSMVersion.originalSavedModelId) || StringUtils.isBlank((String)bundledSMVersion.originalSavedModelVersion)) {
                throw new CodedException((InfoMessage.MessageCode)DeployerCodes.ERR_GOVERN_API_SERVICE_PACKAGE_MISSING_INFO, "API Service package has missing info in order to be identified in Govern: Project Key, Saved Model ID, or Saved Model Version ID is missing, the package may be too old: " + publishedItemId + ", " + packageId);
            }
            String fmi = new FullModelId(bundledSMVersion.originalProjectKey, bundledSMVersion.originalSavedModelId, bundledSMVersion.originalSavedModelVersion).toString();
            EmbeddedModelVersionIdentifier embeddedModelVersionIdentifier = new EmbeddedModelVersionIdentifier();
            embeddedModelVersionIdentifier.originalProjectKey = bundledSMVersion.originalProjectKey;
            embeddedModelVersionIdentifier.originalSavedModelId = bundledSMVersion.originalSavedModelId;
            embeddedModelVersionIdentifier.originalSavedModelVersion = bundledSMVersion.originalSavedModelVersion;
            embeddedModelVersionIdentifier.originalFullModelId = fmi;
            embeddedModelVersionIdentifier.originalSavedModelVersionName = bundledSMVersion.originalSavedModelVersionName;
            publishedPackageInfoForGovernIdentification.embeddedModelVersionIdentifiers.add(embeddedModelVersionIdentifier);
        }
        return publishedPackageInfoForGovernIdentification;
    }

    public APIServiceEndpointMonitoring getServiceEndpointMonitoring_NT(String apiServiceId, String endpointId, AuthCtx user) throws IOException, UnauthorizedException {
        try (Transaction t = this.transactionService.beginRead();){
            PublishedItem publishedAPIService = (PublishedItem)this.publishedAPIServicesDAO.getOrNull(apiServiceId);
            if (publishedAPIService == null) {
                APIServiceEndpointMonitoring aPIServiceEndpointMonitoring = new APIServiceEndpointMonitoring(apiServiceId, endpointId);
                return aPIServiceEndpointMonitoring;
            }
        }
        AbstractPublishedItemLightStatus.PublishedAPIServiceLightStatus lightStatus = (AbstractPublishedItemLightStatus.PublishedAPIServiceLightStatus)this.getPublishedItemLightStatusUnsafe_NT_Check(apiServiceId, user);
        Map infrastructuresById = lightStatus.infras.stream().collect(Collectors.toMap(AbstractInfraBasicInfo::getId, Function.identity()));
        Map<String, PublishedApiServicePackageInfo> packageByServiceId = lightStatus.packages.stream().collect(Collectors.toMap(pkg -> pkg.id, abstractPkg -> (PublishedApiServicePackageInfo)abstractPkg));
        List<APIServiceDeploymentMonitoringStatus> deployments = lightStatus.deployments.stream().filter(abstractDeployment -> {
            AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo deployment = (AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo)abstractDeployment;
            if (deployment.generationsMapping.getMode() != GenerationsMapping.GenerationsMappingMode.SINGLE_GENERATION) {
                return false;
            }
            PublishedApiServicePackageInfo pkg = (PublishedApiServicePackageInfo)packageByServiceId.get(deployment.generationsMapping.getEntries().get((int)0).generation);
            return pkg.endpoints.stream().anyMatch(endpointConfig -> endpointConfig.id.equals(endpointId));
        }).map(abstractDeployment -> {
            AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo deployment = (AbstractDeploymentBasicInfo.AbstractAPIServiceDeploymentBasicInfo)abstractDeployment;
            APIServiceDeploymentMonitoringStatus deploymentMonitoring = new APIServiceDeploymentMonitoringStatus();
            deploymentMonitoring.id = deployment.id;
            deploymentMonitoring.publishedServiceId = deployment.publishedServiceId;
            deploymentMonitoring.publishedServiceVersion = deployment.generationsMapping.getEntries().get((int)0).generation;
            deploymentMonitoring.infrastructure = (AbstractInfraBasicInfo)infrastructuresById.get(deployment.infraId);
            deploymentMonitoring.enabled = deployment.enabled;
            PublishedApiServicePackageInfo pkg = (PublishedApiServicePackageInfo)packageByServiceId.get(deploymentMonitoring.publishedServiceVersion);
            LambdaEndpointConfig lambdaEndpointConfig = pkg.endpoints.stream().filter(endpointConfig -> endpointConfig.id.equals(endpointId)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Could not find endpoint %s in the service package", endpointId)));
            if (!(lambdaEndpointConfig instanceof PredictionEndpointConfig)) {
                throw new IllegalArgumentException("API Service endpoint monitoring is only implemented for endpoints of standard prediction");
            }
            deploymentMonitoring.endpointConfig = (PredictionEndpointConfig)lambdaEndpointConfig;
            deploymentMonitoring.smv = pkg.stdModels.stream().filter(smv -> smv.id.equals(deploymentMonitoring.endpointConfig.modelId)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Could find smv %s in endpoint %s", deploymentMonitoring.endpointConfig.modelId, deploymentMonitoring.endpointConfig.id)));
            return deploymentMonitoring;
        }).collect(Collectors.toList());
        return new APIServiceEndpointMonitoring(apiServiceId, endpointId, deployments);
    }

    public File getAuthReadyPackageFile(String publishedItemId, String generationId, String deploymentAuthHash, @Nullable String deployerKey) {
        return ApplicationConfigurator.getFile((String[])new String[]{this.publishedAPIServicesDAO.getDeployerDirectoryString(), this.publishedAPIServicesDAO.getTypeSubdirectoryString(), publishedItemId, "auth-ready-packages", "dss-authready-package-" + generationId + "-" + deploymentAuthHash + (String)(deployerKey != null ? "-" + DigestUtils.md5Hex((String)deployerKey) : "") + ".zip"});
    }

    @Override
    protected String packageFilenamePrefix() {
        return "dss-published-package-";
    }

    @Override
    protected String getExceptionTypePrefix() {
        return "mad-publishedservice-";
    }

    @Override
    public String getType() {
        return this.publishedAPIServicesDAO.getType();
    }

    @Override
    public String getPackageType() {
        return "version";
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }
}

