/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.common.engine;

import com.dataiku.dip.deployer.common.datamodel.config.DeploymentHook;
import com.dataiku.dip.deployer.common.datamodel.config.DeploymentHookResult;
import com.dataiku.dip.deployer.common.engine.DeploymentHooksRunner;
import com.dataiku.dip.deployer.common.engine.DeploymentReportForPostHooksCode;
import com.dataiku.dip.directory.NodeConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.threads.BaseKernelProtocol;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import java.io.IOException;
import java.util.List;

public class DeploymentHooksKernelProtocol
extends BaseKernelProtocol
implements AutoCloseable {
    public static final String PYTHON_PACKAGE = "dataiku.deployer.hooks.server";

    public DeploymentHooksKernelProtocol(SimplePythonKernel simplePythonKernel) {
        super(simplePythonKernel);
    }

    public void loadMetadata(AuthCtx requestingUser, DeploymentHooksRunner.DeploymentHookMetadata metadata, DeploymentReportForPostHooksCode deploymentReportForPostHooksCode) throws IOException, DKUSecurityException {
        if (metadata instanceof DeploymentHooksRunner.SingleNodeProjectDeploymentHookMetadata) {
            this.loadProjectMetadata(requestingUser, (DeploymentHooksRunner.SingleNodeProjectDeploymentHookMetadata)metadata, deploymentReportForPostHooksCode);
        } else if (metadata instanceof DeploymentHooksRunner.MultiNodeProjectDeploymentHookMetadata) {
            this.loadProjectMetadata(requestingUser, (DeploymentHooksRunner.MultiNodeProjectDeploymentHookMetadata)metadata, deploymentReportForPostHooksCode);
        } else {
            this.loadApiMetadata(requestingUser, (DeploymentHooksRunner.ApiDeploymentHookMetadata)metadata, deploymentReportForPostHooksCode);
        }
    }

    public void loadProjectMetadata(AuthCtx requestingUser, DeploymentHooksRunner.SingleNodeProjectDeploymentHookMetadata metadata, DeploymentReportForPostHooksCode deploymentReport) throws IOException, DKUSecurityException {
        this.simplePythonKernel.getLink().sendRequest((Object)new LoadProjectMetadataCommand(requestingUser.getAssociatedDSSUserMand(), metadata.deployingUser, metadata.deployment.id, metadata.nodeConnection.url, metadata.nodeConnection.adminAPIKey, null, metadata.trustAllSSLCertificates, metadata.deployment.getTargetProjectKey(), deploymentReport));
        this.simplePythonKernel.getLink().receiveJsonResponse(LoadProjectMetadataResultResponse.class);
    }

    public void loadProjectMetadata(AuthCtx requestingUser, DeploymentHooksRunner.MultiNodeProjectDeploymentHookMetadata metadata, DeploymentReportForPostHooksCode deploymentReport) throws IOException, DKUSecurityException {
        this.simplePythonKernel.getLink().sendRequest((Object)new LoadProjectMetadataCommand(requestingUser.getAssociatedDSSUserMand(), metadata.deployingUser, metadata.deployment.id, null, null, metadata.nodeConnections, metadata.trustAllSSLCertificates, metadata.deployment.getTargetProjectKey(), deploymentReport));
        this.simplePythonKernel.getLink().receiveJsonResponse(LoadProjectMetadataResultResponse.class);
    }

    public void loadApiMetadata(AuthCtx requestingUser, DeploymentHooksRunner.ApiDeploymentHookMetadata metadata, DeploymentReportForPostHooksCode deploymentReportForPostHooksCode) throws IOException, DKUSecurityException {
        this.simplePythonKernel.getLink().sendRequest((Object)new LoadApiMetadataCommand(requestingUser.getAssociatedDSSUserMand(), metadata.apiServiceDeployment.id, deploymentReportForPostHooksCode));
        this.simplePythonKernel.getLink().receiveJsonResponse(LoadApiMetadataResultResponse.class);
    }

    public DeploymentHookResult execute(DeploymentHook hook) throws IOException {
        this.simplePythonKernel.getLink().sendRequest((Object)new ExecuteHookCommand(hook));
        ExecuteHookResultResponse response = (ExecuteHookResultResponse)this.simplePythonKernel.getLink().receiveJsonResponse(ExecuteHookResultResponse.class);
        return response.result;
    }

    static class LoadProjectMetadataCommand
    extends Command {
        String requestingUser;
        String deployingUser;
        String deploymentId;
        String automationNodeUrl;
        String automationNodeApiKey;
        List<NodeConnection> automationConnectionInfos;
        boolean trustAllSSLCertificates;
        String deployedProjectKey;
        DeploymentReportForPostHooksCode deploymentReport;

        public LoadProjectMetadataCommand(String requestingUser, String deployingUser, String deploymentId, String automationNodeUrl, String automationNodeApiKey, List<NodeConnection> nodeConnections, boolean trustAllSSLCertificates, String deployedProjectKey, DeploymentReportForPostHooksCode deploymentReportForPostHooksCode) {
            this.requestingUser = requestingUser;
            this.deployingUser = deployingUser;
            this.deploymentId = deploymentId;
            this.automationNodeUrl = automationNodeUrl;
            this.automationNodeApiKey = automationNodeApiKey;
            this.automationConnectionInfos = nodeConnections;
            this.trustAllSSLCertificates = trustAllSSLCertificates;
            this.deployedProjectKey = deployedProjectKey;
            this.deploymentReport = deploymentReportForPostHooksCode;
        }

        private LoadProjectMetadataCommand() {
        }
    }

    static class LoadProjectMetadataResultResponse
    extends Response {
        LoadProjectMetadataResultResponse() {
        }
    }

    static class LoadApiMetadataCommand
    extends Command {
        String requestingUser;
        String deploymentId;
        DeploymentReportForPostHooksCode deploymentReport;

        public LoadApiMetadataCommand(String requestingUser, String deploymentId, DeploymentReportForPostHooksCode deploymentReportForPostHooksCode) {
            this.requestingUser = requestingUser;
            this.deploymentId = deploymentId;
            this.deploymentReport = deploymentReportForPostHooksCode;
        }

        private LoadApiMetadataCommand() {
        }
    }

    static class LoadApiMetadataResultResponse
    extends Response {
        LoadApiMetadataResultResponse() {
        }
    }

    static class ExecuteHookCommand
    extends Command {
        DeploymentHook hook;

        public ExecuteHookCommand(DeploymentHook hook) {
            this.hook = hook;
        }

        private ExecuteHookCommand() {
        }
    }

    static class ExecuteHookResultResponse
    extends Response {
        DeploymentHookResult result;

        ExecuteHookResultResponse() {
        }
    }

    @PolyJSON(value={@Mapping(value=LoadProjectMetadataResultResponse.class, type="LoadProjectMetadataResult"), @Mapping(value=LoadApiMetadataResultResponse.class, type="LoadApiMetadataResult"), @Mapping(value=ExecuteHookResultResponse.class, type="ExecuteHookResult")})
    static abstract class Response {
        Response() {
        }
    }

    @PolyJSON(value={@Mapping(value=LoadProjectMetadataCommand.class, type="LoadProjectMetadata"), @Mapping(value=LoadApiMetadataCommand.class, type="LoadApiMetadata"), @Mapping(value=ExecuteHookCommand.class, type="ExecuteHook")})
    static abstract class Command {
        Command() {
        }
    }
}

