/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.common.infra;

import com.dataiku.dip.dao.AbstractGlobalDAO;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.deployer.common.infra.DeploymentInfrasDAO;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.google.common.base.Preconditions;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class FilesBasedDeploymentInfrasDAO<T extends AbstractDeploymentInfra>
extends AbstractGlobalDAO<T>
implements DeploymentInfrasDAO<T> {
    public static final String INFRAS = "infras";

    protected abstract T readDeploymentInfra(TransactionRef var1, RelFile var2, boolean var3, String var4) throws IOException;

    protected List<T> list(boolean unsafe) throws IOException {
        TransactionRef tr = TransactionContext.retrieveRead();
        RelFile folder = this.deploymentInfrasDir();
        ArrayList<T> ret = new ArrayList<T>();
        if (tr.isDirectory(folder)) {
            for (RelFile file : tr.listFiles(folder)) {
                if (!file.getLeafName().endsWith(".json")) continue;
                try {
                    String infraId = file.getLeafName().replace(".json", "");
                    ret.add(this.readDeploymentInfra(tr, file, unsafe, infraId));
                }
                catch (JsonParseException | IOException e) {
                    this.logger.warn((Object)("Failed to read deployment infra " + String.valueOf(file)), e);
                }
            }
        }
        return ret;
    }

    protected T getOrNull(String id, boolean unsafe) throws IOException {
        RelFile file;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (tr.exists(file = this.getDAOFile(id))) {
            return this.readDeploymentInfra(tr, file, unsafe, id);
        }
        return null;
    }

    @Override
    public void save(AbstractDeploymentInfra deploymentInfra) throws IOException {
        assert (deploymentInfra.id != null);
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        RelFile file = this.getDAOFile(deploymentInfra.id);
        tr.writeObject(file, (Object)deploymentInfra);
    }

    public void delete(String id) throws IOException {
        RWTransactionRef tr = TransactionContext.retrieveWrite();
        tr.deleteFile(this.getDAOFile(id));
    }

    public int approximateCount() throws IOException {
        RelFile folder;
        TransactionRef tr = TransactionContext.retrieveRead();
        if (!tr.isDirectory(folder = this.deploymentInfrasDir())) {
            return 0;
        }
        return tr.listFiles(folder).size();
    }

    protected abstract RelFile deploymentInfrasDir();

    protected RelFile getDAOFile(String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Deployment infra id is not specified");
        return new RelFile(this.deploymentInfrasDir(), new String[]{id + ".json"});
    }
}

