/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.File;
import java.io.IOException;

public class PdfConverter {

    public static class LibreOfficeExecutionResults {
        public File outputFile;
        DKUtils.ExecutionResults executionResults;
        public boolean ok;
        public Throwable error;

        public static LibreOfficeExecutionResults fromSuccess(File convertedFile, DKUtils.ExecutionResults executionResults) {
            LibreOfficeExecutionResults resp = new LibreOfficeExecutionResults();
            resp.ok = true;
            resp.outputFile = convertedFile;
            resp.executionResults = executionResults;
            return resp;
        }

        public static LibreOfficeExecutionResults fromError(Throwable e) {
            LibreOfficeExecutionResults resp = new LibreOfficeExecutionResults();
            resp.ok = false;
            resp.error = e;
            return resp;
        }

        public static LibreOfficeExecutionResults fromMissingOutputFile(DKUtils.ExecutionResults executionResults, String message) {
            LibreOfficeExecutionResults resp = new LibreOfficeExecutionResults();
            resp.ok = false;
            resp.executionResults = executionResults;
            resp.error = new Exception(message);
            return resp;
        }
    }

    public static class PDFConverterResponseOrError {
        public boolean ok;
        public InputRefs.DocumentRef documentRef;
        public Throwable throwable;
        public String errorMessage;

        public static PDFConverterResponseOrError fromSuccess(InputRefs.ManagedFolderDocumentRef managedFolderDocumentRef) throws IOException {
            PDFConverterResponseOrError resp = new PDFConverterResponseOrError();
            resp.ok = true;
            resp.documentRef = managedFolderDocumentRef;
            return resp;
        }

        public static PDFConverterResponseOrError fromError(Throwable e) throws IOException {
            PDFConverterResponseOrError resp = new PDFConverterResponseOrError();
            resp.ok = false;
            resp.throwable = e;
            resp.errorMessage = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return resp;
        }
    }

    public static class PDFConverterInputs {
        public InputRefs.DocumentRef document;
    }

    public static class PDFConverterRequest {
        public PDFConverterInputs inputs = new PDFConverterInputs();
        public String outputManagedFolderRef;
        public String outputFilePath;
    }
}

