/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.window.WindowRecipeMeta;
import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.helpers.PlaceholderOutputFactory;
import com.dataiku.dip.docgen.resolver.IterableDescription;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.recipes.RecipeMeta;
import java.util.Collection;

public abstract class WindowPlaceholder
implements FlowPlaceholder.TextPlaceholder<WindowRecipePayloadParams.WindowDesc> {
    @Override
    public Class<WindowRecipePayloadParams.WindowDesc> getInputType() {
        return WindowRecipePayloadParams.WindowDesc.class;
    }

    public static class PartitioningColumns
    extends WindowPlaceholder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, WindowRecipePayloadParams.WindowDesc windowDesc) throws PlaceholderExpectedException {
            if (!windowDesc.enablePartitioning) {
                return new PlaceholderOutput.Text("Partitioning is not enabled");
            }
            if (windowDesc.partitioningColumns == null || windowDesc.partitioningColumns.isEmpty()) {
                return new PlaceholderOutput.Text("No partitioning columns are defined");
            }
            return new PlaceholderOutput.Text(String.join((CharSequence)", ", windowDesc.partitioningColumns));
        }
    }

    public static class Name
    extends WindowPlaceholder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, WindowRecipePayloadParams.WindowDesc windowDesc) throws PlaceholderExpectedException {
            return PlaceholderOutputFactory.makeTextOutputMaybeNull(windowDesc.name);
        }
    }

    public static class WindowsIterable
    implements FlowPlaceholder.IterablePlaceholder<SerializedRecipe, WindowRecipePayloadParams.WindowDesc> {
        @Override
        public IterableDescription<SerializedRecipe, WindowRecipePayloadParams.WindowDesc> getDescription() {
            return IterableDescription.iterablePlaceholder(SerializedRecipe.class, WindowRecipePayloadParams.WindowDesc.class, "$window");
        }

        @Override
        public Collection<WindowRecipePayloadParams.WindowDesc> resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            return context.getCachedPayloadAs((SerializedRecipe)recipe, WindowRecipePayloadParams.class, (RecipeMeta)WindowRecipeMeta.META).windows;
        }
    }
}

