/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.documenttemplating;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.documenttemplating.DocumentTemplatingInput;
import com.dataiku.dip.documenttemplating.DocumentTemplatingOutput;
import com.dataiku.dip.documenttemplating.DocumentTemplatingServer;
import com.dataiku.dip.documenttemplating.DocumentTemplatingServerAPI;
import com.dataiku.dip.documenttemplating.DocumentTemplatingServerKernelDesc;
import com.dataiku.dip.kernel.DSSKernelUtils;
import com.dataiku.dip.kernel.KernelPool;
import com.dataiku.dip.llm.LLMRelatedPoolablePythonServerKernelPool;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKUCompletableFuture;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.SmartLogTail;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DocumentTemplatingServerPool
extends LLMRelatedPoolablePythonServerKernelPool<DocumentTemplatingServer, DocumentTemplatingServerKernelDesc, DocumentTemplatingServerKernelDesc> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.documenttemplating.pool");

    public DocumentTemplatingServerPool() {
        super("document-templating");
        this.setManager(new KernelPool((KernelPool.KernelController)new LLMRelatedPoolablePythonServerKernelPool.LLMRelatedPoolablePythonServerKernelController("dku.documenttemplating"){

            @Nonnull
            public DocumentTemplatingServer createKernel(DocumentTemplatingServerKernelDesc kernelDesc) {
                return new DocumentTemplatingServer(kernelDesc.authCtx, kernelDesc.projectKey, CodeEnvSelection.explicitEnv(kernelDesc.envName), kernelDesc.containerConfName);
            }

            @Nonnull
            public CompletableFuture<Void> startKernel(DocumentTemplatingServer kernel, DocumentTemplatingServerKernelDesc kernelDesc) {
                File logBaseDir = DKUApp.getFile((String[])new String[]{"document-templating", kernelDesc.projectKey, "logs"});
                return DKUCompletableFuture.runAsync(() -> {
                    DSSKernelUtils.setKernelContext(kernelDesc.cruContext, kernelDesc.jobContext, logger);
                    kernel.init(kernelDesc.isDevKernel, false, logBaseDir);
                }, (Executor)DocumentTemplatingServerPool.this.executorService);
            }

            public Long getQueuedRequestTimeoutInNs() {
                return ApplicationConfigurator.getParams().getLongParam(this.propertiesPrefix + ".queuedRequestTimeoutInS", 300L) * 1000L * 1000L * 1000L;
            }

            @Override
            public int getGlobalMaxKernelCount() {
                return ApplicationConfigurator.getParams().getIntParam(this.propertiesPrefix + ".maxKernels", Integer.valueOf(10));
            }

            public Integer getMaxKernelCount(DocumentTemplatingServerKernelDesc kernelDesc) {
                return this.getGlobalMaxKernelCount();
            }

            public int getHardMaxParallelRequests(DocumentTemplatingServerKernelDesc kernelDesc) {
                return ApplicationConfigurator.getParams().getIntParam(this.propertiesPrefix + ".hardMaxRequestsPerKernel", Integer.valueOf(16));
            }

            public int getSoftMaxParallelRequests(DocumentTemplatingServerKernelDesc kernelDesc) {
                return ApplicationConfigurator.getParams().getIntParam(this.propertiesPrefix + ".softMaxRequestsPerKernel", Integer.valueOf(16));
            }

            public boolean isOutdated(DocumentTemplatingServerKernelDesc kernelDesc) {
                return false;
            }

            public SmartLogTail getKernelLog(DocumentTemplatingServer kernel) {
                return kernel.getKernelLog();
            }
        }, "document-templating", logger));
    }

    public DocumentTemplatingServerAPI getServerAPI(DSSAuthCtx authCtx, String projectKey, String envName, String containerConfName) throws IOException {
        final DocumentTemplatingServerKernelDesc kernelDesc = new DocumentTemplatingServerKernelDesc();
        kernelDesc.authCtx = authCtx;
        kernelDesc.projectKey = projectKey;
        kernelDesc.envName = envName;
        kernelDesc.containerConfName = containerConfName;
        kernelDesc.isDevKernel = false;
        kernelDesc.poolKey = authCtx.getIdentifier() + "-" + projectKey + "-" + DigestUtils.sha1Hex((String)StringUtils.join((Object[])new String[]{envName, containerConfName}, (String)"__DKU__"));
        return new DocumentTemplatingServerAPI(){

            @Override
            public CompletableFuture<DocumentTemplatingOutput> renderAsync(DocumentTemplatingInput input) {
                return DocumentTemplatingServerPool.this.manager.handle(kernel -> kernel.renderAsync(input), (Object)kernelDesc, kernelDesc.poolKey, (Object)input);
            }

            @Override
            public SmartLogTail getKernelLog() {
                SmartLogTail fakeSLT = new SmartLogTail();
                fakeSLT.appendLine("Production kernels can't return logs");
                return fakeSLT;
            }

            @Override
            public void close() throws IOException {
            }
        };
    }
}

