/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.engine.python;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.eda.EdaErrorCodes;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.compute.engine.python.EDAKernelProtocol;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.io.input.ProxyInputStream;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;

public class EDAKernelComputationResultDataStreamer
implements ComputationResultDataStreamer {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.eda.compute.python");
    private final SimplePythonKernel kernel;
    private final Lock lock;

    public EDAKernelComputationResultDataStreamer(SimplePythonKernel kernel, Lock lock) {
        this.kernel = kernel;
        this.lock = lock;
    }

    @Override
    public InputStream streamData(ComputationResultDataStreamer.DataStreamId sId) throws Exception {
        boolean errorCaught = false;
        this.lock.lockInterruptibly();
        try {
            this.kernel.getLink().sendRequest((Object)new EDAKernelProtocol.FetchDataStreamCommand(sId));
            InputStream is = this.kernel.getLink().receiveStream();
            KernelDataInputStream kernelDataInputStream = new KernelDataInputStream(is, sId);
            return kernelDataInputStream;
        }
        catch (Exception e) {
            errorCaught = true;
            logger.errorV((Throwable)e, "Error occurred while streaming data (id: %s) to the backend", new Object[]{sId.value});
            this.kernel.close();
            throw new CodedException((InfoMessage.MessageCode)EdaErrorCodes.ERR_EDA_COMPUTE_KERNEL_FAILURE, "Could not start data stream from the EDA kernel", (Throwable)e);
        }
        finally {
            if (errorCaught) {
                this.lock.unlock();
            }
        }
    }

    private class KernelDataInputStream
    extends ProxyInputStream {
        private final ComputationResultDataStreamer.DataStreamId dataStreamId;
        private EDAKernelProtocol.DataStreamEndedResponse kernelHandshake;
        private boolean isClosed;
        private boolean isConsumed;

        public KernelDataInputStream(InputStream proxy, ComputationResultDataStreamer.DataStreamId dataStreamId) {
            super(proxy);
            this.dataStreamId = dataStreamId;
            this.kernelHandshake = null;
            this.isClosed = false;
            this.isConsumed = false;
        }

        protected void afterRead(int n) throws IOException {
            if (n != -1) {
                return;
            }
            this.isConsumed = true;
            if (this.kernelHandshake == null) {
                this.kernelHandshake = (EDAKernelProtocol.DataStreamEndedResponse)EDAKernelComputationResultDataStreamer.this.kernel.getLink().receiveJsonResponse(EDAKernelProtocol.DataStreamEndedResponse.class);
            }
            if (this.kernelHandshake.error != null) {
                throw new IOException(String.format("Streaming data id=%s failed with message: %s", this.dataStreamId.value, this.kernelHandshake.error));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            KernelDataInputStream kernelDataInputStream = this;
            synchronized (kernelDataInputStream) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
            }
            try {
                if (!this.isConsumed) {
                    ByteStreams.exhaust((InputStream)((Object)this));
                }
                super.close();
            }
            finally {
                EDAKernelComputationResultDataStreamer.this.lock.unlock();
            }
        }
    }
}

