/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ContainerSettings;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.export.CustomExporterDesc;
import com.dataiku.dip.export.CustomLoadedExporter;
import com.dataiku.dip.export.CustomPythonExporterDesc;
import com.dataiku.dip.export.CustomPythonExportersService;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.export.LoadedPythonExporter;
import com.dataiku.dip.export.output.ContainerizedCustomPythonExportFileOutput;
import com.dataiku.dip.export.output.ContainerizedCustomPythonExportOutput;
import com.dataiku.dip.export.output.CustomPythonExportFileOutput;
import com.dataiku.dip.export.output.CustomPythonExportOutput;
import com.dataiku.dip.export.output.ExportOutput;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;

public class CustomPythonExporter
extends CustomLoadedExporter<LoadedPythonExporter> {
    private CustomPythonExportersService customPythonExporterService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.export");

    public CustomPythonExporter(LoadedPythonExporter loaded, CustomPythonExportersService customPythonExporterService) {
        super(loaded);
        this.customPythonExporterService = customPythonExporterService;
    }

    public ContainerExecRuntimeConfig getContainerConfigOrNull(AuthCtx authCtx, String projectKey) {
        ContainerExecRuntimeConfig containerConfig;
        String excludedList = ApplicationConfigurator.getParams().getParam("dku.exporter.excludedFromContainers", "");
        if (StringUtils.isNotBlank((String)excludedList)) {
            for (String excluded : excludedList.split(",")) {
                if (!excluded.trim().equals(((LoadedPythonExporter)this.loaded).getOwnerPluginId())) continue;
                return null;
            }
        }
        String confName = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().containerSettings.defaultExecutionConfigForExporters;
        try {
            ContainerSettings containerSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getContainerSettings();
            containerConfig = containerSettings.getByNameOrNull(confName);
            String imageTag = null;
            if (containerConfig != null && ((DSSAuthCtx)authCtx).canUseContainerConf((ContainerExecRuntimeConfig)containerConfig).ok) {
                String envName = new CodeEnvSelector().getCodeEnvNameForPlugin(((LoadedPythonExporter)this.loaded).ownerPluginId);
                imageTag = ContainerExecImagesHelper.getImageTagToUseOrNull(containerConfig.dockerHost, containerConfig.baseImage, ContainerExecUtils.BaseImageType.EXEC, CodeEnvModel.EnvLang.PYTHON, envName, null);
            }
            if (StringUtils.isEmpty(imageTag)) {
                logger.info((Object)"No usable image for exporter, don't containerize");
                containerConfig = null;
            }
        }
        catch (Exception e) {
            containerConfig = null;
            logger.warn((Object)"Cannot containerize exporter", (Throwable)e);
        }
        return containerConfig;
    }

    @Override
    public ExportOutput create(AuthCtx authCtx, ExportStatus status, ExportParams params, OutputStream os) throws IOException {
        ContainerExecRuntimeConfig containerConfig;
        boolean canContainerize = ApplicationConfigurator.getProcessType() == MainLoggingConfigurator.ProcessType.BACKEND || ApplicationConfigurator.getProcessType() == MainLoggingConfigurator.ProcessType.JEK;
        ContainerExecRuntimeConfig containerExecRuntimeConfig = containerConfig = canContainerize ? this.getContainerConfigOrNull(authCtx, params.contextProjectKey) : null;
        if (containerConfig != null) {
            logger.info((Object)"Export can run in containers");
            if (((CustomPythonExporterDesc)((LoadedPythonExporter)this.loaded).desc).exportBehavior == CustomExporterDesc.ExportBehavior.OUTPUT_TO_FILE) {
                return new ContainerizedCustomPythonExportFileOutput(new File(status.targetFile), (DSSAuthCtx)authCtx, params.contextProjectKey, params.config, (LoadedPythonExporter)this.loaded, containerConfig, this.customPythonExporterService);
            }
            return new ContainerizedCustomPythonExportOutput((DSSAuthCtx)authCtx, params.contextProjectKey, params.config, (LoadedPythonExporter)this.loaded, containerConfig, this.customPythonExporterService);
        }
        if (((CustomPythonExporterDesc)((LoadedPythonExporter)this.loaded).desc).exportBehavior == CustomExporterDesc.ExportBehavior.OUTPUT_TO_FILE) {
            return new CustomPythonExportFileOutput(new File(status.targetFile), authCtx, params.contextProjectKey, params.config, (LoadedPythonExporter)this.loaded, this.customPythonExporterService);
        }
        return new CustomPythonExportOutput(authCtx, params.contextProjectKey, params.config, (LoadedPythonExporter)this.loaded, this.customPythonExporterService);
    }
}

