/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.output;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.export.CustomExporterDesc;
import com.dataiku.dip.export.CustomExporterPythonKernel;
import com.dataiku.dip.export.CustomPythonExportersService;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.LoadedPythonExporter;
import com.dataiku.dip.export.output.ContainerizedCustomPythonExportOutput;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;

public class ContainerizedCustomPythonExportFileOutput
extends ContainerizedCustomPythonExportOutput {
    private File outputFile;
    private File fileFromPython;
    private static Logger logger = Logger.getLogger((String)"dip.pyexporter.containerized.file.output");

    public ContainerizedCustomPythonExportFileOutput(File destinationFile, DSSAuthCtx authCtx, String projectKey, JsonObject config, LoadedPythonExporter loaded, ContainerExecRuntimeConfig containerConfig, CustomPythonExportersService customPythonExporterService) {
        super(authCtx, projectKey, config, loaded, containerConfig, customPythonExporterService);
        this.outputFile = destinationFile;
    }

    @Override
    protected CustomExporterPythonKernel.SendFileBackMode sendFileBack() {
        if (this.loaded.getCompression() == CustomExporterDesc.ExportCompression.DIR_TO_ZIP) {
            return CustomExporterPythonKernel.SendFileBackMode.DIR;
        }
        return CustomExporterPythonKernel.SendFileBackMode.FILE;
    }

    @Override
    protected String getDestinationFilePath() {
        if (this.loaded.getCompression() == CustomExporterDesc.ExportCompression.FILE_OR_STREAM_TO_GZIP) {
            return new File(this.outputFile.getParentFile(), "temp.out").getAbsolutePath();
        }
        return this.outputFile.getAbsolutePath();
    }

    @Override
    public void initialize(ExportService.LocalExportJob job, Schema schema, ColumnFactory cf) throws Exception {
        DKUFileUtils.mkdirsParent((File)this.outputFile);
        this.fileFromPython = this.loaded.getCompression() == null ? new File(this.outputFile.getParentFile(), "temp.out") : this.outputFile;
        super.initialize(job, schema, cf);
    }

    @Override
    protected SecretProtectedKernelLink.AcknowledgeResponse checkResult() throws IOException {
        try (InputStream is = this.link.receiveStream();
             FileOutputStream fos = new FileOutputStream(this.fileFromPython);){
            IOUtils.copy((InputStream)is, (OutputStream)fos);
        }
        return super.checkResult();
    }

    @Override
    public long getWrittenBytes() throws Exception {
        return this.outputFile.length();
    }

    @Override
    public void close() {
        super.close();
        if (this.loaded.getCompression() == null) {
            try (FileInputStream fis = new FileInputStream(this.fileFromPython);
                 FileOutputStream fos = new FileOutputStream(this.outputFile);
                 GZIPInputStream gis = new GZIPInputStream(fis);){
                IOUtils.copy((InputStream)gis, (OutputStream)fos);
            }
            catch (IOException e) {
                logger.error((Object)"Failed to uncompress export output", (Throwable)e);
            }
        }
    }
}

