/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.custom;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.formats.custom.CustomFormatPythonKernel;
import com.dataiku.dip.formats.custom.CustomPythonFormatsService;
import com.dataiku.dip.formats.custom.LoadedPythonFormat;
import com.dataiku.dip.input.formats.ArchiveCapableFormatExtractor;
import com.dataiku.dip.input.formats.csv.RFC4180CSVParser;
import com.dataiku.dip.input.stream.InputStreamLineReader;
import com.dataiku.dip.input.stream.LineReader;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.plugin.InputStreamWithContextInfo;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CustomPythonFormatExtractor
extends ArchiveCapableFormatExtractor {
    protected final AuthCtx authCtx;
    protected final String projectKey;
    protected final LoadedPythonFormat loaded;
    protected final CustomPythonFormatsService service;
    protected final JsonObject config;
    protected SingleCommandKernelLink link;
    protected CustomFormatPythonKernel kernel;
    private static Logger logger = Logger.getLogger((String)"dku.formats.custom.input");

    public CustomPythonFormatExtractor(AuthCtx authCtx, String projectKey, JsonObject config, LoadedPythonFormat loaded, CustomPythonFormatsService service) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.config = config;
        this.loaded = loaded;
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doExtractStream(InputStreamWithContextInfo isn, ProcessorOutput output, ColumnFactory cf, RowFactory rf, ArchiveCapableFormatExtractor.ArchiveCapableObserver observer) throws Exception {
        InputStream is = isn.getInputStream();
        String secret = SecretKeyGenerator.generate((int)16);
        PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
        this.link = new SingleCommandKernelLink(secret, dssPortRange);
        String envName = new CodeEnvSelector().getCodeEnvNameForPlugin(this.loaded.ownerPluginId);
        this.kernel = new CustomFormatPythonKernel(this.authCtx, this.link, this.service.getResourceFolder(this.loaded.getType()), this.service.getLibFolder(this.loaded.getType()), this.projectKey, envName);
        this.kernel.start();
        PipedOutputStream pos = new PipedOutputStream();
        PipedInputStream csvInputStream = new PipedInputStream(pos);
        RFC4180CSVParser csvReader = new RFC4180CSVParser((LineReader)new InputStreamLineReader((InputStream)csvInputStream, "utf8"), ',');
        PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.service.getExpandedPluginSettings(this.loaded.getType(), this.authCtx, this.projectKey, this.config);
        String code = this.service.getCode(this.loaded.getType());
        CustomFormatPythonKernel.PythonCommand req = new CustomFormatPythonKernel.PythonCommand("read", code, this.schema, expandedPluginSettings.config, expandedPluginSettings.pluginConfig);
        SingleCommandKernelLink.IOCallable commandResult = this.link.executeStreamAsync((Object)req, (InputStream)new BufferedInputStream(is, 0x100000), (OutputStream)pos);
        try {
            CsvRowToRow translator = this.schema == null ? new FreeSchemaCsvRowToRow(cf) : new SchemaConstrainedCsvRowToRow(cf, this.schema, this.allowExtraColumns);
            int readRows = 0;
            ArrayList<String> out = new ArrayList<String>();
            while (csvReader.next(out)) {
                Row r = rf.row();
                translator.translate(out, r);
                ++readRows;
                if (observer != null) {
                    if (!observer.checkLimit(readRows)) {
                        throw new EarlyKillException();
                    }
                    if (readRows % 1000 == 0) {
                        observer.onInterval(readRows);
                    }
                }
                output.emitRow(r);
            }
            if (observer != null) {
                observer.onEnd(readRows);
            }
            try {
                commandResult.call();
            }
            catch (Throwable throwable) {
                SecretProtectedKernelLink.AcknowledgeResponse ack = this.link.acknowledgeLastCall((DSSKernelBase)this.kernel, null, "Failed during remote read");
                logger.info((Object)("Read " + ack.count + " records"));
                throw throwable;
            }
            SecretProtectedKernelLink.AcknowledgeResponse ack = this.link.acknowledgeLastCall((DSSKernelBase)this.kernel, null, "Failed during remote read");
            logger.info((Object)("Read " + ack.count + " records"));
            boolean bl = true;
            return bl;
        }
        catch (EarlyKillException e) {
            logger.info((Object)"Aborting python worker");
            boolean bl = false;
            return bl;
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail((IDSSKernelBase)this.kernel);
            throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
        }
        finally {
            logger.info((Object)"Cleaning up python worker");
            this.link.close();
            this.kernel.killWithoutMercy();
        }
    }

    private Map<Column, String> getDataFromJson(ColumnFactory cf, String json) {
        HashMap data = Maps.newHashMap();
        JsonObject jo = (JsonObject)JSON.parse((String)json, JsonObject.class);
        for (Map.Entry entry : jo.entrySet()) {
            Column c2 = cf.column((String)entry.getKey());
            if (entry.getValue() != null && ((JsonElement)entry.getValue()).isJsonPrimitive()) {
                data.put(c2, ((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            if (entry.getValue() == null) continue;
            data.put(c2, ((JsonElement)entry.getValue()).toString());
        }
        return data;
    }

    private class FreeSchemaCsvRowToRow
    implements CsvRowToRow {
        private final ColumnFactory cf;

        public FreeSchemaCsvRowToRow(ColumnFactory cf) {
            this.cf = cf;
        }

        @Override
        public void translate(List<String> out, Row row) {
            if (out.size() == 1) {
                for (Map.Entry<Column, String> e : CustomPythonFormatExtractor.this.getDataFromJson(this.cf, out.get(0)).entrySet()) {
                    row.put(e.getKey(), e.getValue());
                }
            }
        }
    }

    private class SchemaConstrainedCsvRowToRow
    implements CsvRowToRow {
        private final List<Column> schemaColumns;
        private final ColumnFactory cf;
        private final boolean allowExtra;

        public SchemaConstrainedCsvRowToRow(ColumnFactory cf, Schema schema, boolean allowExtra) {
            this.cf = cf;
            this.allowExtra = allowExtra;
            this.schemaColumns = Lists.newArrayList();
            for (SchemaColumn column : schema.getColumns()) {
                Column c2 = cf.column(column.getName());
                this.schemaColumns.add(c2);
            }
        }

        @Override
        public void translate(List<String> out, Row row) {
            for (int i = 0; i < this.schemaColumns.size(); ++i) {
                row.put(this.schemaColumns.get(i), out.get(i));
            }
            if (out.size() == this.schemaColumns.size() + 1 && StringUtils.isNotBlank((String)out.get(out.size() - 1)) && this.allowExtra) {
                for (Map.Entry<Column, String> e : CustomPythonFormatExtractor.this.getDataFromJson(this.cf, out.get(out.size() - 1)).entrySet()) {
                    row.put(e.getKey(), e.getValue());
                }
            }
        }
    }

    private static interface CsvRowToRow {
        public void translate(List<String> var1, Row var2);
    }

    private static class EarlyKillException
    extends Exception {
        private static final long serialVersionUID = 4876123295102331785L;

        private EarlyKillException() {
        }
    }
}

