/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.custom;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomPythonElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.export.ExportOption;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.custom.CustomPythonFormatDesc;
import com.dataiku.dip.formats.custom.CustomPythonFormatMeta;
import com.dataiku.dip.formats.custom.LoadedPythonFormat;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CustomPythonFormatsService
extends CustomPythonElementService<CustomPythonFormatDesc, LoadedPythonFormat> {
    @Override
    public String getFolderName() {
        return "python-formats";
    }

    @Override
    public String getPrefix() {
        return "format";
    }

    @Override
    protected String getCodeExtension(LoadedPythonFormat desc) {
        return ".py";
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "format_" + pluginId + "_" + elementId;
    }

    @Override
    public Class<CustomPythonFormatDesc> getDescClass() {
        return CustomPythonFormatDesc.class;
    }

    @Override
    public Class<LoadedPythonFormat> getLoadedDescClass() {
        return LoadedPythonFormat.class;
    }

    @Override
    protected void removeElement(LoadedPythonFormat loaded) {
        FormatFactory.deregisterFormatType(loaded.getType());
    }

    @Override
    protected LoadedPythonFormat load(String elementType, String pluginId, String elementId, File file) throws IOException {
        LoadedPythonFormat loaded = new LoadedPythonFormat(elementType, pluginId, elementId, (CustomPythonFormatDesc)JSON.parseFile((File)file, CustomPythonFormatDesc.class));
        FormatFactory.registerFormatType(new CustomPythonFormatMeta(loaded, this));
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomPythonFormatDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomPythonFormatsService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                if (desc.exportOptions != null) {
                    for (ExportOption o : desc.exportOptions) {
                        if (o == null) {
                            this.withWarning("Null export option. Check there is no trailing comma.");
                            continue;
                        }
                        if (!StringUtils.isBlank((String)o.id)) continue;
                        this.withFatal("Export option has no id.");
                    }
                }
                return this.messages;
            }
        }.validate();
    }
}

