/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.impala;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ImpalaSettings;
import com.dataiku.dip.connections.ImpalaConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.impala.HighAvailabilityHost;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ImpalaConfigurator {
    private static boolean hiveEnabled = "true".equals(System.getenv("DKU_HIVE_ENABLED"));
    private static Boolean impalaAvailabilityBaseCache;
    private static HighAvailabilityHost lastUsedHost;
    private static Logger logger;

    public static void setLastUsedHost(HighAvailabilityHost host) {
        lastUsedHost = host;
    }

    public static ImpalaConnection configureConnectionForDatabase(AuthCtx authCtx, String databaseName) throws IOException, DKUSecurityException {
        String virtualName = "@virtual(impala-jdbc):" + databaseName;
        ImpalaConnection conn = new ImpalaConnection();
        SpringUtils.getInstance().autowire((Object)conn);
        conn.name = virtualName;
        conn.allowWrite = false;
        conn.allowManagedDatasets = false;
        conn.params.db = databaseName;
        return conn;
    }

    public static void setupConnectionFromSettings(ImpalaConnection conn, ImpalaSettings impalaSettings) {
        if (impalaSettings == null) {
            impalaSettings = new ImpalaSettings();
            impalaSettings.authBehavior = ImpalaSettings.AuthBehavior.NOAUTH;
            String server = System.getenv("DKU_IMPALA_SERVER_HOSTNAME");
            String port = System.getenv("DKU_IMPALA_SERVER_PORT");
            if (StringUtils.isNotBlank((String)server)) {
                impalaSettings.datanodes.add(new HighAvailabilityHost(server));
            }
            if (StringUtils.isNotBlank((String)port)) {
                impalaSettings.port = Integer.valueOf(port);
            }
        }
        conn.credentialsMode = impalaSettings.credentialsMode;
        ImpalaConfigurator.setupParamsFromSettings(conn.params, impalaSettings);
    }

    private static void setupParamsFromSettings(ImpalaConnection.Params params, ImpalaSettings impalaSettings) {
        int i;
        params.useUrl = impalaSettings.useURL;
        params.customUrl = impalaSettings.url;
        params.customDisplayedUrl = impalaSettings.displayedUrl;
        params.customDriver = impalaSettings.driver;
        params.properties = impalaSettings.connectionProperties.getAsConnectionProperties();
        params.useSsl = impalaSettings.useSsl;
        params.isSelfSigned = impalaSettings.isSelfSigned;
        params.trustStorePassword = impalaSettings.trustStorePassword;
        params.trustStorePath = impalaSettings.trustStorePath;
        params.useSimbaDriver = impalaSettings.useSimbaDriver;
        params.authBehavior = impalaSettings.authBehavior == ImpalaSettings.AuthBehavior.KERBEROS_FALLBACK_NOAUTH ? (StringUtils.isNotBlank((String)impalaSettings.principal) && HadoopLoader.isSecurityEnabled() ? ImpalaSettings.AuthBehavior.KERBEROS : ImpalaSettings.AuthBehavior.NOAUTH) : impalaSettings.authBehavior;
        if (params.authBehavior == ImpalaSettings.AuthBehavior.KERBEROS) {
            params.principal = StringUtils.defaultIfBlank((String)impalaSettings.principal, (String)"");
        } else if (params.authBehavior == ImpalaSettings.AuthBehavior.LDAP) {
            params.user = impalaSettings.user;
            params.password = impalaSettings.password;
        } else if (params.authBehavior != ImpalaSettings.AuthBehavior.NOAUTH) {
            throw new IllegalArgumentException("Impala cannot authenticate with " + String.valueOf((Object)params.authBehavior));
        }
        if (impalaSettings.datanodes != null && impalaSettings.datanodes.size() > 0) {
            ArrayList datanodes = Lists.newArrayList();
            for (HighAvailabilityHost datanode : impalaSettings.datanodes) {
                if (!StringUtils.isNotBlank((String)datanode.fqn)) continue;
                datanodes.add(datanode);
            }
            params.datanodes = datanodes;
        }
        if (params.datanodes.size() == 0) {
            params.datanodes.add(new HighAvailabilityHost("127.0.0.1"));
        }
        for (HighAvailabilityHost datanode : params.datanodes) {
            if (datanode.port != 0) continue;
            datanode.port = impalaSettings.port;
        }
        int lastUsedHostIdx = -1;
        for (i = 0; i < params.datanodes.size(); ++i) {
            HighAvailabilityHost datanode;
            datanode = params.datanodes.get(i);
            if (!datanode.equals(lastUsedHost)) continue;
            lastUsedHostIdx = i;
        }
        for (i = 0; i < lastUsedHostIdx; ++i) {
            HighAvailabilityHost pushAtEnd = params.datanodes.get(0);
            params.datanodes.remove(0);
            params.datanodes.add(pushAtEnd);
        }
        ImpalaConfigurator.setLastUsedHost(params.datanodes.get(0));
    }

    private static boolean checkImpalaAvailabilityBase() {
        if (!HadoopLoader.hadoopEnabled()) {
            logger.trace((Object)"Impala support is disabled (no hadoop)");
            return false;
        }
        if (!hiveEnabled) {
            logger.trace((Object)"Impala support is disabled (no hive installation)");
            return false;
        }
        try {
            Class.forName("org.apache.hive.jdbc.HiveDriver");
            logger.trace((Object)"Impala JDBC driver loaded");
            return true;
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)"Missing Impala JDBC driver");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean impalaAvailableBase() throws IOException {
        Class<ImpalaConfigurator> clazz = ImpalaConfigurator.class;
        synchronized (ImpalaConfigurator.class) {
            if (impalaAvailabilityBaseCache == null) {
                impalaAvailabilityBaseCache = ImpalaConfigurator.checkImpalaAvailabilityBase();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return impalaAvailabilityBaseCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean impalaAvailable(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        Class<ImpalaConfigurator> clazz = ImpalaConfigurator.class;
        synchronized (ImpalaConfigurator.class) {
            if (impalaAvailabilityBaseCache == null) {
                impalaAvailabilityBaseCache = ImpalaConfigurator.checkImpalaAvailabilityBase();
            }
            if (!impalaAvailabilityBaseCache.booleanValue()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ImpalaSettings impalaSettings = new ClusterSelector().selectForProject(authCtx, projectKey).getImpalaSettings();
            if (impalaSettings == null || !impalaSettings.enabled) {
                logger.info((Object)"Impala support is disabled");
                return false;
            }
            return true;
        }
    }

    static {
        logger = Logger.getLogger(ImpalaConfigurator.class);
    }
}

