/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

class ParquetSchemaBuilder {
    private static Logger logger = Logger.getLogger(ParquetSchemaBuilder.class);
    private static boolean hasLoggedReflectionError = false;
    private final boolean lowerCaseIdentifiers;
    private final ParquetFormatConfig.Flavor flavor;
    private static AnnotationPutVersion annotationPutVersion = null;

    public ParquetSchemaBuilder(boolean lowerCaseIdentifiers, ParquetFormatConfig.Flavor flavor) {
        this.lowerCaseIdentifiers = lowerCaseIdentifiers;
        this.flavor = flavor;
    }

    public static String messageTypeNameFromFlavor(ParquetFormatConfig.Flavor flavor) {
        switch (flavor) {
            case HIVE: {
                return "hive_schema";
            }
            case PIG: {
                return "pig_schema";
            }
            case SPARK: {
                return "spark_schema";
            }
        }
        throw new RuntimeException("Flavor " + String.valueOf((Object)flavor) + " isn't supported");
    }

    public MessageType dssSchemaToParquet(Iterable<SchemaColumn> columns) {
        MessageType mt = new MessageType(ParquetSchemaBuilder.messageTypeNameFromFlavor(this.flavor), this.dssTypesToParquet((SchemaColumn[])Iterables.toArray(columns, SchemaColumn.class)));
        return mt;
    }

    private org.apache.parquet.schema.Type[] dssTypesToParquet(SchemaColumn[] dssCol) {
        org.apache.parquet.schema.Type[] types = new org.apache.parquet.schema.Type[dssCol.length];
        for (int i = 0; i < dssCol.length; ++i) {
            types[i] = this.dssTypeToParquet(dssCol[i]);
        }
        return types;
    }

    private org.apache.parquet.schema.Type dssTypeToParquet(SchemaColumn dssCol) {
        return this.dssTypeToParquet(dssCol, Type.Repetition.OPTIONAL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private org.apache.parquet.schema.Type dssTypeToParquet(SchemaColumn dssCol, Type.Repetition repetition) {
        String colName = dssCol.getName();
        if (this.lowerCaseIdentifiers) {
            colName = colName.toLowerCase();
        }
        switch (dssCol.getType()) {
            case TINYINT: {
                return new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.INT32, colName);
            }
            case SMALLINT: {
                return new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.INT32, colName);
            }
            case INT: {
                return new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.INT32, colName);
            }
            case BIGINT: {
                return new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.INT64, colName);
            }
            case FLOAT: {
                return new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.FLOAT, colName);
            }
            case DOUBLE: {
                return new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.DOUBLE, colName);
            }
            case STRING: {
                return new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.BINARY, colName, OriginalType.UTF8);
            }
            case BOOLEAN: {
                return new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.BOOLEAN, colName);
            }
            case DATE: {
                return new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.INT96, colName);
            }
            case DATETIMENOTZ: {
                PrimitiveType base = new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.INT64, colName, OriginalType.TIMESTAMP_MILLIS);
                if (hasLoggedReflectionError) return base;
                try {
                    return ParquetSchemaBuilder.tryGetDatetimeNoTz(repetition, colName);
                }
                catch (Exception e) {
                    if (hasLoggedReflectionError) return base;
                    Logger.getLogger((String)"dip.parquet").info((Object)"Unable to set logicaltype annotation", (Throwable)e);
                    hasLoggedReflectionError = true;
                }
                return base;
            }
            case DATEONLY: {
                return new PrimitiveType(repetition, PrimitiveType.PrimitiveTypeName.INT32, colName, OriginalType.DATE);
            }
            case ARRAY: {
                return this.dssArrayToParquet(dssCol, repetition);
            }
            case MAP: {
                return this.dssMapToParquet(dssCol, repetition);
            }
            case OBJECT: {
                return this.dssObjectToParquet(dssCol, repetition);
            }
        }
        throw new NotImplementedException("DSS type " + dssCol.getType().getName() + " is not supported by Parquet writer");
    }

    private static PrimitiveType tryGetDatetimeNoTz(Type.Repetition repetition, String colName) throws Exception {
        Class<?> timeUnitClass = PrimitiveType.class.getClassLoader().loadClass("org.apache.parquet.schema.LogicalTypeAnnotation$TimeUnit");
        Object timeUnit = null;
        for (Object v : timeUnitClass.getEnumConstants()) {
            if (!"MILLIS".equals(v.toString())) continue;
            timeUnit = v;
            break;
        }
        if (timeUnit == null) {
            throw new Exception("Unable to get MILLIS enum value via reflection");
        }
        Class<?> annotationClass = PrimitiveType.class.getClassLoader().loadClass("org.apache.parquet.schema.LogicalTypeAnnotation");
        Method timestampTypeMethod = annotationClass.getMethod("timestampType", Boolean.TYPE, timeUnit.getClass());
        Object annotation = timestampTypeMethod.invoke(null, false, timeUnit);
        if (annotationPutVersion == null) {
            PrimitiveType annotated = null;
            try {
                annotated = ParquetSchemaBuilder.putAnnotationV1(repetition, colName, annotationClass, annotation);
                annotationPutVersion = AnnotationPutVersion.V1;
            }
            catch (IllegalAccessException exc) {
                logger.warn((Object)("Unable to set annotation on parquet column with old method: " + ExceptionUtils.getMessageWithCauses((Throwable)exc)));
                annotated = ParquetSchemaBuilder.putAnnotationV2(repetition, colName, annotationClass, annotation);
                annotationPutVersion = AnnotationPutVersion.V2;
            }
            return annotated;
        }
        if (annotationPutVersion == AnnotationPutVersion.V1) {
            return ParquetSchemaBuilder.putAnnotationV1(repetition, colName, annotationClass, annotation);
        }
        if (annotationPutVersion == AnnotationPutVersion.V2) {
            return ParquetSchemaBuilder.putAnnotationV2(repetition, colName, annotationClass, annotation);
        }
        throw new NotImplementedException("Unexpected annotation setting method");
    }

    private static PrimitiveType putAnnotationV2(Type.Repetition repetition, String colName, Class<?> annotationClass, Object annotation) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method primitiveBuilder = Types.class.getMethod("primitive", PrimitiveType.PrimitiveTypeName.class, Type.Repetition.class);
        Types.PrimitiveBuilder builder = (Types.PrimitiveBuilder)primitiveBuilder.invoke(null, PrimitiveType.PrimitiveTypeName.INT64, repetition);
        Method build = Types.PrimitiveBuilder.class.getMethod("named", String.class);
        PrimitiveType annotated = (PrimitiveType)build.invoke((Object)builder, colName);
        Method withLogical = PrimitiveType.class.getMethod("withLogicalTypeAnnotation", annotationClass);
        return (PrimitiveType)withLogical.invoke((Object)annotated, annotation);
    }

    private static PrimitiveType putAnnotationV1(Type.Repetition repetition, String colName, Class<?> annotationClass, Object annotation) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor constructor = PrimitiveType.class.getDeclaredConstructor(Type.Repetition.class, PrimitiveType.PrimitiveTypeName.class, String.class, annotationClass);
        return (PrimitiveType)constructor.newInstance(repetition, PrimitiveType.PrimitiveTypeName.INT64, colName, annotation);
    }

    private org.apache.parquet.schema.Type dssObjectToParquet(SchemaColumn dssCol, Type.Repetition repetition) {
        String colName = dssCol.getName();
        if (this.lowerCaseIdentifiers) {
            colName = colName.toLowerCase();
        }
        if (dssCol.objectFields == null) {
            throw new RuntimeException("Invalid schema: object structure type is unspecified: " + JSON.prettyLog((Object)dssCol));
        }
        SchemaColumn[] fields = dssCol.objectFields.toArray(new SchemaColumn[dssCol.objectFields.size()]);
        org.apache.parquet.schema.Type[] parquetTypes = this.dssTypesToParquet(fields);
        HashSet<String> dedupNames = new HashSet<String>();
        for (org.apache.parquet.schema.Type type : parquetTypes) {
            String name = type.getName();
            if (dedupNames.contains(name)) {
                throw new RuntimeException("Duplicate field \"" + name + "\" in object (lowerCaseIdentifiers=" + this.lowerCaseIdentifiers + ")\n" + JSON.prettyLog((Object)dssCol));
            }
            dedupNames.add(name);
        }
        return new GroupType(repetition, colName, parquetTypes);
    }

    private org.apache.parquet.schema.Type dssMapToParquet(SchemaColumn dssCol, Type.Repetition repetition) {
        String colName = dssCol.getName();
        if (this.lowerCaseIdentifiers) {
            colName = colName.toLowerCase();
        }
        if (dssCol.mapKeys == null) {
            throw new RuntimeException("Invalid schema: type of map keys is unspecified: " + JSON.prettyLog((Object)dssCol));
        }
        if (dssCol.mapValues == null) {
            throw new RuntimeException("Invalid schema: type of map values is unspecified: " + JSON.prettyLog((Object)dssCol));
        }
        SchemaColumn dssKeyColType = (SchemaColumn)JSON.deepCopy((Object)dssCol.mapKeys);
        dssKeyColType.setName("key");
        SchemaColumn dssValColType = (SchemaColumn)JSON.deepCopy((Object)dssCol.mapValues);
        dssValColType.setName("value");
        org.apache.parquet.schema.Type keyType = this.dssTypeToParquet(dssKeyColType, Type.Repetition.REQUIRED);
        org.apache.parquet.schema.Type valType = this.dssTypeToParquet(dssValColType);
        return ConversionPatterns.mapType((Type.Repetition)repetition, (String)colName, (org.apache.parquet.schema.Type)keyType, (org.apache.parquet.schema.Type)valType);
    }

    private org.apache.parquet.schema.Type dssArrayToParquet(SchemaColumn dssCol, Type.Repetition repetition) {
        String colName = dssCol.getName();
        if (this.lowerCaseIdentifiers) {
            colName = colName.toLowerCase();
        }
        if (dssCol.arrayContent == null) {
            throw new RuntimeException("Invalid schema: type of array elements is unspecified: " + JSON.prettyLog((Object)dssCol));
        }
        switch (this.flavor) {
            case HIVE: 
            case SPARK: {
                SchemaColumn content = (SchemaColumn)JSON.deepCopy((Object)dssCol.arrayContent);
                content.setName("array_element");
                return ConversionPatterns.listType((Type.Repetition)repetition, (String)colName, (org.apache.parquet.schema.Type)new GroupType(Type.Repetition.REPEATED, "bag", new org.apache.parquet.schema.Type[]{this.dssTypeToParquet(content)}));
            }
            case PIG: {
                SchemaColumn content = (SchemaColumn)JSON.deepCopy((Object)dssCol.arrayContent);
                content.setName("bag");
                if (content.getType() != Type.OBJECT) {
                    throw new RuntimeException("Parquet Pig flavor doesn't support arrays of primitives. Only bag of tuples are supported (which are mapped to array of objects in DSS).");
                }
                org.apache.parquet.schema.Type t = this.dssTypeToParquet(content, Type.Repetition.REPEATED);
                return ConversionPatterns.listType((Type.Repetition)repetition, (String)colName, (org.apache.parquet.schema.Type)t);
            }
        }
        throw new NotImplementedException("Parquet " + String.valueOf((Object)this.flavor) + " flavor isn't implemented");
    }

    private static enum AnnotationPutVersion {
        V1,
        V2;

    }
}

