/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.row;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.input.utils.CountingProcessorOutput;

public interface RowOrientedDatasetHandler
extends DatasetHandler {
    public RowsInputSplit getSingleSplit() throws Exception;

    public RowsInputSplit getSampleSplit() throws Exception;

    public static class Utils {
        public static DatasetReadiness getReadinessNotEmpty(RowsInputSplit split) throws Exception {
            return Utils.getReadinessNotEmpty(split, null);
        }

        public static DatasetReadiness getReadinessNotEmpty(RowsInputSplit split, String hash) throws Exception {
            StreamColumnFactory scf = new StreamColumnFactory();
            StreamRowFactory srf = new StreamRowFactory();
            CountingProcessorOutput cpo = new CountingProcessorOutput();
            ExtractionLimit pl = new ExtractionLimit(2L);
            split.push((ProcessorOutput)cpo, (ColumnFactory)scf, (RowFactory)srf, pl, null, null);
            if (cpo.getCount() > 0L) {
                return DatasetReadiness.ready(hash);
            }
            return DatasetReadiness.notReady((Throwable)new CodedIOException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_PARTITION_EMPTY, "Input partition for split " + split.getDesc() + " is empty"));
        }
    }
}

