/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations.mail;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.ParamsWithEncryptedFields;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.integrations.AttachmentService;
import com.dataiku.dip.integrations.IntegrationParams;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.notifications.emails.TemplatedContent;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;

@UIModel
public abstract class MailIntegrationParams
extends TemplatedContent
implements IntegrationParams {
    public String channelId;
    public String subject;
    public String sender;
    public String recipient;
    @Nullable
    public String ccRecipient;
    @Nullable
    public String bccRecipient;
    public boolean sendAsHTML;
    public List<AttachmentService.MailScenarioAttachment> attachments = Lists.newArrayList();

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        if (this.attachments != null) {
            for (AttachmentService.MailScenarioAttachment attachment : this.attachments) {
                FormatParams fp;
                if (attachment.type != AttachmentService.AttachmentType.DATASET || attachment.params == null) continue;
                AttachmentService.DatasetExportAttachment exportAttachment = (AttachmentService.DatasetExportAttachment)JSON.parse((String)JSON.json((Object)attachment.params), AttachmentService.DatasetExportAttachment.class);
                ExportParams.SerializedFormat format = exportAttachment.exportParams.format;
                if (format == null || format.params == null || format.type == null || !((fp = (FormatParams)JSON.parse((String)format.params.toString(), FormatFactory.getMeta(format.type).paramsClass())) instanceof ParamsWithEncryptedFields)) continue;
                ((ParamsWithEncryptedFields)((Object)fp)).encryptFields(cryptoService);
                format.params = JSON.toJsonObject((Object)fp, (String[])new String[0]);
                attachment.params = JSON.toJsonObject((Object)exportAttachment, (String[])new String[0]);
            }
        }
    }

    public static class FreeFormIntegrationParams
    extends MailIntegrationParams {
    }

    public static class MailScenarioIntegrationParams
    extends MailIntegrationParams {
    }
}

