/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling.region;

import com.dataiku.dip.labeling.Annotation;
import com.dataiku.dip.labeling.BaseLabelingAnswer;
import com.dataiku.dip.labeling.region.LabelingRegion;
import com.dataiku.dip.labeling.region.RegionElement;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class LabelingRegionDispatcher<T extends Annotation> {
    protected abstract List<LabelingRegion<T>> buildRegions(List<? extends BaseLabelingAnswer> var1);

    protected abstract boolean computeConflict(LabelingRegion<T> var1, int var2);

    public List<LabelingRegion<T>> dispatch(List<? extends BaseLabelingAnswer> answers) {
        List<LabelingRegion<T>> regions = this.buildRegions(answers);
        for (LabelingRegion<T> region : regions) {
            region.conflicting = this.computeConflict(region, answers.size());
        }
        return regions;
    }

    public List<RegionElement<T>> regionElementsFromAnswers(BaseLabelingAnswer answer, int answerIdx) {
        return IntStream.range(0, answer.label.annotations.size()).mapToObj(i -> new RegionElement<Annotation>(answer, answerIdx, i, (Annotation)answer.label.annotations.get(i))).collect(Collectors.toList());
    }

    public List<RegionElement<T>> flattenedRegionElementsFromAnswers(List<? extends BaseLabelingAnswer> answers) {
        return IntStream.range(0, answers.size()).mapToObj(i -> this.regionElementsFromAnswers((BaseLabelingAnswer)answers.get(i), i)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

