/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.io;

import com.dataiku.dip.io.JavaBlockLink;
import com.dataiku.dip.llm.io.commands.ProcessSinglePromptCommand;
import com.dataiku.dip.llm.io.commands.StreamResponseChunkOrFooter;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang.mutable.MutableBoolean;

public class PythonRequestUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.io.python");

    public static CompletableFuture<Integer> asyncStreamRequest(JavaBlockLink.AsyncJavaLink link, LLMClient.SingleCompletionQuery query, LLMClient.CompletionSettings settings, LLMClient.StreamedCompletionResponseConsumer consumer) {
        MutableBoolean footerEmitted = new MutableBoolean();
        return link.asyncStreamRequest((Object)new ProcessSinglePromptCommand(query, settings, true), StreamResponseChunkOrFooter.class, consumer::onStreamStarted, chunkOrFooter -> {
            if (chunkOrFooter.chunk != null) {
                consumer.onStreamChunk(chunkOrFooter.chunk);
            } else if (chunkOrFooter.footer != null) {
                logger.info((Object)("Got footer from Python: " + JSON.log((Object)chunkOrFooter)));
                footerEmitted.setValue(true);
                consumer.onStreamComplete(chunkOrFooter.footer);
            } else {
                logger.warn((Object)("Got unknown object from Python part: " + JSON.log((Object)chunkOrFooter)));
            }
        }, () -> {
            if (!footerEmitted.booleanValue()) {
                logger.debug((Object)"Streamed completion completed (footer not emitted by code)");
                consumer.onStreamComplete(new LLMClient.StreamedCompletionResponseFooter());
            } else {
                logger.debug((Object)"Streamed completion completed (footer already emitted by code)");
            }
        });
    }
}

