/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.openai;

import com.dataiku.common.stereotype.RoutinelyUsedInExtensionCode;
import com.dataiku.dip.connections.OpenAIConnection;
import com.dataiku.dip.llm.online.openai.OpenAIImageHandling;
import com.dataiku.dip.llm.utils.ImageGenerationUtils;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

@RoutinelyUsedInExtensionCode
public class OpenAIPricing {
    public static double getOpenAIPromptCostPer1KTokens(String model) {
        if (StringUtils.isBlank((CharSequence)model)) {
            return 0.0;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT52.id)) {
            return 0.00175;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT51.id)) {
            return 0.00125;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT5.id)) {
            return 0.00125;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT5_MINI.id)) {
            return 2.5E-4;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT5_NANO.id)) {
            return 5.0E-5;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT5_CHAT.id)) {
            return 0.00125;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT4.id)) {
            return 0.03;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT4_TURBO.id)) {
            return 0.01;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT4_TURBO_PREVIEW.id)) {
            return 0.01;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT4O.id)) {
            return 0.0025;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT4O_MINI.id)) {
            return 1.5E-4;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT41.id)) {
            return 0.002;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT41_MINI.id)) {
            return 4.0E-4;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT41_NANO.id)) {
            return 1.0E-4;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT4_TURBO_PREVIEW_1106.id)) {
            return 0.01;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT35_TURBO.id)) {
            return 5.0E-4;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT35_TURBO_LARGE_CONTEXT.id)) {
            return 0.003;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT35_TURBO_INSTRUCT.id)) {
            return 0.0015;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT3_BABBAGE.id)) {
            return 4.0E-4;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT3_DAVINCI.id)) {
            return 0.002;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.O1.id)) {
            return 0.015;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.O3_MINI.id)) {
            return 0.0011;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.O3.id)) {
            return 0.002;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.O3_PRO.id)) {
            return 0.02;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.O4_MINI.id)) {
            return 0.0011;
        }
        return 0.0;
    }

    public static double getOpenAICompletionCostPer1KTokens(String model) {
        if (StringUtils.isBlank((CharSequence)model)) {
            return 0.0;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT52.id)) {
            return 0.014;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT51.id)) {
            return 0.01;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT5.id)) {
            return 0.01;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT5_MINI.id)) {
            return 0.002;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT5_NANO.id)) {
            return 4.0E-4;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT5_CHAT.id)) {
            return 0.01;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT4.id)) {
            return 0.06;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT4_TURBO.id)) {
            return 0.03;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT4_TURBO_PREVIEW.id)) {
            return 0.03;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT4O.id)) {
            return 0.01;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT4O_MINI.id)) {
            return 6.0E-4;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT41.id)) {
            return 0.008;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT41_MINI.id)) {
            return 0.0016;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT41_NANO.id)) {
            return 4.0E-4;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT4_TURBO_PREVIEW_1106.id)) {
            return 0.03;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT35_TURBO.id)) {
            return 0.0015;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT35_TURBO_LARGE_CONTEXT.id)) {
            return 0.004;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT35_TURBO_INSTRUCT.id)) {
            return 0.002;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT3_BABBAGE.id)) {
            return 4.0E-4;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT3_DAVINCI.id)) {
            return 0.002;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.O1.id)) {
            return 0.06;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.O3_MINI.id)) {
            return 0.0044;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.O3.id)) {
            return 0.008;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.O3_PRO.id)) {
            return 0.08;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.O4_MINI.id)) {
            return 0.0044;
        }
        return 0.0;
    }

    public static double getOpenAIEmbeddingCostPer1KTokens(String model) {
        if (StringUtils.isBlank((CharSequence)model)) {
            return 0.0;
        }
        if (OpenAIConnection.HardcodedOpenAIModel.EMBEDDING_ADA.id.equals(model)) {
            return 1.0E-4;
        }
        if (OpenAIConnection.HardcodedOpenAIModel.EMBEDDING_3_SMALL.id.equals(model)) {
            return 2.0E-5;
        }
        if (OpenAIConnection.HardcodedOpenAIModel.EMBEDDING_3_LARGE.id.equals(model)) {
            return 1.3E-4;
        }
        return 0.0;
    }

    public static double getAzureOpenAIPromptCostPer1KTokens(String model) {
        if (StringUtils.isBlank((CharSequence)model)) {
            return 0.0;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT4.id)) {
            return 0.03;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT35_TURBO.id)) {
            return 0.0015;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT35_TURBO_LARGE_CONTEXT.id)) {
            return 0.003;
        }
        if (model.equals("text-davinci-003")) {
            return 0.02;
        }
        if (model.equals("text-curie-001")) {
            return 0.002;
        }
        if (model.equals("text-babbage-001")) {
            return 0.002;
        }
        if (model.equals("text-ada-001")) {
            return 0.002;
        }
        return 0.0;
    }

    public static double getAzureOpenAICompletionCostPer1KTokens(String model) {
        if (StringUtils.isBlank((CharSequence)model)) {
            return 0.0;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT4.id)) {
            return 0.06;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT35_TURBO.id)) {
            return 0.002;
        }
        if (model.equals(OpenAIConnection.HardcodedOpenAIModel.GPT35_TURBO_LARGE_CONTEXT.id)) {
            return 0.004;
        }
        if (model.equals("text-davinci-003")) {
            return 0.02;
        }
        if (model.equals("text-curie-001")) {
            return 0.002;
        }
        if (model.equals("text-babbage-001")) {
            return 5.0E-4;
        }
        if (model.equals("text-ada-001")) {
            return 4.0E-4;
        }
        return 0.0;
    }

    public static double getAzureOpenAIEmbeddingCostPer1KTokens(String model) {
        return OpenAIPricing.getOpenAIEmbeddingCostPer1KTokens(model);
    }

    public static double getOpenAIEstimatedImageGenerationCost(@Nullable OpenAIImageHandling imageHandling, Integer nbImagesToGenerate, String size, String quality) {
        double perImageCost = 0.0;
        if (OpenAIImageHandling.DALL_E_3.equals((Object)imageHandling)) {
            perImageCost = "1024x1024".equals(size) ? (ImageGenerationUtils.isHighQualitySynonym(quality) ? 0.08 : 0.04) : (ImageGenerationUtils.isHighQualitySynonym(quality) ? 0.12 : 0.08);
        } else if (OpenAIImageHandling.GPT_IMAGE_1.equals((Object)imageHandling)) {
            perImageCost = "1024x1024".equals(size) ? (ImageGenerationUtils.isHighQualitySynonym(quality) ? 0.167 : (ImageGenerationUtils.isStandardQualitySynonym(quality) ? 0.042 : (ImageGenerationUtils.isLowQualitySynonym(quality) ? 0.011 : 0.042))) : (ImageGenerationUtils.isHighQualitySynonym(quality) ? 0.25 : (ImageGenerationUtils.isStandardQualitySynonym(quality) ? 0.063 : (ImageGenerationUtils.isLowQualitySynonym(quality) ? 0.016 : 0.063)));
        }
        return perImageCost *= (double)(nbImagesToGenerate == null ? 1 : nbImagesToGenerate);
    }
}

