/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.retrieval;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.retrieval.BaseVectorStoreQuerySettings;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2py.annotations.PyModel;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

@PyModel
public class RAGLLMSettings
extends BaseVectorStoreQuerySettings {
    public String kbRef;
    public String llmId;
    public boolean printSources = true;
    public boolean includeContentInSources = true;
    public RAGOutputFormat outputFormat = RAGOutputFormat.SEPARATED;
    public SearchInputStrategySettings searchInputStrategySettings = new SearchInputStrategySettings();
    public RetrievalSource retrievalSource = RetrievalSource.EMBEDDING;
    public GuardrailsSettings ragSpecificGuardrails = new GuardrailsSettings();
    public GuardrailsPipelineSettings guardrailsPipelineSettings = new GuardrailsPipelineSettings();
    public LLMClient.CompletionSettings completionSettings = new LLMClient.CompletionSettings();
    @Nullable
    public Integer minimumRetentionTimeSeconds;
    public static final String DEFAULT_CONTEXT_MESSAGE = "Answer strictly  based on the provided context.\nIf the answer to a factual question is not in the context, say you don't know and briefly state what information is missing.\nDo not use external knowledge, prior trained data, or provide information not explicitly found in the text.";
    public String contextMessage = "Answer strictly  based on the provided context.\nIf the answer to a factual question is not in the context, say you don't know and briefly state what information is missing.\nDo not use external knowledge, prior trained data, or provide information not explicitly found in the text.";

    public RAGLLMSettings() {
    }

    public RAGLLMSettings(RAGLLMSettings other) {
        super(other);
        this.kbRef = other.kbRef;
        this.llmId = other.llmId;
        this.printSources = other.printSources;
        this.includeContentInSources = other.includeContentInSources;
        this.outputFormat = other.outputFormat;
        this.searchInputStrategySettings = new SearchInputStrategySettings(other.searchInputStrategySettings);
        this.retrievalSource = other.retrievalSource;
        this.ragSpecificGuardrails = new GuardrailsSettings(other.ragSpecificGuardrails);
        this.guardrailsPipelineSettings = new GuardrailsPipelineSettings(other.guardrailsPipelineSettings);
        this.completionSettings = (LLMClient.CompletionSettings)JSON.deepCopy((Object)other.completionSettings);
        this.contextMessage = other.contextMessage;
    }

    public boolean hasFaithfulnessGuardrailsEnabled() {
        return this.ragSpecificGuardrails != null && (this.ragSpecificGuardrails.faithfulnessSettings != null && this.ragSpecificGuardrails.faithfulnessSettings.enabled || this.ragSpecificGuardrails.multimodalFaithfulnessSettings != null && this.ragSpecificGuardrails.multimodalFaithfulnessSettings.enabled);
    }

    public boolean hasRelevancyGuardrailsEnabled() {
        return this.ragSpecificGuardrails != null && (this.ragSpecificGuardrails.relevancySettings != null && this.ragSpecificGuardrails.relevancySettings.enabled || this.ragSpecificGuardrails.multimodalRelevancySettings != null && this.ragSpecificGuardrails.multimodalRelevancySettings.enabled);
    }

    public boolean hasGuardrailsEnabled() {
        return this.hasFaithfulnessGuardrailsEnabled() || this.hasRelevancyGuardrailsEnabled();
    }

    public void disableGuardrails() {
        this.disableTextGuardrails();
        this.disableMultimodalGuardrails();
    }

    public void disableTextGuardrails() {
        if (this.ragSpecificGuardrails != null) {
            if (this.ragSpecificGuardrails.faithfulnessSettings != null) {
                this.ragSpecificGuardrails.faithfulnessSettings.enabled = false;
            }
            if (this.ragSpecificGuardrails.relevancySettings != null) {
                this.ragSpecificGuardrails.relevancySettings.enabled = false;
            }
        }
    }

    public void disableMultimodalGuardrails() {
        if (this.ragSpecificGuardrails != null) {
            if (this.ragSpecificGuardrails.multimodalFaithfulnessSettings != null) {
                this.ragSpecificGuardrails.multimodalFaithfulnessSettings.enabled = false;
            }
            if (this.ragSpecificGuardrails.multimodalRelevancySettings != null) {
                this.ragSpecificGuardrails.multimodalRelevancySettings.enabled = false;
            }
        }
    }

    private static String setDefaultPromptIfBlank(@Nullable String currentPrompt, String defaultPrompt) {
        return StringUtils.isBlank((String)currentPrompt) ? defaultPrompt : currentPrompt;
    }

    public RAGLLMSettings withDefaultPrompts() {
        RAGLLMSettings settingsWithDefaults = (RAGLLMSettings)JSON.deepCopy((Object)this);
        settingsWithDefaults.contextMessage = RAGLLMSettings.setDefaultPromptIfBlank(settingsWithDefaults.contextMessage, DEFAULT_CONTEXT_MESSAGE);
        settingsWithDefaults.searchInputStrategySettings = settingsWithDefaults.searchInputStrategySettings.withDefaultPrompts();
        return settingsWithDefaults;
    }

    @PyModel
    public static enum RAGOutputFormat {
        TEXT,
        JSON,
        SEPARATED;

    }

    @PyModel
    public static class SearchInputStrategySettings {
        private static final String DEFAULT_REWRITE_PROMPT = "When a message requires document retrieval, rewrite it to optimize retrieval from the vector store.\nFocus on clarity, disambiguation, and extracting the core intent.\nOutput only the rewritten query. Do not include comments or tips.";
        public SearchInputStrategy strategy = SearchInputStrategy.RAW_QUERY;
        @Nullable
        public String conditionalRetrievalPrompt;
        public String rewritePrompt = "When a message requires document retrieval, rewrite it to optimize retrieval from the vector store.\nFocus on clarity, disambiguation, and extracting the core intent.\nOutput only the rewritten query. Do not include comments or tips.";

        public SearchInputStrategySettings() {
        }

        public SearchInputStrategySettings(SearchInputStrategySettings other) {
            this.strategy = other.strategy;
            this.conditionalRetrievalPrompt = other.conditionalRetrievalPrompt;
            this.rewritePrompt = other.rewritePrompt;
        }

        public static String getNoRetrievalKey() {
            return DKUApp.getParams().getParam("dku.rag.settings.noRetrievalKey", "NORETRIEVAL");
        }

        private static String getDefaultConditionalRetrievalPrompt() {
            String conditionalRetrievalPrompt = DKUApp.getParams().getParam("dku.rag.settings.defaultConditionalRetrievalPrompt", "You are responsible for determining whether the user's last message requires document retrieval.\nAssume all knowledge is stored in the vector store. Do not use your internal knowledge to answer any knowledge-seeking queries.\nIf the message requests knowledge, facts, or clarification, proceed to rewrite it for retrieval.\nIf the message does not request any new information (e.g., it's chitchat, thanks, or commentary), output only: %s.");
            return conditionalRetrievalPrompt.formatted(SearchInputStrategySettings.getNoRetrievalKey());
        }

        public SearchInputStrategySettings withDefaultPrompts() {
            SearchInputStrategySettings sissWithDefaults = (SearchInputStrategySettings)JSON.deepCopy((Object)this);
            sissWithDefaults.conditionalRetrievalPrompt = RAGLLMSettings.setDefaultPromptIfBlank(this.conditionalRetrievalPrompt, SearchInputStrategySettings.getDefaultConditionalRetrievalPrompt());
            sissWithDefaults.rewritePrompt = RAGLLMSettings.setDefaultPromptIfBlank(this.rewritePrompt, DEFAULT_REWRITE_PROMPT);
            return sissWithDefaults;
        }
    }

    @PyModel
    public static enum RetrievalSource {
        EMBEDDING,
        MULTIMODAL;

    }

    @PyModel
    public static class GuardrailsSettings {
        @Nullable
        public String llmId;
        @Nullable
        public String embeddingModelId;
        public FaithfulnessSettings faithfulnessSettings = new FaithfulnessSettings();
        public RelevancySettings relevancySettings = new RelevancySettings();
        public FaithfulnessSettings multimodalFaithfulnessSettings = new FaithfulnessSettings();
        public RelevancySettings multimodalRelevancySettings = new RelevancySettings();

        public GuardrailsSettings() {
        }

        public GuardrailsSettings(GuardrailsSettings other) {
            this.llmId = other.llmId;
            this.embeddingModelId = other.embeddingModelId;
            this.faithfulnessSettings = new FaithfulnessSettings(other.faithfulnessSettings);
            this.relevancySettings = new RelevancySettings(other.relevancySettings);
            this.multimodalFaithfulnessSettings = new FaithfulnessSettings(other.multimodalFaithfulnessSettings);
            this.multimodalRelevancySettings = new RelevancySettings(other.multimodalRelevancySettings);
        }
    }

    @PyModel
    public static class FaithfulnessSettings
    extends GuardrailSettings {
        public String answerOverwrite = "Could not come up with a factual enough answer.";

        public FaithfulnessSettings() {
        }

        public FaithfulnessSettings(FaithfulnessSettings other) {
            super(other);
            this.answerOverwrite = other.answerOverwrite;
        }
    }

    @PyModel
    public static class RelevancySettings
    extends GuardrailSettings {
        public String answerOverwrite = "Could not come up with a relevant enough answer.";

        public RelevancySettings() {
        }

        public RelevancySettings(RelevancySettings other) {
            super(other);
            this.answerOverwrite = other.answerOverwrite;
        }
    }

    @PyModel
    public static enum BelowThresholdHandling {
        FAIL,
        OVERWRITE_ANSWER;

    }

    @PyModel
    private static abstract class GuardrailSettings {
        public boolean enabled = false;
        public double threshold = 0.8;
        public BelowThresholdHandling handling = BelowThresholdHandling.FAIL;

        public GuardrailSettings() {
        }

        public GuardrailSettings(GuardrailSettings other) {
            this.enabled = other.enabled;
            this.threshold = other.threshold;
            this.handling = other.handling;
        }
    }

    @PyModel
    public static enum SearchInputStrategy {
        RAW_QUERY,
        REWRITE_QUERY;

    }
}

