/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.StorageTypeVerifier;
import com.dataiku.dip.datasets.fs.LocalFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.CSVFormatExtractor;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.mec.MECPaths;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.OutputStreamOutputWriter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.ShakerStreamService;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EvaluationSamplingService {
    @Autowired
    private ShakerStreamService shakerStreamService;
    private DKULogger logger = DKULogger.getLogger((String)"dku.services.evaluationsampling");

    public void streamSample(AuthCtx authCtx, String projectKey, DatasetLocUtils.DatasetLoc loc, String evaluationId, String script, String requestedOutputSchema, String contextProjectKey, HttpServletResponse resp) throws Exception {
        File mesFolder = MECPaths.modelEvaluationStoreBaseFolder(loc.getProjectKey(), loc.getId());
        File runFolder = DKUFileUtils.getWithin((File)mesFolder, (String[])new String[]{evaluationId});
        if (!runFolder.exists()) {
            throw new IllegalArgumentException("EvaluationId " + evaluationId + " doesn't exist");
        }
        final File sampleFile = new File(runFolder, "sample.csv.gz");
        File sampleSchemaFile = new File(runFolder, "sample_schema.json");
        if (!sampleFile.exists() || !sampleSchemaFile.exists()) {
            throw new IllegalArgumentException("Missing sample in evaluationId " + evaluationId);
        }
        Schema sampleSchema = (Schema)JSON.parseFile((File)sampleSchemaFile, Schema.class);
        CSVFormatConfig oFP = CSVFormatConfig.getStandardTabExcelFormat();
        oFP.writeDataTypeMismatchBehavior = StorageTypeVerifier.DataTypeMismatchBehavior.IGNORE_SILENT;
        OutputFormatter of = FormatFactory.buildFormatter(authCtx, projectKey, "csv", oFP);
        of.setOutputSchema((Schema)JSON.parse((String)requestedOutputSchema, Schema.class));
        StreamColumnFactory scf = new StreamColumnFactory();
        StreamRowFactory srf = new StreamRowFactory();
        OutputStreamOutputWriter owr = new OutputStreamOutputWriter((OutputStream)resp.getOutputStream(), of);
        owr.init((ColumnFactory)scf);
        SerializedShakerScript scriptObj = script != null ? (SerializedShakerScript)JSON.parse((String)script, SerializedShakerScript.class) : null;
        if (StringUtils.isNotBlank((String)contextProjectKey) && scriptObj != null) {
            scriptObj.contextProjectKey = contextProjectKey;
        }
        this.logger.infoV("Starting to stream model evaluation sample %s # %swith output schema %s", new Object[]{loc.getFullName(), evaluationId, JSON.log((Object)requestedOutputSchema)});
        ProcessorOutputToSIP pipelineOut = this.shakerStreamService.getProcessorOutput(authCtx, projectKey, scriptObj, (ProcessorOutput)owr, (ColumnFactory)scf, (RowFactory)srf);
        CSVFormatConfig iFP = CSVFormatConfig.getStandardTabExcelFormat();
        iFP.parseHeaderRow = true;
        FormatExtractor fmt = FormatFactory.buildExtractor(CSVFormatExtractor.META.getType(), iFP, authCtx, projectKey);
        fmt.setSchema(sampleSchema, false);
        try (final LocalFSProvider provider = LocalFSProvider.makeFSProviderOnRoot(runFolder.getAbsolutePath());){
            StreamsInputSplit split = new StreamsInputSplit(){
                boolean done = false;

                public String getDesc() {
                    return "";
                }

                public void reset() {
                }

                public EnrichedInputStream nextStream() throws IOException, InterruptedException, DKUSecurityException, CodedException {
                    if (!this.done) {
                        this.done = true;
                        return provider.read(sampleFile.getName());
                    }
                    return null;
                }
            };
            fmt.run(split, (ProcessorOutput)pipelineOut, (ColumnFactory)scf, (RowFactory)srf);
        }
        pipelineOut.lastRowEmitted();
    }

    public Schema getSampleSchema(ModelEvaluationStore mes, String evaluationId) throws IOException {
        File runFolder = MECPaths.modelEvaluationBaseFolder(mes, evaluationId);
        if (!runFolder.exists()) {
            throw new IllegalArgumentException("EvaluationId " + evaluationId + " doesn't exist");
        }
        File sampleFile = new File(runFolder, "sample.csv.gz");
        File sampleSchemaFile = new File(runFolder, "sample_schema.json");
        if (!sampleFile.exists() || !sampleSchemaFile.exists()) {
            throw new IllegalArgumentException("Missing sample in evaluationId " + evaluationId);
        }
        return (Schema)JSON.parseFile((File)sampleSchemaFile, Schema.class);
    }
}

