/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLDiagnostics;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.ml.shared.ResultsReaderBase;
import com.dataiku.dip.analysis.model.EvaluationMetrics;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.PreprocessingReport;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.analysis.model.prediction.ActualModelParameters;
import com.dataiku.dip.analysis.model.prediction.AgentPerf;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.LLMModelPerf;
import com.dataiku.dip.analysis.model.prediction.MetricParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelPerf;
import com.dataiku.dip.analysis.model.prediction.PredictionModelPerformanceMetrics;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedTimeseriesForecastingCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedTimeseriesForecastingPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.TabularPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelPerf;
import com.dataiku.dip.analysis.model.prediction.assertions.MLAssertionsParams;
import com.dataiku.dip.analysis.model.prediction.overrides.MLOverridesParams;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowImplicitRecipe;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.mec.AbstractModelEvaluation;
import com.dataiku.dip.mec.AgentEvaluationMetrics;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.mec.LLMEvaluationMetrics;
import com.dataiku.dip.mec.MECPaths;
import com.dataiku.dip.mec.ModelEvaluationCodes;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.TabularModelEvaluation;
import com.dataiku.dip.metrics.ChecksSet;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.MesChecksDeletedEvent;
import com.dataiku.dip.server.notifications.backend.MesRenamedEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModelEvaluationStoresCRUDService {
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private TaggableObjectDiffService colaborativeMetadataDiffService;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private DatasetDeletionService datasetDeletionService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private FlowZonesService flowZonesService;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    @Autowired
    protected PermissionsService permissionsService;
    @Autowired
    protected ProjectsService projectsService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    private final DKULogger logger = DKULogger.getLogger((String)"dku.services.modelEvaluationStoresCRUD");

    public ModelEvaluationStore getOrNull(String projectKey, String id) throws IOException {
        return (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNull(projectKey, id);
    }

    public ModelEvaluationStore getOrNullUnsafe(String projectKey, String id) throws IOException {
        return (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNullUnsafe(projectKey, id);
    }

    public ModelEvaluationStore getMandatory(String projectKey, String id) throws IOException {
        return (ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatory(projectKey, id);
    }

    public ModelEvaluationStore getMandatoryUnsafe(String projectKey, String id) throws IOException {
        return (ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatoryUnsafe(projectKey, id);
    }

    public ModelEvaluationStore lookupMandatoryUnsafe(String projectKey, String lookup) throws IOException {
        ModelEvaluationStore ret = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNullUnsafe(projectKey, lookup);
        if (ret != null) {
            return ret;
        }
        for (ModelEvaluationStore mes : this.modelEvaluationStoresDAO.listUnsafe(projectKey)) {
            if (!mes.name.equals(lookup)) continue;
            return mes;
        }
        throw new NotFoundException("Model evaluation store with id/name '" + lookup + "' does not exist in project " + projectKey);
    }

    public ModelEvaluationStore create(String projectKey, String name, ModelEvaluationStoreCreationSettings settings) throws Exception {
        Partitionable copyPartitioningFrom = null;
        if (settings.partitioningOptionId != null && settings.partitioningOptionId.startsWith("copy:dataset:")) {
            loc = DatasetLocUtils.resolveSmart(projectKey, settings.partitioningOptionId.replace("copy:dataset:", ""));
            copyPartitioningFrom = Dataset.fromSerialized((SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(loc));
        } else if (settings.partitioningOptionId != null && settings.partitioningOptionId.startsWith("copy:folder:")) {
            loc = DatasetLocUtils.resolveSmart(projectKey, settings.partitioningOptionId.replace("copy:folder:", ""));
            copyPartitioningFrom = (Partitionable)this.managedFolderDAO.getMandatoryUnsafe(loc);
        } else if (settings.partitioningOptionId != null && settings.partitioningOptionId.startsWith("copy:")) {
            loc = DatasetLocUtils.resolveSmart(projectKey, settings.partitioningOptionId.replace("copy:", ""));
            copyPartitioningFrom = Dataset.fromSerialized((SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(loc));
        }
        ModelEvaluationStore mes = new ModelEvaluationStore(projectKey, settings.mesFlavor);
        mes.name = name;
        this.flowZonesService.attachObjectToZone(settings.zone, projectKey, mes);
        if (copyPartitioningFrom != null && copyPartitioningFrom.getPartitioningSchema() != null) {
            mes.partitioning = ManagedDatasetsHelper.copyToFSLikePartitioning(copyPartitioningFrom.getPartitioningSchema());
        }
        this.save(mes, true, false);
        return mes;
    }

    protected void addDefaultMetricsStuff(ModelEvaluationStore mes) {
        mes.metrics = new ProbesSet();
        mes.metrics.displayedState.partition = "NP";
        mes.metrics.displayedState.metrics.add("reporting:BUILD_DURATION");
        mes.metricsChecks = new ChecksSet();
        mes.metricsChecks.displayedState.partition = "NP";
    }

    public ModelEvaluationStore save(ModelEvaluationStore mes, boolean creation, boolean summaryOnly) throws Exception {
        TaggableObjectChangedEvent.ActionType action;
        Preconditions.checkNotNull((Object)mes.projectKey);
        Preconditions.checkNotNull((Object)mes.id);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        ModelEvaluationStore preExisting = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNullUnsafe(mes.projectKey, mes.id);
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(mes, preExisting);
        TaggableObjectDiffService.TaggableObjectsDiff diff = new TaggableObjectDiffService.TaggableObjectsDiff();
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", mes.name);
        details.addProperty("mesFlavor", mes.mesFlavor.toString());
        if (creation) {
            mes.creationTag = new VersionTag(t.getUser().getIdentifier());
            action = TaggableObjectChangedEvent.ActionType.MODEL_EVALUATION_STORE_CREATE;
            this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(mes);
            this.addDefaultMetricsStuff(mes);
        } else if (mes.name != null && preExisting != null && !mes.name.equals(preExisting.name)) {
            action = TaggableObjectChangedEvent.ActionType.MODEL_EVALUATION_STORE_RENAME;
            details.addProperty("newName", mes.name);
            details.addProperty("oldName", preExisting.name);
        } else {
            action = TaggableObjectChangedEvent.ActionType.MODEL_EVALUATION_STORE_EDIT;
            diff = this.colaborativeMetadataDiffService.diff(preExisting, mes, t.getUser().getIdentifier());
        }
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), (TaggableObjectsService.TaggableObject)this.modelEvaluationStoresDAO.getOrNull(mes.projectKey, mes.id), mes);
        this.modelEvaluationStoresDAO.save(mes);
        if (preExisting != null && action == TaggableObjectChangedEvent.ActionType.MODEL_EVALUATION_STORE_EDIT) {
            this.handleCheckDeletionNotification(preExisting, mes);
        }
        if (diff.metadataChanged()) {
            this.colaborativeMetadataDiffService.publishAfterTransaction(diff);
        }
        if (!summaryOnly) {
            this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.MODEL_EVALUATION_STORE, mes.projectKey, mes.id, t.getUser(), action).withDetails(details));
        } else if (TaggableObjectChangedEvent.ActionType.MODEL_EVALUATION_STORE_RENAME.equals((Object)action)) {
            this.pubSub.publishAfterTransaction((DSSEvent)new MesRenamedEvent(mes.id, mes.name));
        }
        this.taggingService.onObjectSaved(mes.projectKey, mes.tags);
        if (action == TaggableObjectChangedEvent.ActionType.MODEL_EVALUATION_STORE_RENAME) {
            this.graphService.invalidateCache();
        }
        return mes;
    }

    public void rename(String projectKey, String modelEvaluationStoreId, String newName) throws Exception {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)newName), (Object)"Model evaluation store name cannot be blank");
        ModelEvaluationStore modelEvaluationStore = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatory(projectKey, modelEvaluationStoreId);
        String newNameTrimmed = newName.trim();
        if (newNameTrimmed.equals(modelEvaluationStore.name)) {
            return;
        }
        ModelEvaluationStore renamedModelEvaluationStore = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatory(projectKey, modelEvaluationStoreId);
        renamedModelEvaluationStore.name = newNameTrimmed;
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdate(renamedModelEvaluationStore, modelEvaluationStore);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), modelEvaluationStore, renamedModelEvaluationStore);
        this.modelEvaluationStoresDAO.save(renamedModelEvaluationStore);
        JsonObject details = new JsonObject();
        details.addProperty("objectDisplayName", renamedModelEvaluationStore.name);
        details.addProperty("oldName", modelEvaluationStore.name);
        details.addProperty("newName", renamedModelEvaluationStore.name);
        details.addProperty("mesFlavor", modelEvaluationStore.mesFlavor.toString());
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.MODEL_EVALUATION_STORE, renamedModelEvaluationStore.projectKey, renamedModelEvaluationStore.id, t.getUser(), TaggableObjectChangedEvent.ActionType.MODEL_EVALUATION_STORE_RENAME).withDetails(details));
        this.graphService.invalidateCache();
    }

    public void deleteEvaluations(ModelEvaluationStore mes, List<String> evaluations) throws IOException {
        File storeFolder = MECPaths.modelEvaluationStoreBaseFolder(mes.projectKey, mes.id);
        for (String evaluationId : evaluations) {
            File runFolder = DKUFileUtils.getWithin((File)storeFolder, (String[])new String[]{evaluationId});
            if (!runFolder.exists()) continue;
            DKUFileUtils.forceDelete((File)runFolder);
        }
    }

    public List<ModelEvaluationStore> list(String projectKey, List<ModelEvaluationStore.ModelEvaluationStoreFlavor> mesFlavors) throws IOException {
        List<ModelEvaluationStore> modelEvaluationStores = this.modelEvaluationStoresDAO.list(projectKey);
        if (CollectionUtils.isEmpty(mesFlavors)) {
            return modelEvaluationStores;
        }
        return modelEvaluationStores.stream().filter(m -> mesFlavors.contains((Object)m.mesFlavor)).collect(Collectors.toList());
    }

    public List<ModelEvaluationStore> listUnsafe(String projectKey, List<ModelEvaluationStore.ModelEvaluationStoreFlavor> mesFlavors) throws IOException {
        List<ModelEvaluationStore> modelEvaluationStores = this.modelEvaluationStoresDAO.listUnsafe(projectKey);
        if (CollectionUtils.isEmpty(mesFlavors)) {
            return modelEvaluationStores;
        }
        return modelEvaluationStores.stream().filter(m -> mesFlavors.contains((Object)m.mesFlavor)).collect(Collectors.toList());
    }

    public List<ModelEvaluationStore> list(String projectKey) throws IOException {
        return this.list(projectKey, null);
    }

    public List<ModelEvaluationStore> listUnsafe(String projectKey) throws IOException {
        return this.listUnsafe(projectKey, null);
    }

    public List<ModelEvaluationStore> listGenAi(String projectKey) throws IOException {
        return this.list(projectKey, List.of(ModelEvaluationStore.ModelEvaluationStoreFlavor.LLM, ModelEvaluationStore.ModelEvaluationStoreFlavor.AGENT));
    }

    public List<ModelEvaluationStore> listTabular(String projectKey) throws IOException {
        return this.list(projectKey, List.of(ModelEvaluationStore.ModelEvaluationStoreFlavor.TABULAR));
    }

    public void performDeletion(AuthCtx authCtx, String projectKey, String id, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws Exception {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        ModelEvaluationStore mes = null;
        try {
            mes = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNull(projectKey, id);
            this.customPolicyHooksRegistry.onPreObjectDelete(authCtx, mes);
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.warn((Object)"Error when getting MES", (Throwable)e);
        }
        TaggableObjectsDeletionService.DeletionImpact di = this.computeDeletionImpact(authCtx, projectKey, id, ignored);
        for (TaggableObjectsDeletionService.ImpactedDataset deletedDataset : di.deletedDatasets) {
            this.datasetSaveService.delete(deletedDataset.projectKey, deletedDataset.name);
        }
        for (TaggableObjectsDeletionService.ImpactedRecipe recipe : di.deletedRecipes) {
            this.recipeSaveService.delete(recipe.projectKey, recipe.name);
        }
        JsonObject details = new JsonObject();
        try {
            if (mes != null) {
                this.flowZonesService.cleanupObjectFromZones(projectKey, mes);
                details.addProperty("objectDisplayName", mes.name);
                details.addProperty("mesFlavor", mes.mesFlavor.toString());
            }
        }
        catch (Exception recipe) {
            // empty catch block
        }
        try {
            this.exposedObjectsService.removeExposedObject(projectKey, ITaggingService.TaggableType.MODEL_EVALUATION_STORE, id);
        }
        catch (Exception e) {
            this.logger.warnV((Throwable)e, "Unable to remove objet sharing for %s(%s) on project %s.", new Object[]{ITaggingService.TaggableType.MODEL_EVALUATION_STORE, id, projectKey});
        }
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.MODEL_EVALUATION_STORE, projectKey, id, t.getUser(), TaggableObjectChangedEvent.ActionType.MODEL_EVALUATION_STORE_DELETE).withDetails(details));
        try {
            this.modelEvaluationStoresDAO.delete(projectKey, id);
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"Model evaluation store was not found during deletion, proceeding");
        }
    }

    public TaggableObjectsDeletionService.DeletionImpact computeDeletionImpact(AuthCtx authCtx, String projectKey, String mesId, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws Exception {
        return this.computeDeletionImpact(authCtx, projectKey, projectKey, mesId, ignored);
    }

    public TaggableObjectsDeletionService.DeletionImpact computeDeletionImpact(AuthCtx authCtx, @Nonnull String contextProjectKey, String projectKey, String mesId, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws Exception {
        ProjectFlowGraph graphUnsafe;
        FlowComputable fdsUnsafe;
        TaggableObjectsDeletionService.DeletionImpact di = new TaggableObjectsDeletionService.DeletionImpact();
        AnyLoc mesLoc = new AnyLoc(projectKey, mesId);
        List<SerializedRecipe> connectedRecipes = this.graphService.getSuccessorAndPredecessorRecipesAcrossProjectsUnsafe(mesLoc);
        for (SerializedRecipe sr : connectedRecipes) {
            this.addRecipeToDeletionImpact(authCtx, sr, di, contextProjectKey, ignored);
        }
        if (!contextProjectKey.equals(projectKey)) {
            for (SerializedRecipe sr : this.recipesDAO.listUnsafe(contextProjectKey)) {
                if (!sr.getFlatInputs().stream().map(input -> input.getLoc(contextProjectKey)).anyMatch(loc -> loc.equals(mesLoc)) && !sr.getFlatOutputs().stream().map(output -> output.getLoc(contextProjectKey)).anyMatch(loc -> loc.equals(mesLoc))) continue;
                this.addRecipeToDeletionImpact(authCtx, sr, di, contextProjectKey, ignored);
            }
        }
        if ((fdsUnsafe = (graphUnsafe = this.graphService.getProjectGraphUnsafe(projectKey)).getComputable(projectKey + "." + mesId)) != null) {
            this.addImplicitRecipesToDeletionImpact(authCtx, fdsUnsafe.getSuccessors(), di, ignored);
        }
        Set<String> smExpositionTargetProjects = this.projectsService.getObjectExpositionTargetProjects(mesLoc.getProjectKey(), mesLoc.getId());
        for (String targetProject : smExpositionTargetProjects) {
            ProjectFlowGraph foreignGraphUnsafe;
            FlowComputable foreignFcUnsafe;
            if (!this.permissionsService.hasProjectPrivilege(authCtx, targetProject, Privileges.ProjectLevelPrivilegeType.READ_CONF) || (foreignFcUnsafe = (foreignGraphUnsafe = this.graphService.getProjectGraphUnsafe(targetProject)).getComputable(projectKey + "." + mesId)) == null) continue;
            this.addForeignImplicitRecipesToDeletionImpact(foreignFcUnsafe.getSuccessors(), di, ignored);
        }
        return di;
    }

    private void addRecipeToDeletionImpact(AuthCtx authCtx, SerializedRecipe sr, TaggableObjectsDeletionService.DeletionImpact di, @Nonnull String contextProjectKey, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws DKUSecurityException {
        String recipeProjectKey = sr.getProjectKey();
        if (ignored == null || !ignored.contains(new TaggableObjectsService.TaggableObjectRef(sr.getProjectKey(), ITaggingService.TaggableType.RECIPE, sr.name))) {
            TaggableObjectsDeletionService.ImpactedRecipe impactedRecipe = new TaggableObjectsDeletionService.ImpactedRecipe(recipeProjectKey, sr.name, sr.type);
            if (contextProjectKey.equals(recipeProjectKey)) {
                di.deletedRecipes.add(impactedRecipe);
            } else if (this.permissionsService.hasProjectPrivilege(authCtx, recipeProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
                di.foreignReadableRecipes.add(impactedRecipe);
            }
        }
    }

    private void addImplicitRecipesToDeletionImpact(AuthCtx authCtx, List<? extends GraphNode> nodes, TaggableObjectsDeletionService.DeletionImpact di, Set<TaggableObjectsService.TaggableObjectRef> ignored) {
        for (GraphNode graphNode : nodes) {
            try {
                if (!(graphNode instanceof FlowImplicitRecipe)) continue;
                for (GraphNode graphNode2 : graphNode.getSuccessors()) {
                    if (!(graphNode2 instanceof FlowDataset)) continue;
                    FlowDataset fd = (FlowDataset)graphNode2;
                    SerializedDataset sds = fd.getSerializedMandatoryUnsafe(this.datasetsDAO);
                    di.deletedDatasets.add(new TaggableObjectsDeletionService.ImpactedDataset(sds.projectKey, sds.name, sds.type));
                    di.merge(this.datasetDeletionService.computeDeletionImpact(authCtx, Dataset.fromSerialized(sds), ignored, false));
                }
            }
            catch (Exception e) {
                this.logger.info((Object)"Failed to get MES info: ", (Throwable)e);
            }
        }
    }

    private void addForeignImplicitRecipesToDeletionImpact(List<? extends GraphNode> nodes, TaggableObjectsDeletionService.DeletionImpact di, Set<TaggableObjectsService.TaggableObjectRef> ignored) {
        for (GraphNode graphNode : nodes) {
            try {
                if (!(graphNode instanceof FlowImplicitRecipe)) continue;
                for (GraphNode graphNode2 : graphNode.getSuccessors()) {
                    if (!(graphNode2 instanceof FlowDataset)) continue;
                    FlowDataset fd = (FlowDataset)graphNode2;
                    SerializedDataset sds = fd.getSerializedMandatoryUnsafe(this.datasetsDAO);
                    di.foreignReadableDatasets.add(new TaggableObjectsDeletionService.ImpactedDataset(sds.projectKey, sds.name, sds.type));
                }
            }
            catch (Exception e) {
                this.logger.info((Object)"Failed to get MES info: ", (Throwable)e);
            }
        }
    }

    private void fillEvaluationInfo(ModelEvaluationHeader evaluationHeader, File runFolder, ModelEvaluationStore mes) throws IOException {
        AbstractModelEvaluation evaluation = (AbstractModelEvaluation)JSON.parseFile((File)new File(runFolder, "evaluation.json"), AbstractModelEvaluation.class);
        if (evaluation.isTabular()) {
            this.fillTabularEvaluationInfo(evaluationHeader, runFolder, mes);
        } else if (evaluation.isLLM()) {
            this.fillLLMEvaluationInfo(evaluationHeader, runFolder, mes);
        } else if (evaluation.isAgent()) {
            this.fillAgentEvaluationInfo(evaluationHeader, runFolder, mes);
        } else {
            throw new IllegalArgumentException("Illegal evaluation type");
        }
    }

    private void fillTabularEvaluationInfo(ModelEvaluationHeader evaluation, File runFolder, ModelEvaluationStore mes) throws IOException {
        evaluation.evaluation = (AbstractModelEvaluation)JSON.parseFile((File)new File(runFolder, "evaluation.json"), TabularModelEvaluation.class);
        evaluation.evaluation.setTransientReference(new FullModelEvaluationId(mes.projectKey, mes.id, runFolder.getName()));
        PredictionModelPerformanceMetrics metrics = new PredictionModelPerformanceMetrics();
        if (evaluation.evaluation.ref.getPredictionType() == PredictionMLTask.PredictionType.TIMESERIES_FORECAST) {
            TimeseriesForecastingModelPerf perf = evaluation.evaluation.ref.getTimeseriesForecastingPerf(false);
            PredictionResultsReader.fillTimeseriesPerformanceMetrics(metrics, perf);
        } else if (evaluation.evaluation.ref.hasTabularPerformance()) {
            TabularModelEvaluation tabularMe = (TabularModelEvaluation)evaluation.evaluation;
            PredictionModelPerf perf = evaluation.evaluation.ref.getTabularPerformance();
            PredictionResultsReader.fillClassicalPerformanceMetrics(metrics, tabularMe.predictionType, tabularMe.metricParams.costMatrixWeights, perf, tabularMe.metricParams, tabularMe.activeClassifierThreshold, tabularMe.weightsVariable);
        }
        PredictionResultsReader.fillDriftMetrics(evaluation.evaluation.ref.getDataEvaluationMetrics(), metrics);
        evaluation.metrics = metrics;
        evaluation.mlDiagnostics = evaluation.evaluation.ref.getMLDiagnostics();
    }

    private void fillLLMEvaluationInfo(ModelEvaluationHeader evaluation, File runFolder, ModelEvaluationStore mes) throws IOException {
        evaluation.evaluation = (AbstractModelEvaluation)JSON.parseFile((File)new File(runFolder, "evaluation.json"), AbstractModelEvaluation.class);
        evaluation.evaluation.setTransientReference(new FullModelEvaluationId(mes.projectKey, mes.id, runFolder.getName()));
        LLMEvaluationMetrics metrics = new LLMEvaluationMetrics();
        if (evaluation.evaluation.ref.hasLLMPerformance()) {
            LLMModelPerf perf = evaluation.evaluation.ref.getLLMPerformance();
            metrics.faithfulness = perf.metrics.faithfulness;
            metrics.multimodalFaithfulness = perf.metrics.multimodalFaithfulness;
            metrics.answerRelevancy = perf.metrics.answerRelevancy;
            metrics.multimodalRelevancy = perf.metrics.multimodalRelevancy;
            metrics.answerCorrectness = perf.metrics.answerCorrectness;
            metrics.answerSimilarity = perf.metrics.answerSimilarity;
            metrics.contextPrecision = perf.metrics.contextPrecision;
            metrics.contextRecall = perf.metrics.contextRecall;
            metrics.bertScorePrecision = perf.metrics.bertScorePrecision;
            metrics.bertScoreRecall = perf.metrics.bertScoreRecall;
            metrics.bertScoreF1 = perf.metrics.bertScoreF1;
            metrics.bleu = perf.metrics.bleu;
            metrics.rouge1Precision = perf.metrics.rouge1Precision;
            metrics.rouge1Recall = perf.metrics.rouge1Recall;
            metrics.rouge1F1 = perf.metrics.rouge1F1;
            metrics.rouge2Precision = perf.metrics.rouge2Precision;
            metrics.rouge2Recall = perf.metrics.rouge2Recall;
            metrics.rouge2F1 = perf.metrics.rouge2F1;
            metrics.rougeLPrecision = perf.metrics.rougeLPrecision;
            metrics.rougeLRecall = perf.metrics.rougeLRecall;
            metrics.rougeLF1 = perf.metrics.rougeLF1;
            metrics.inputTokensPerRow = perf.metrics.inputTokensPerRow;
            metrics.outputTokensPerRow = perf.metrics.outputTokensPerRow;
            metrics.customMetricsResults = perf.metrics.customMetricsResults;
            metrics.sampleRowCount = perf.metrics.sampleRowCount;
        }
        evaluation.metrics = metrics;
        evaluation.mlDiagnostics = evaluation.evaluation.ref.getMLDiagnostics();
    }

    private void fillAgentEvaluationInfo(ModelEvaluationHeader evaluation, File runFolder, ModelEvaluationStore mes) throws IOException {
        evaluation.evaluation = (AbstractModelEvaluation)JSON.parseFile((File)new File(runFolder, "evaluation.json"), AbstractModelEvaluation.class);
        evaluation.evaluation.setTransientReference(new FullModelEvaluationId(mes.projectKey, mes.id, runFolder.getName()));
        AgentEvaluationMetrics metrics = new AgentEvaluationMetrics();
        if (evaluation.evaluation.ref.hasAgentPerformance()) {
            AgentPerf perf = evaluation.evaluation.ref.getAgentPerformance();
            metrics.averageToolExecutionTimeSecondsPerRow = perf.metrics.averageToolExecutionTimeSecondsPerRow;
            metrics.averageToolExecutionsPerRow = perf.metrics.averageToolExecutionsPerRow;
            metrics.averageFailedToolExecutionsPerRow = perf.metrics.averageFailedToolExecutionsPerRow;
            metrics.p95TotalAgentCallExecutionTimeSecondsPerRow = perf.metrics.p95TotalAgentCallExecutionTimeSecondsPerRow;
            metrics.sampleRowCount = perf.metrics.sampleRowCount;
            metrics.customMetricsResults = perf.metrics.customMetricsResults;
            metrics.toolCallExactMatch = perf.metrics.toolCallExactMatch;
            metrics.toolCallPartialMatch = perf.metrics.toolCallPartialMatch;
            metrics.toolCallPrecision = perf.metrics.toolCallPrecision;
            metrics.toolCallRecall = perf.metrics.toolCallRecall;
            metrics.toolCallF1 = perf.metrics.toolCallF1;
            metrics.agentGoalAccuracyWithReference = perf.metrics.agentGoalAccuracyWithReference;
            metrics.agentGoalAccuracyWithoutReference = perf.metrics.agentGoalAccuracyWithoutReference;
            metrics.answerSimilarity = perf.metrics.answerSimilarity;
            metrics.answerCorrectness = perf.metrics.answerCorrectness;
            metrics.bertScorePrecision = perf.metrics.bertScorePrecision;
            metrics.bertScoreRecall = perf.metrics.bertScoreRecall;
            metrics.bertScoreF1 = perf.metrics.bertScoreF1;
        }
        evaluation.metrics = metrics;
        evaluation.mlDiagnostics = evaluation.evaluation.ref.getMLDiagnostics();
    }

    public List<String> listRunIds(ModelEvaluationStore mes, int maxRuns) throws IOException {
        ArrayList list = Lists.newArrayList();
        File storeFolder = MECPaths.modelEvaluationStoreBaseFolder(mes.projectKey, mes.id);
        if (storeFolder != null && storeFolder.exists()) {
            int currentRun = 0;
            for (File runFolder : storeFolder.listFiles()) {
                File evaluationFile;
                if (maxRuns > 0 && currentRun >= maxRuns) break;
                if (!runFolder.isDirectory() || !(evaluationFile = new File(runFolder, "evaluation.json")).exists() || !evaluationFile.isFile()) continue;
                ++currentRun;
                list.add(runFolder.getName());
            }
        }
        return list;
    }

    public List<String> listRunIds(ModelEvaluationStore mes) throws IOException {
        return this.listRunIds(mes, 0);
    }

    public List<ModelEvaluationHeader> listEvaluations(ModelEvaluationStore mes, @Nullable InfoMessage.InfoMessages messages, int maxEvaluations) throws IOException {
        ArrayList list = Lists.newArrayList();
        File storeFolder = MECPaths.modelEvaluationStoreBaseFolder(mes.projectKey, mes.id);
        if (storeFolder != null && storeFolder.exists()) {
            List<String> runIds = this.listRunIds(mes);
            if (maxEvaluations > 0 && runIds.size() > maxEvaluations) {
                if (null != messages) {
                    messages.withWarningV((InfoMessage.MessageCode)ModelEvaluationCodes.WARN_TRUNCATED_MODEL_EVALUATION_LIST, "Too many Model Evaluations (%d) found. Truncating list to %d elements.", new Object[]{runIds.size(), maxEvaluations});
                }
                runIds = runIds.subList(runIds.size() - maxEvaluations, runIds.size());
            }
            for (String evaluationId : runIds) {
                File runFolder = DKUFileUtils.getWithin((File)storeFolder, (String[])new String[]{evaluationId});
                try {
                    ModelEvaluationHeader info = new ModelEvaluationHeader();
                    this.fillEvaluationInfo(info, runFolder, mes);
                    list.add(info);
                }
                catch (Exception e) {
                    this.logger.warn((Object)"Unable to read evaluation, skipping", (Throwable)e);
                    if (null == messages) continue;
                    messages.withWarning((InfoMessage.MessageCode)ModelEvaluationCodes.WARN_COULD_NOT_LOAD_MODEL_EVALUATION, "Could not read model evaluation with id: " + evaluationId);
                }
            }
        }
        if (null != messages) {
            messages.summarize();
        }
        return list;
    }

    public AbstractModelEvaluationDetails getEvaluationDetails(ModelEvaluationStore mes, String evaluationId) throws IOException {
        File storeFolder = MECPaths.modelEvaluationStoreBaseFolder(mes.projectKey, mes.id);
        File evaluationFolder = DKUFileUtils.getWithin((File)storeFolder, (String[])new String[]{evaluationId});
        AbstractModelEvaluation me = (AbstractModelEvaluation)JSON.parseFile((File)new File(evaluationFolder, "evaluation.json"), AbstractModelEvaluation.class);
        if (me.isTabular()) {
            return this.getTabularEvaluationDetails(mes, evaluationFolder);
        }
        if (me.isLLM()) {
            return this.getLLMEvaluationDetails(mes, evaluationFolder);
        }
        if (me.isAgent()) {
            return this.getAgentEvaluationDetails(mes, evaluationFolder);
        }
        throw new IllegalArgumentException("Unrecognized me type");
    }

    public TabularModelEvaluationDetails getTabularEvaluationDetails(ModelEvaluationStore mes, File evaluationFolder) throws IOException {
        TabularModelEvaluationDetails ret = new TabularModelEvaluationDetails();
        this.fillTabularEvaluationInfo(ret, evaluationFolder, mes);
        TabularModelEvaluation evaluation = ret.getModelEvaluation();
        FullModelEvaluationId fme = evaluation.ref;
        if (evaluation.predictionType == PredictionMLTask.PredictionType.TIMESERIES_FORECAST) {
            ResolvedTimeseriesForecastingCoreParams fcp;
            TabularModelEvaluation.EvaluatedDSSModel modelParams = evaluation.getModelParamsAs(TabularModelEvaluation.EvaluatedDSSModel.class);
            SavedModel sm = (SavedModel)this.savedModelsDAO.getOrNullUnsafe(DatasetLocUtils.DatasetLoc.resolveSmart(mes.projectKey, modelParams.ref));
            FullModelId fmi = null;
            TimeseriesForecastingModelDetails details = new TimeseriesForecastingModelDetails();
            if (sm == null) {
                ret.backingModelDeleted = true;
                ret.backingModelVersionDeleted = true;
                details.trainInfo = new ModelTrainInfo();
            } else {
                fmi = new FullModelId(sm.projectKey, sm.id, modelParams.versionId);
                if (!fmi.exists()) {
                    fmi = null;
                    ret.backingModelVersionDeleted = true;
                    details.trainInfo = new ModelTrainInfo();
                }
            }
            details.fullModelId = evaluation.modelRef.toString();
            if (null != fmi) {
                if (StringUtils.isNotBlank((String)modelParams.partitionName)) {
                    fmi = fmi.getModelPartition(modelParams.partitionName);
                }
                this.logger.info((Object)("Get details for " + String.valueOf(fmi)));
                ResultsReaderBase.readTrainInfoUserMetaAndDiagnostics(fmi, details);
            }
            if (evaluation.ref.hasTabularPerformance()) {
                details.perf = FullModelId.getTimeseriesForecastingPerf(evaluationFolder);
            }
            if (evaluation.ref.hasIPerformance()) {
                details.iperf = FullModelId.getTimeseriesForecastingIPerf(evaluationFolder);
            }
            if (fme.getEvaluationFile("mlflow_imported_model.json").exists()) {
                throw new UnsupportedOperationException("MLflow time series forecasting models are not supported yet.");
            }
            details.coreParams = fcp = (ResolvedTimeseriesForecastingCoreParams)fme.getResolvedCoreParams();
            details.preprocessing = fme.parseEvaluationFile("rpreprocessing_params.json", ResolvedTimeseriesForecastingPreprocessingParams.class);
            details.modeling = fme.parseEvaluationFile("rmodeling_params.json", PreTrainPredictionModelingParams.class);
            details.backendType = details.modeling.algorithm.backendType;
            details.trainInfo = fme.parseEvaluationFile("train_info.json", ModelTrainInfo.class);
            details.mlDiagnostics = fme.getEvaluationFile("train_diagnostics.json").exists() ? fme.parseEvaluationFile("train_diagnostics.json", MLDiagnostics.class) : null;
            if (null != fmi && fmi.hasReadableModelFile("rmodeling_params.json")) {
                if (!fcp.partitionedModel.isEnabled() || fmi.isModelPartition()) {
                    details.actualParams = fmi.parseModelFile("actual_params.json", ActualModelParameters.class);
                    details.preprocessingReport = fmi.parsePreprocessingFile("preprocessing_report.json", PreprocessingReport.class);
                }
                details.trainedWithScript = fmi.parseSessionFile("script.json", SerializedShakerScript.class);
                details.apiNodeScoreCompatibility = details.resolveApiNodeScoreCompatibility();
                ResultsReaderBase.readSplitData(fmi, details);
            }
            details.userMeta = new ModelUserMeta();
            details.userMeta.name = modelParams.name;
            details.userMeta.description = modelParams.description;
            ret.details = details;
        } else {
            ClassicalPredictionModelDetails details;
            switch (evaluation.modelType) {
                case SAVED_MODEL: {
                    TabularModelEvaluation.EvaluatedDSSModel modelParams = evaluation.getModelParamsAs(TabularModelEvaluation.EvaluatedDSSModel.class);
                    SavedModel sm = (SavedModel)this.savedModelsDAO.getOrNullUnsafe(DatasetLocUtils.DatasetLoc.resolveSmart(mes.projectKey, modelParams.ref));
                    FullModelId fmi = null;
                    details = new ClassicalPredictionModelDetails();
                    if (sm == null) {
                        ret.backingModelDeleted = true;
                        ret.backingModelVersionDeleted = true;
                        details.trainInfo = new ModelTrainInfo();
                    } else {
                        fmi = new FullModelId(sm.projectKey, sm.id, modelParams.versionId);
                        if (!fmi.exists()) {
                            fmi = null;
                            ret.backingModelVersionDeleted = true;
                            details.trainInfo = new ModelTrainInfo();
                        }
                    }
                    details.fullModelId = evaluation.modelRef.toString();
                    if (null != fmi) {
                        if (StringUtils.isNotBlank((String)modelParams.partitionName)) {
                            fmi = fmi.getModelPartition(modelParams.partitionName);
                        }
                        this.logger.info((Object)("Get details for " + String.valueOf(fmi)));
                        ResultsReaderBase.readTrainInfoUserMetaAndDiagnostics(fmi, details);
                    }
                    details.globalExplanationsAbsoluteImportance = fme.getGlobalExplanationsAbsoluteImportance().orElse(null);
                    if (fme.hasPredictionStatisticsFile()) {
                        PredictionResultsReader.readClassicalModelPredictions(evaluationFolder, details, evaluation.predictionType);
                    }
                    if (evaluation.ref.hasTabularPerformance()) {
                        PredictionResultsReader.readClassicalModelPerf(evaluationFolder, details, evaluation.predictionType);
                    }
                    if (evaluation.ref.hasIPerformance()) {
                        PredictionResultsReader.readClassicalModelIPerf(evaluationFolder, details, evaluation.predictionType);
                    }
                    if (fme.getEvaluationFile("mlflow_imported_model.json").exists()) {
                        MLFlowModelVersionInfo mmvi = fme.parseEvaluationFile("mlflow_imported_model.json", MLFlowModelVersionInfo.class);
                        details.trainInfo.state = ModelTrainInfo.ModelTrainState.DONE;
                        mmvi.fillMinimalCoreParamsOfPredictionDetails(details);
                        mmvi.fillMinimalPreprocessingParamsOfPredictionDetails(details);
                        mmvi.fillMinimalModelingParamsOfPredictionDetails(details);
                        if (mmvi.isProxyModel()) {
                            details.proxyModelConfiguration = mmvi.proxyModelVersionConfiguration.proxyModelConfiguration;
                        }
                        details.proxyModelEndpointInfo = mmvi.proxyModelEndpointInfo;
                        details.inputFormat = mmvi.inputFormat;
                        details.outputFormat = mmvi.outputFormat;
                        details.importedOn = mmvi.importedOn;
                        details.trainInfo.pythonVersion = mmvi.pythonVersion;
                        if (fme.getEvaluationFile("MLModel").exists()) {
                            details.mlflowMLModelFileContent = DKUFileUtils.readFileToStringUTF8((File)fme.getEvaluationFile("MLModel"));
                        }
                    } else if (null != evaluation.predictionType) {
                        ResolvedClassicalPredictionCoreParams pcp;
                        details.coreParams = pcp = (ResolvedClassicalPredictionCoreParams)fme.getResolvedCoreParams();
                        details.preprocessing = fme.parseEvaluationFile("rpreprocessing_params.json", ResolvedClassicalPredictionPreprocessingParams.class);
                        details.modeling = fme.parseEvaluationFile("rmodeling_params.json", PreTrainPredictionModelingParams.class);
                        details.backendType = details.modeling.algorithm.backendType;
                        details.trainInfo = fme.parseEvaluationFile("train_info.json", ModelTrainInfo.class);
                        details.mlDiagnostics = fme.getEvaluationFile("train_diagnostics.json").exists() ? fme.parseEvaluationFile("train_diagnostics.json", MLDiagnostics.class) : null;
                        if (null != fmi && fmi.hasReadableModelFile("rmodeling_params.json")) {
                            if (!pcp.partitionedModel.isEnabled() || fmi.isModelPartition()) {
                                details.actualParams = fmi.parseModelFile("actual_params.json", ActualModelParameters.class);
                                details.preprocessingReport = fmi.parsePreprocessingFile("preprocessing_report.json", PreprocessingReport.class);
                            }
                            details.trainedWithScript = fmi.parseSessionFile("script.json", SerializedShakerScript.class);
                            if (fmi.getOverridesFile().isFile()) {
                                details.overridesParams = fmi.getOverridesParams();
                            }
                            details.javaScoreCompatibility = details.getJavaScoreCompatibility();
                            details.javaExportCompatibility = details.getJavaExportCompatibility();
                            details.sqlCompatibility = details.getSQLCompatibility();
                            details.pmmlCompatibility = details.getPMMLCompatibility();
                            details.pythonCompatibility = details.getPythonExportCompatibility();
                            details.pythonApiNodeScoreCompatibility = details.getPythonApiNodeScoreCompatibility();
                            details.apiNodeScoreCompatibility = details.resolveApiNodeScoreCompatibility();
                            ResultsReaderBase.readSplitData(fmi, details);
                        }
                    }
                    details.userMeta = new ModelUserMeta();
                    details.userMeta.name = modelParams.name;
                    details.userMeta.description = modelParams.description;
                    break;
                }
                case EXTERNAL: {
                    details = this.buildStandaloneDetails(evaluation);
                    boolean bl = ret.hasReferenceDataset = fme.getDriftReferenceFile().exists() && fme.getDriftReferenceSchemaFile().exists();
                    if (fme.hasPredictionStatisticsFile()) {
                        PredictionResultsReader.readClassicalModelPredictions(evaluationFolder, details, evaluation.predictionType);
                    }
                    if (!fme.hasReferencePredictionStatisticsFile()) break;
                    PredictionResultsReader.readReferenceClassicalModelPredictions(evaluationFolder, details, evaluation.predictionType);
                    break;
                }
                default: {
                    throw new NotImplementedException("Unknown model type in evaluation : " + String.valueOf((Object)evaluation.modelType));
                }
            }
            if (details.headTaskCMW == null) {
                details.headTaskCMW = new MetricParams.CostMatrixWeights();
            }
            if (details.userMeta == null) {
                details.userMeta = new ModelUserMeta();
                details.userMeta.name = "Model evaluation";
            }
            details.headTaskCMW = evaluation.metricParams.costMatrixWeights;
            details.userMeta.activeClassifierThreshold = evaluation.activeClassifierThreshold;
            details.assertionsParams = this.readAssertionsParamsOrNull(evaluationFolder);
            details.overridesParams = this.readOverridesParamsOrNull(evaluationFolder);
            details.dataEvaluationMetrics = evaluation.ref.getDataEvaluationMetrics();
            if (details != null && details.trainInfo != null) {
                details.trainInfo.testRows = evaluation.nbEvaluationRows;
                details.trainInfo.state = ModelTrainInfo.ModelTrainState.DONE;
            }
            switch (evaluation.dataType) {
                case DATASET: {
                    AbstractModelEvaluation.EvaluatedDataset dataParams = evaluation.getDataParamsAs(AbstractModelEvaluation.EvaluatedDataset.class);
                    SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(DatasetLocUtils.DatasetLoc.resolveSmart(mes.projectKey, dataParams.ref));
                    if (sd == null) {
                        ret.evaluatedDatasetDeleted = true;
                        break;
                    }
                    ret.evaluatedDatasetType = sd.type;
                    break;
                }
            }
            ret.details = details;
        }
        return ret;
    }

    public LLMModelEvaluationDetails getLLMEvaluationDetails(ModelEvaluationStore mes, File evaluationFolder) throws IOException {
        LLMModelEvaluationDetails ret = new LLMModelEvaluationDetails();
        this.fillLLMEvaluationInfo(ret, evaluationFolder, mes);
        switch (ret.evaluation.dataType) {
            case DATASET: {
                AbstractModelEvaluation.EvaluatedDataset dataParams = ret.evaluation.getDataParamsAs(AbstractModelEvaluation.EvaluatedDataset.class);
                SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(DatasetLocUtils.DatasetLoc.resolveSmart(mes.projectKey, dataParams.ref));
                if (sd == null) {
                    ret.evaluatedDatasetDeleted = true;
                    break;
                }
                ret.evaluatedDatasetType = sd.type;
                break;
            }
        }
        return ret;
    }

    public AgentEvaluationDetails getAgentEvaluationDetails(ModelEvaluationStore mes, File evaluationFolder) throws IOException {
        AgentEvaluationDetails ret = new AgentEvaluationDetails();
        this.fillAgentEvaluationInfo(ret, evaluationFolder, mes);
        switch (ret.evaluation.dataType) {
            case DATASET: {
                AbstractModelEvaluation.EvaluatedDataset dataParams = ret.evaluation.getDataParamsAs(AbstractModelEvaluation.EvaluatedDataset.class);
                SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(DatasetLocUtils.DatasetLoc.resolveSmart(mes.projectKey, dataParams.ref));
                if (sd == null) {
                    ret.evaluatedDatasetDeleted = true;
                    break;
                }
                ret.evaluatedDatasetType = sd.type;
                break;
            }
        }
        return ret;
    }

    public String getLatestEvaluationId(String projectKey, String mesId) throws IOException {
        String ret = null;
        long retCreation = -1L;
        File storeFolder = MECPaths.modelEvaluationStoreBaseFolder(projectKey, mesId);
        if (storeFolder != null && storeFolder.exists()) {
            for (File evaluationFolder : storeFolder.listFiles()) {
                if (!evaluationFolder.isDirectory()) continue;
                File evaluationFile = new File(evaluationFolder, "evaluation.json");
                if (!evaluationFolder.isDirectory() || !evaluationFile.exists() || !evaluationFile.isFile()) continue;
                AbstractModelEvaluation evaluation = (AbstractModelEvaluation)JSON.parseFile((File)new File(evaluationFolder, "evaluation.json"), AbstractModelEvaluation.class);
                if (retCreation >= evaluation.created) continue;
                retCreation = evaluation.created;
                ret = evaluationFolder.getName();
            }
        }
        return ret;
    }

    public AbstractModelEvaluationDetails getLatestModelEvaluation(String projectKey, ModelEvaluationStore mes) throws IOException {
        String evaluationId = this.getLatestEvaluationId(projectKey, mes.id);
        if (evaluationId == null) {
            return null;
        }
        return this.getEvaluationDetails(mes, evaluationId);
    }

    private ClassicalPredictionModelDetails buildStandaloneDetails(TabularModelEvaluation evaluation) throws IOException {
        FullModelEvaluationId fme = evaluation.ref;
        ClassicalPredictionModelDetails details = new ClassicalPredictionModelDetails();
        if (fme.hasTabularPerformance()) {
            details.perf = fme.getTabularPerformance();
        } else {
            this.logger.warn((Object)("No perf in " + String.valueOf(evaluation.ref.getMainFolder())));
        }
        details.coreParams = new ResolvedClassicalPredictionCoreParams();
        details.modeling = new PreTrainPredictionModelingParams();
        details.modeling.metrics = evaluation.metricParams;
        details.trainInfo = new ModelTrainInfo();
        details.userMeta = new ModelUserMeta();
        details.coreParams.prediction_type = evaluation.predictionType;
        details.preprocessing = new ResolvedClassicalPredictionPreprocessingParams();
        if (fme.getEvaluationFile("rpreprocessing_params.json").exists()) {
            details.preprocessing = fme.parseEvaluationFile("rpreprocessing_params.json", ResolvedClassicalPredictionPreprocessingParams.class);
        }
        if (fme.hasIPerformance()) {
            details.iperf = fme.getIPerformance();
        }
        TabularModelEvaluation.EvaluatedExternalModel modelParams = evaluation.getModelParamsAs(TabularModelEvaluation.EvaluatedExternalModel.class);
        details.userMeta.name = StringUtils.defaultIfBlank((String)modelParams.name, (String)"Model evaluation");
        details.userMeta.description = modelParams.description;
        return details;
    }

    private MLAssertionsParams readAssertionsParamsOrNull(File runFolder) throws IOException {
        File assertionsParamsFile = DKUFileUtils.getWithin((File)runFolder, (String[])new String[]{"rassertions.json"});
        if (assertionsParamsFile.exists()) {
            return (MLAssertionsParams)JSON.parseFile((File)assertionsParamsFile, MLAssertionsParams.class);
        }
        return null;
    }

    private MLOverridesParams readOverridesParamsOrNull(File runFolder) throws IOException {
        File overridesParamsFile = DKUFileUtils.getWithin((File)runFolder, (String[])new String[]{"roverrides.json"});
        if (overridesParamsFile.exists()) {
            return (MLOverridesParams)JSON.parseFile((File)overridesParamsFile, MLOverridesParams.class);
        }
        return null;
    }

    private void handleCheckDeletionNotification(ModelEvaluationStore previousMes, ModelEvaluationStore currentMes) {
        List currentMesChecks = currentMes.metricsChecks.checks.stream().map(check -> check.meta.label).collect(Collectors.toList());
        List<String> deletedMesChecks = previousMes.metricsChecks.checks.stream().filter(check -> check.meta.label != null).map(check -> check.meta.label).filter(check -> !currentMesChecks.contains(check)).collect(Collectors.toList());
        if (!deletedMesChecks.isEmpty()) {
            MesChecksDeletedEvent mesChecksDeletedEvent = new MesChecksDeletedEvent(currentMes.projectKey, currentMes.id, deletedMesChecks);
            this.pubSub.publish((DSSEvent)mesChecksDeletedEvent);
        }
    }

    public String transmogrifyName(String projectKey, @Nonnull String name) throws IOException {
        StringTransmogrifier st2 = new StringTransmogrifier();
        for (ModelEvaluationStore mes : this.modelEvaluationStoresDAO.listUnsafe(projectKey)) {
            try {
                st2.addAlreadyTransmogrified(mes.name);
            }
            catch (Exception exception) {}
        }
        return st2.transmogrify(name);
    }

    public static class ModelEvaluationStoreCreationSettings {
        public String partitioningOptionId = "NP";
        public String zone = "default";
        @Nonnull
        public ModelEvaluationStore.ModelEvaluationStoreFlavor mesFlavor = ModelEvaluationStore.ModelEvaluationStoreFlavor.TABULAR;
    }

    public static class ModelEvaluationHeader {
        public AbstractModelEvaluation evaluation;
        public EvaluationMetrics metrics;
        public MLDiagnostics mlDiagnostics;

        public boolean isTabular() {
            return this.evaluation != null && this.evaluation.isTabular();
        }

        public boolean isTimeseries() {
            if (!this.isTabular()) {
                return false;
            }
            TabularModelEvaluation tabularModelEvaluation = (TabularModelEvaluation)this.evaluation;
            return PredictionMLTask.PredictionType.TIMESERIES_FORECAST.equals((Object)tabularModelEvaluation.predictionType);
        }

        public boolean isLLM() {
            return this.evaluation != null && this.evaluation.isLLM();
        }

        public boolean isAgent() {
            return this.evaluation != null && this.evaluation.isAgent();
        }
    }

    public static class TabularModelEvaluationDetails
    extends AbstractModelEvaluationDetails {
        public TabularPredictionModelDetails details;
        public boolean backingModelDeleted;
        public boolean hasReferenceDataset;
        public boolean backingModelVersionDeleted;

        public TabularModelEvaluation getModelEvaluation() {
            return (TabularModelEvaluation)this.evaluation;
        }
    }

    public static class LLMModelEvaluationDetails
    extends AbstractModelEvaluationDetails {
        public LLMModelPerf perf;
    }

    public static class AgentEvaluationDetails
    extends AbstractModelEvaluationDetails {
        public AgentPerf perf;
    }

    public static class AbstractModelEvaluationDetails
    extends ModelEvaluationHeader {
        public boolean evaluatedDatasetDeleted;
        public String evaluatedDatasetType;
    }
}

