/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.connections.JdbcConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.engines.DSSMetricsEngine;
import com.dataiku.dip.metrics.engines.HiveMetricsEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.MetricsQueryBuilder;
import com.dataiku.dip.metrics.engines.SQLMetricsEngine;
import com.dataiku.dip.metrics.engines.SparkMetricsEngine;
import com.dataiku.dip.metrics.probes.BasicStatsDatasetProbeType;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.tdunning.math.stats.AVLTreeDigest;
import com.tdunning.math.stats.TDigest;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PercentileStatsDatasetProbeType
extends ProbeType {
    public static final String TYPE = "percentile_stats";
    private static final Set<String> windowFunctionPercentile = Sets.newHashSet((Object[])new String[]{BuiltinSQLDatasets.VERTICA_META.getType(), BuiltinSQLDatasets.REDSHIFT_META.getType()});
    private static final Set<String> aggregateFunctionPercentile = Sets.newHashSet((Object[])new String[]{BuiltinSQLDatasets.ORACLE_META.getType(), BuiltinSQLDatasets.TERADATA_META.getType(), BuiltinSQLDatasets.POSTGRESQL_META.getType(), BuiltinSQLDatasets.ALLOYDB_META.getType(), BuiltinSQLDatasets.GREENPLUM_META.getType(), BuiltinSQLDatasets.BIGQUERY_META.getType(), BuiltinSQLDatasets.DATABRICKS_LAKEBASE_META.getType(), BuiltinSQLDatasets.SNOWFLAKE_META.getType(), "Sqream"});
    private static Map<PercentileStatsDatasetMetrics, MetricMetadata> metadataPerType = Maps.newHashMap();
    private static Date dateMeaning = new Date();
    private static DateOnly dateOnlyMeaning = new DateOnly();
    private static DatetimeNoTz datetimeNoTzMeaning = new DatetimeNoTz();
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.percentilestats");

    @Override
    public List<MetricComputer> getComputers(IBasicMeaningsService basicMeaningsService) {
        ArrayList computers = Lists.newArrayList();
        computers.add(new PercentileStatsDSSComputer());
        computers.add(new PercentileStatsSQLMetricsAggregateEngineComputer(new PercentileStatsMetricsEngineComputer()));
        computers.add(new PercentileStatsSQLMetricsWindowEngineComputer(new PercentileStatsMetricsEngineComputer()));
        computers.add(new PercentileStatsHiveMetricsEngineComputer(new PercentileStatsMetricsEngineComputer()));
        computers.add(new PercentileStatsSparkMetricsEngineComputer(new PercentileStatsMetricsEngineComputer()));
        return computers;
    }

    public PercentileStatsDatasetProbeType() {
        metadataPerType.put(PercentileStatsDatasetMetrics.P25, new MetricMetadata().withName("P25").withFormat("longReadableNumber"));
        metadataPerType.put(PercentileStatsDatasetMetrics.P50, new MetricMetadata().withName("Median").withFormat("longReadableNumber"));
        metadataPerType.put(PercentileStatsDatasetMetrics.P75, new MetricMetadata().withName("P75").withFormat("longReadableNumber"));
        metadataPerType.put(PercentileStatsDatasetMetrics.IQR, new MetricMetadata().withName("Interquartile range").withFormat("longReadableNumber"));
        metadataPerType.put(PercentileStatsDatasetMetrics.QUARTILES, new MetricMetadata().withName("Quartiles").withFormat("longReadableNumber"));
        this.type = TYPE;
    }

    @Override
    public List<Metric> listBuildableMetrics(Object object, MetricTargetType objectType) {
        ArrayList metrics = Lists.newArrayList();
        if (objectType == MetricTargetType.DATASET) {
            Dataset dataset = (Dataset)object;
            for (SchemaColumn column : dataset.getSchema().getColumns()) {
                for (PercentileStatsDatasetMetrics aggregated : PercentileStatsDatasetMetrics.values()) {
                    boolean disabled;
                    boolean aggregateNeedNumeric = true;
                    boolean bl = disabled = aggregateNeedNumeric && !column.getType().isNumeric() && !column.getType().isTemporal();
                    if (disabled) continue;
                    PercentileStatsDatasetMetric metric = new PercentileStatsDatasetMetric(aggregated, column.getName(), column.getType());
                    metrics.add(metric);
                }
            }
        }
        return metrics;
    }

    @Override
    public Object listSelectableMetrics(Probe probe, Object object, MetricTargetType objectType) {
        if (objectType == MetricTargetType.DATASET) {
            PercentileStatsDatasetProbeHint probeHint = new PercentileStatsDatasetProbeHint();
            Dataset dataset = (Dataset)object;
            for (SchemaColumn column : dataset.getSchema().getColumns()) {
                PercentileStatsDatasetProbeColumnHint columnHint = new PercentileStatsDatasetProbeColumnHint(column.getName());
                HashSet activeMetrics = Sets.newHashSet();
                for (PercentileStatsDatasetProbeColumnConfiguration aggregate : ((PercentileStatsDatasetProbeConfiguration)probe.configuration).aggregates) {
                    if (!aggregate.column.equals(column.getName())) continue;
                    activeMetrics.add(aggregate.aggregated);
                }
                for (PercentileStatsDatasetMetrics aggregated : PercentileStatsDatasetMetrics.values()) {
                    boolean aggregateNeedNumeric = true;
                    boolean disabled = aggregateNeedNumeric && !column.getType().isNumeric() && !column.getType().isTemporal();
                    columnHint.metrics.add(new PercentileStatsDatasetProbeMetricHint(PercentileStatsDatasetProbeType.metadataPerType.get((Object)((Object)aggregated)).name, aggregated, activeMetrics.contains((Object)aggregated), disabled));
                }
                probeHint.columns.add(columnHint);
            }
            return probeHint;
        }
        return null;
    }

    @Override
    public List<Metric> getMetricsToCompute(Probe probe, Object object, MetricTargetType objectType, boolean forDisplay) {
        ArrayList metrics = Lists.newArrayList();
        if (objectType == MetricTargetType.DATASET) {
            Dataset dataset = (Dataset)object;
            PercentileStatsDatasetProbeConfiguration configuration = (PercentileStatsDatasetProbeConfiguration)probe.getConfiguration();
            for (PercentileStatsDatasetProbeColumnConfiguration configured : configuration.aggregates) {
                SchemaColumn column = dataset.getSchema().getColumn(configured.column);
                if (column != null) {
                    PercentileStatsDatasetMetric metric = new PercentileStatsDatasetMetric(configured.aggregated, column.getName(), column.getType());
                    metrics.add(metric);
                    if (configured.aggregated != PercentileStatsDatasetMetrics.QUARTILES || !windowFunctionPercentile.contains(dataset.getType())) continue;
                    BasicStatsDatasetProbeType.BasicStatsDatasetMetric minMetric = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.MIN, column.getName(), column.getType());
                    BasicStatsDatasetProbeType.BasicStatsDatasetMetric maxMetric = new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.MAX, column.getName(), column.getType());
                    metrics.add(minMetric);
                    metrics.add(maxMetric);
                    continue;
                }
                logger.warn((Object)("Configured a metric on '" + configured.column + "' which has disappeared since. Skipping."));
            }
        }
        return metrics;
    }

    @Override
    public ProbeConfiguration buildFullConfiguration(List<SchemaColumn> columns, Probe probe) {
        PercentileStatsDatasetProbeConfiguration configuration = new PercentileStatsDatasetProbeConfiguration();
        for (SchemaColumn column : columns) {
            for (PercentileStatsDatasetMetrics aggregated : PercentileStatsDatasetMetrics.values()) {
                boolean aggregateNeedNumeric = true;
                if (aggregateNeedNumeric && !column.getType().isNumeric() && !column.getType().isTemporal()) continue;
                PercentileStatsDatasetProbeColumnConfiguration columnConfiguration = new PercentileStatsDatasetProbeColumnConfiguration();
                columnConfiguration.aggregated = aggregated;
                columnConfiguration.column = column.getName();
                configuration.aggregates.add(columnConfiguration);
            }
        }
        return configuration;
    }

    @Override
    public ProbeType trimForSave() {
        return new PercentileStatsDatasetProbeType();
    }

    @Override
    public Class<? extends ProbeConfiguration> getParamsClazz() {
        return PercentileStatsDatasetProbeConfiguration.class;
    }

    @Override
    public ProbeMetadata getMeta() {
        return new ProbeMetadata().withLevel(4).withName("Columns percentiles");
    }

    @Override
    public boolean isUserSelectedProbe() {
        return false;
    }

    public static class PercentileStatsDSSComputer
    extends DSSMetricsEngine.DSSMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return PercentileStatsDatasetProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            return new DSSMetricsEngine.DSSMetricsEngineRun().with(new MetricComputation(probe, this, metric, 10.0));
        }

        @Override
        public DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession start(DSSMetricsEngine.DSSMetricsEngineCallbacks engine, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
            PercentileStatsDatasetMetric metric = (PercentileStatsDatasetMetric)computations.get((int)0).metric;
            PercentileStatsDSSComputerSession session = new PercentileStatsDSSComputerSession();
            session.computations = computations;
            session.column = engine.getColumnFactory().column(metric.getColumn());
            session.type = engine.getColumnByName().get(metric.getColumn()).getType();
            session.digest = new AVLTreeDigest(100.0);
            computations.forEach(computation -> {
                computation.session = session;
            });
            return session;
        }

        @Override
        public void cleanup(DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) throws Exception {
        }

        @Override
        public boolean accumulate(Row row, DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) throws Exception {
            double v;
            PercentileStatsDSSComputerSession session = (PercentileStatsDSSComputerSession)dssComputerSession;
            String value = row.get(session.column);
            if (StringUtils.isNotBlank((String)value) && !Double.isNaN(v = session.type == Type.DATE ? dateMeaning.doubleValue(value) : (session.type == Type.DATEONLY ? dateOnlyMeaning.doubleValue(value) : (session.type == Type.DATETIMENOTZ ? datetimeNoTzMeaning.doubleValue(value) : Double.parseDouble(value)))) && !Double.isInfinite(v)) {
                session.digest.add(v);
            }
            return true;
        }

        @Override
        public Map<Metric, String> getAggregates(DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) {
            PercentileStatsDSSComputerSession session = (PercentileStatsDSSComputerSession)dssComputerSession;
            HashMap<Metric, String> aggregates = new HashMap<Metric, String>();
            session.computations.forEach(computation -> {
                PercentileStatsDatasetMetric metric = (PercentileStatsDatasetMetric)computation.metric;
                if (session.digest.size() > 0L) {
                    PercentileStatsDatasetMetrics aggregated = metric.getMetricType();
                    switch (aggregated) {
                        case P25: 
                        case P50: 
                        case P75: {
                            double percentile = aggregated == PercentileStatsDatasetMetrics.P25 ? 0.25 : (aggregated == PercentileStatsDatasetMetrics.P50 ? 0.5 : 0.75);
                            double quantile = session.digest.quantile(percentile);
                            if (session.type == Type.DATE) {
                                aggregates.put(computation.metric, DKUDateUtils.isoFormatUTC((long)((long)quantile)));
                                break;
                            }
                            if (session.type == Type.DATEONLY) {
                                aggregates.put(computation.metric, ISODateTimeFormat.date().print((long)quantile));
                                break;
                            }
                            if (session.type == Type.DATETIMENOTZ) {
                                aggregates.put(computation.metric, DatetimeNoTz.CANONICAL_FORMATTER.print((long)quantile));
                                break;
                            }
                            aggregates.put(computation.metric, String.valueOf(quantile));
                            break;
                        }
                        case IQR: {
                            aggregates.put(computation.metric, String.valueOf(session.digest.quantile(0.75) - session.digest.quantile(0.25)));
                            break;
                        }
                        case QUARTILES: {
                            if (session.type.isTemporal()) {
                                long q0 = (long)session.digest.quantile(0.0);
                                long q25 = (long)session.digest.quantile(0.25);
                                long q50 = (long)session.digest.quantile(0.5);
                                long q75 = (long)session.digest.quantile(0.75);
                                long q100 = (long)session.digest.quantile(1.0);
                                aggregates.put(computation.metric, JSON.json((Object)Lists.newArrayList((Object[])new String[]{DKUDateUtils.isoFormatUTC((long)q0), DKUDateUtils.isoFormatUTC((long)q25), DKUDateUtils.isoFormatUTC((long)q50), DKUDateUtils.isoFormatUTC((long)q75), DKUDateUtils.isoFormatUTC((long)q100)})));
                                break;
                            }
                            aggregates.put(computation.metric, JSON.json((Object)Lists.newArrayList((Object[])new Double[]{session.digest.quantile(0.0), session.digest.quantile(0.25), session.digest.quantile(0.5), session.digest.quantile(0.75), session.digest.quantile(1.0)})));
                        }
                    }
                } else {
                    aggregates.put(computation.metric, null);
                }
            });
            return aggregates;
        }

        @Override
        public boolean canComputeWith(List<MetricComputation> handledComputations, List<MetricComputation> otherComputations) {
            String column = handledComputations.get((int)0).metric.getColumn();
            return otherComputations.stream().allMatch(computation -> computation.computer instanceof PercentileStatsDSSComputer && computation.metric.getColumn().equals(column));
        }

        @Override
        public JsonObject writeJson(JsonSerializationContext ctx) {
            JsonObject obj = new JsonObject();
            return obj;
        }

        @Override
        public void readJson(JsonObject jsonObj, JsonDeserializationContext ctx) {
        }

        public static class PercentileStatsDSSComputerSession
        implements DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession {
            public List<MetricComputation> computations;
            private Column column;
            private Type type;
            public TDigest digest;
        }
    }

    public static class PercentileStatsSQLMetricsAggregateEngineComputer
    extends MetricComputer.SQLMetricsEngineComputer {
        private final PercentileStatsMetricsEngineComputer subComputer;

        public PercentileStatsSQLMetricsAggregateEngineComputer(PercentileStatsMetricsEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return PercentileStatsDatasetProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET && DatasetInspector.isSQLAble(authCtx, (Dataset)object)) {
                String datasetType = ((Dataset)object).getType();
                if (aggregateFunctionPercentile.contains(datasetType)) {
                    return new SQLMetricsEngine.SQLMetricsEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
                }
                if (BuiltinSQLDatasets.JDBC_META.getType().equals(datasetType)) {
                    try {
                        JdbcConnection conn = (JdbcConnection)DatasetInspector.getDSSConnectionForSQLOrHiveDataset(authCtx, (Dataset)object);
                        SQLDialect dialect = conn.getDialect();
                        if (aggregateFunctionPercentile.contains(dialect.getId())) {
                            return new SQLMetricsEngine.SQLMetricsEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
                        }
                        return null;
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Unable to check whether percentiles can be computed in-database", (Throwable)e);
                        return null;
                    }
                }
                return null;
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(engine.getDataset(), computation, dialect, queryBuilder, alreadyComputed);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class PercentileStatsMetricsEngineComputer {
        public List<ExpressionBuilder> getAggregations(PercentileStatsDatasetMetrics aggregated, SchemaColumn column, DatasetHandler.DatasetParams datasetParams, boolean isDatasetManaged, SQLDialect dialect, ExpressionBuilder.ExpressionBuilderFactory ef) {
            ExpressionBuilder col = ef.col(column.getName());
            if (column.getType() == Type.DATE) {
                col = ExpressionUtils.getAdjustedColumn(col, column, datasetParams, isDatasetManaged, dialect);
                col = col.mssToEpoch();
            } else if (column.getType() == Type.DATEONLY) {
                col = col.mssToDateOnlyEpoch();
            } else if (column.getType() == Type.DATETIMENOTZ) {
                col = col.mssToDatetimeNoTzEpoch();
            }
            if (dialect.getOperator(QueryUtils.OperatorType.PERCENTILE_APPROX_AGG) != null) {
                switch (aggregated) {
                    case P25: {
                        return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.percentileApproxAgg(0.25)});
                    }
                    case P50: {
                        return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.percentileApproxAgg(0.5)});
                    }
                    case P75: {
                        return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.percentileApproxAgg(0.75)});
                    }
                    case IQR: {
                        return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.percentileApproxAgg(0.75), col.percentileApproxAgg(0.25)});
                    }
                    case QUARTILES: {
                        return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.min(), col.percentileApproxAgg(0.25), col.percentileApproxAgg(0.5), col.percentileApproxAgg(0.75), col.max()});
                    }
                }
            } else if (dialect.getOperator(QueryUtils.OperatorType.PERCENTILE_APPROX_WIN) != null) {
                switch (aggregated) {
                    case P25: {
                        return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.percentileApproxWin(0.25)});
                    }
                    case P50: {
                        return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.percentileApproxWin(0.5)});
                    }
                    case P75: {
                        return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.percentileApproxWin(0.75)});
                    }
                    case IQR: {
                        return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.percentileApproxWin(0.75), col.percentileApproxWin(0.25)});
                    }
                    case QUARTILES: {
                        return Lists.newArrayList((Object[])new ExpressionBuilder[]{col.percentileApproxWin(1.0E-8), col.percentileApproxWin(0.25), col.percentileApproxWin(0.5), col.percentileApproxWin(0.75), col.percentileApproxWin(0.99999999)});
                    }
                }
            }
            return Lists.newArrayList();
        }

        public void addAggregations(Dataset dataset, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            PercentileStatsComputerSession session = new PercentileStatsComputerSession();
            computation.session = session;
            session.dialect = dialect;
            PercentileStatsDatasetMetric metric = (PercentileStatsDatasetMetric)computation.metric;
            session.aggregated = metric.getMetricType();
            String columnName = metric.getColumn();
            SchemaColumn column = dataset.getSchema().getColumn(columnName);
            session.type = column.getType();
            session.usePrecomputedMinMax = dialect.getOperator(QueryUtils.OperatorType.PERCENTILE_APPROX_AGG) == null && dialect.getOperator(QueryUtils.OperatorType.PERCENTILE_APPROX_WIN) != null;
            ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
            int aggCount = 0;
            for (ExpressionBuilder expr : this.getAggregations(metric.getMetricType(), column, dataset.getParams(), dataset.isManaged(), dialect, ef)) {
                SelectQueryBuilder.SelectRefBuilder ref = queryBuilder.select(expr, metric.getMetricType().name() + "_" + columnName + "_" + aggCount++);
                session.offsets.add(ref.getIndex());
            }
            session.minValue = alreadyComputed.get(new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.MIN, metric.getColumn(), column.getType()).getId());
            session.maxValue = alreadyComputed.get(new BasicStatsDatasetProbeType.BasicStatsDatasetMetric(BasicStatsDatasetProbeType.BasicStatsDatasetMetrics.MAX, metric.getColumn(), column.getType()).getId());
        }

        public String getAggregate(PercentileStatsComputerSession session, QueryRunResult rs2, List<Integer> offsets, PercentileStatsDatasetMetrics aggregated, Metric metric) throws SQLException {
            if (session.aggregated == PercentileStatsDatasetMetrics.IQR) {
                String p75Str = rs2.rows.get(0)[offsets.get(0) - 1];
                String p25Str = rs2.rows.get(0)[offsets.get(1) - 1];
                if (StringUtils.isBlank((String)p75Str) || StringUtils.isBlank((String)p25Str)) {
                    return null;
                }
                double p75 = Double.parseDouble(p75Str);
                double p25 = Double.parseDouble(p25Str);
                return Double.toString(p75 - p25);
            }
            if (session.aggregated == PercentileStatsDatasetMetrics.QUARTILES) {
                String p0Str = rs2.rows.get(0)[offsets.get(0) - 1];
                String p25Str = rs2.rows.get(0)[offsets.get(1) - 1];
                String p50Str = rs2.rows.get(0)[offsets.get(2) - 1];
                String p75Str = rs2.rows.get(0)[offsets.get(3) - 1];
                String p100Str = rs2.rows.get(0)[offsets.get(4) - 1];
                if (session.usePrecomputedMinMax) {
                    p0Str = session.minValue;
                    p100Str = session.maxValue;
                    if (session.type == Type.DATE) {
                        p0Long = dateMeaning.msSinceEpoch(p0Str);
                        p100Long = dateMeaning.msSinceEpoch(p100Str);
                        p0Str = p0Long != Long.MAX_VALUE ? Long.toString(p0Long) : "";
                        p100Str = p100Long != Long.MAX_VALUE ? Long.toString(p100Long) : "";
                    } else if (session.type == Type.DATEONLY) {
                        p0Long = dateOnlyMeaning.msSinceEpoch(p0Str);
                        p100Long = dateOnlyMeaning.msSinceEpoch(p100Str);
                        p0Str = p0Long != Long.MAX_VALUE ? Long.toString(p0Long) : "";
                        p100Str = p100Long != Long.MAX_VALUE ? Long.toString(p100Long) : "";
                    } else if (session.type == Type.DATETIMENOTZ) {
                        p0Long = datetimeNoTzMeaning.msSinceEpoch(p0Str);
                        p100Long = datetimeNoTzMeaning.msSinceEpoch(p100Str);
                        p0Str = p0Long != Long.MAX_VALUE ? Long.toString(p0Long) : "";
                        String string = p100Str = p100Long != Long.MAX_VALUE ? Long.toString(p100Long) : "";
                    }
                }
                if (StringUtils.isBlank((String)p0Str) || StringUtils.isBlank((String)p25Str) || StringUtils.isBlank((String)p50Str) || StringUtils.isBlank((String)p75Str) || StringUtils.isBlank((String)p100Str)) {
                    return null;
                }
                double p0 = Double.parseDouble(p0Str);
                double p25 = Double.parseDouble(p25Str);
                double p50 = Double.parseDouble(p50Str);
                double p75 = Double.parseDouble(p75Str);
                double p100 = Double.parseDouble(p100Str);
                if (session.type.isTemporal()) {
                    return JSON.json((Object)Lists.newArrayList((Object[])new String[]{DKUDateUtils.isoFormatUTC((long)((long)p0)), DKUDateUtils.isoFormatUTC((long)((long)p25)), DKUDateUtils.isoFormatUTC((long)((long)p50)), DKUDateUtils.isoFormatUTC((long)((long)p75)), DKUDateUtils.isoFormatUTC((long)((long)p100))}));
                }
                return JSON.json((Object)Lists.newArrayList((Object[])new Double[]{p0, p25, p50, p75, p100}));
            }
            String v = rs2.rows.get(0)[offsets.get(0) - 1];
            if (StringUtils.isBlank((String)v)) {
                return null;
            }
            if (session.type == Type.DATE) {
                return DKUDateUtils.isoFormatUTC((long)((long)Double.parseDouble(v)));
            }
            if (session.type == Type.DATEONLY) {
                return DatetimeNoTz.CANONICAL_FORMATTER.print((long)Double.parseDouble(v)).substring(0, 10);
            }
            if (session.type == Type.DATETIMENOTZ) {
                return DatetimeNoTz.CANONICAL_FORMATTER.print((long)Double.parseDouble(v));
            }
            return v;
        }

        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            PercentileStatsComputerSession session = (PercentileStatsComputerSession)computation.session;
            return this.getAggregate(session, rs2, session.offsets, session.aggregated, computation.metric);
        }

        public static class PercentileStatsComputerSession {
            public PercentileStatsDatasetMetrics aggregated;
            public Type type;
            public SQLDialect dialect;
            public List<Integer> offsets = Lists.newArrayList();
            public boolean usePrecomputedMinMax;
            public String minValue;
            public String maxValue;
        }
    }

    public static class PercentileStatsSQLMetricsWindowEngineComputer
    extends MetricComputer.SQLMetricsEngineComputer {
        private final PercentileStatsMetricsEngineComputer subComputer;

        public PercentileStatsSQLMetricsWindowEngineComputer(PercentileStatsMetricsEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return PercentileStatsDatasetProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET && DatasetInspector.isSQLAble(authCtx, (Dataset)object)) {
                String datasetType = ((Dataset)object).getType();
                if (windowFunctionPercentile.contains(datasetType)) {
                    return new SQLMetricsEngine.SQLMetricsEngineRun(1.0, Lists.newArrayList((Object[])new MetricComputation[]{new MetricComputation(probe, this, metric, 1.0)}), 2).withUsesWindowFunctionAsAggregate(true);
                }
                return null;
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(engine.getDataset(), computation, dialect, queryBuilder, alreadyComputed);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class PercentileStatsHiveMetricsEngineComputer
    extends MetricComputer.HiveMetricsEngineComputer {
        private PercentileStatsMetricsEngineComputer subComputer;

        public PercentileStatsHiveMetricsEngineComputer(PercentileStatsMetricsEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return PercentileStatsDatasetProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET && DatasetInspector.isHDFSDatasetOrHiveTableDataset((Dataset)object)) {
                return new HiveMetricsEngine.HiveMetricsEngineRun().with(new MetricComputation(probe, this, metric, 2.0));
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(engine.getDataset(), computation, dialect, queryBuilder, alreadyComputed);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static class PercentileStatsSparkMetricsEngineComputer
    extends MetricComputer.SparkMetricsEngineComputer {
        private PercentileStatsMetricsEngineComputer subComputer;

        public PercentileStatsSparkMetricsEngineComputer(PercentileStatsMetricsEngineComputer subComputer) {
            this.subComputer = subComputer;
        }

        @Override
        public String getProbeType() {
            return PercentileStatsDatasetProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.DATASET) {
                return new SparkMetricsEngine.SparkMetricsEngineRun().with(new MetricComputation(probe, this, metric, 3.0));
            }
            return null;
        }

        @Override
        public void addAggregations(AuthCtx authCtx, MetricsQueryBuilder.MetricsQueryBuilderEngine engine, MetricComputation computation, SQLDialect dialect, SelectQueryBuilder queryBuilder, Map<String, String> alreadyComputed) throws Exception {
            this.subComputer.addAggregations(engine.getDataset(), computation, dialect, queryBuilder, alreadyComputed);
        }

        @Override
        public String getAggregate(QueryRunResult rs2, MetricComputation computation) throws Exception {
            return this.subComputer.getAggregate(rs2, computation);
        }
    }

    public static enum PercentileStatsDatasetMetrics {
        P25,
        P50,
        P75,
        IQR,
        QUARTILES;

    }

    public static class PercentileStatsDatasetMetric
    extends Metric {
        public PercentileStatsDatasetMetrics metricType;
        public String column;

        public PercentileStatsDatasetMetric(PercentileStatsDatasetMetrics metricType, String column, Type columnType) {
            super(PercentileStatsDatasetProbeType.TYPE, PercentileStatsDatasetMetric.getDataTypeFromMetricType(metricType, columnType));
            this.metricType = metricType;
            this.column = column;
            this.id = Metric.serializeMetric(this);
        }

        private static Type getDataTypeFromMetricType(PercentileStatsDatasetMetrics metricType, Type columnType) {
            switch (metricType) {
                case P25: 
                case P50: 
                case P75: {
                    if (columnType.isTemporal()) {
                        return columnType;
                    }
                    return Type.DOUBLE;
                }
                case IQR: {
                    return Type.DOUBLE;
                }
                case QUARTILES: {
                    return Type.ARRAY;
                }
            }
            return Type.STRING;
        }

        public PercentileStatsDatasetMetrics getMetricType() {
            return this.metricType;
        }

        @Override
        public String getColumn() {
            return this.column;
        }

        @Override
        public MetricMetadata getMeta() {
            MetricMetadata meta = new MetricMetadata(metadataPerType.get((Object)this.metricType));
            meta.withFullName(meta.getName() + " of " + this.column);
            return meta;
        }

        @Override
        public String getColumnInvariantId(String placeholder) {
            return new PercentileStatsDatasetMetric(this.metricType, placeholder, this.dataType).getId();
        }

        @Override
        public Probe getMatchingProbe(List<Probe> probes) {
            PercentileStatsDatasetProbeConfiguration conf = new PercentileStatsDatasetProbeConfiguration();
            PercentileStatsDatasetProbeColumnConfiguration col = new PercentileStatsDatasetProbeColumnConfiguration();
            col.column = this.column;
            col.aggregated = this.metricType;
            conf.aggregates.add(col);
            return new Probe(this.getType()).withConfiguration(conf).withMeta(ProbeType.getProbeType(PercentileStatsDatasetProbeType.TYPE).getMeta());
        }
    }

    public static class PercentileStatsDatasetProbeHint {
        public List<PercentileStatsDatasetProbeColumnHint> columns = Lists.newArrayList();
    }

    public static class PercentileStatsDatasetProbeColumnHint {
        public String column;
        public List<PercentileStatsDatasetProbeMetricHint> metrics = Lists.newArrayList();

        PercentileStatsDatasetProbeColumnHint(String column) {
            this.column = column;
        }
    }

    public static class PercentileStatsDatasetProbeConfiguration
    implements ProbeConfiguration {
        public List<PercentileStatsDatasetProbeColumnConfiguration> aggregates = Lists.newArrayList();
    }

    public static class PercentileStatsDatasetProbeColumnConfiguration {
        public String column;
        public PercentileStatsDatasetMetrics aggregated;
    }

    public static class PercentileStatsDatasetProbeMetricHint {
        public String name;
        public boolean disabled;
        public boolean active;
        public PercentileStatsDatasetMetrics aggregated;

        PercentileStatsDatasetProbeMetricHint(String name, PercentileStatsDatasetMetrics aggregated, boolean active, boolean disabled) {
            this.name = name;
            this.aggregated = aggregated;
            this.active = active;
            this.disabled = disabled;
        }
    }

    public static class PercentileStatsDatasetMetricSerializer
    implements Metric.MetricIdSerializer {
        @Override
        public String serializeMetric(Metric metric) {
            if (!(metric instanceof PercentileStatsDatasetMetric)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metric.getClass().getSimpleName());
            }
            PercentileStatsDatasetMetric PercentileStatsDatasetMetric2 = (PercentileStatsDatasetMetric)metric;
            return Metric.buildMetricIdFromParts(PercentileStatsDatasetProbeType.TYPE, PercentileStatsDatasetMetric2.getMetricType().name(), PercentileStatsDatasetMetric2.getColumn());
        }

        @Override
        public Metric deserializeMetric(String metricId) {
            List<String> parts = Metric.buildPartsFromMetricId(metricId);
            if (parts.size() != 3 || !parts.get(0).equals(PercentileStatsDatasetProbeType.TYPE)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metricId);
            }
            return new PercentileStatsDatasetMetric(PercentileStatsDatasetMetrics.valueOf(parts.get(1)), parts.get(2), Type.STRING);
        }
    }
}

