/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss;

import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.TensorType;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Date;

public class GenericDataTensor<T>
extends DataTensor<T> {
    public T[] tensor;
    public T[][] axes;
    public static String RESERVED_CALL_EXCEPTION = "Method is reserved to the DoubleDataTensor";
    public static String WRONG_CALL_EXCEPTION = "Method could not be called with the current tensor inferred type";

    private GenericDataTensor(int[] axisLengths, boolean dimension1MemorySaving, boolean initNonNullCounts, Class<T> clazz) {
        super(axisLengths, TensorType.UNKNOWN, dimension1MemorySaving, initNonNullCounts, clazz);
        this.tensor = (Object[])Array.newInstance(clazz, this.tensorSize);
        if (!dimension1MemorySaving) {
            this.axes = (Object[][])Array.newInstance(clazz, this.numAxes, 0);
            for (int i = 0; i < this.numAxes; ++i) {
                this.axes[i] = (Object[])Array.newInstance(clazz, this.axisLengths[i]);
            }
        }
    }

    @Override
    public int getAxisLength(int index) {
        return this.axes[index].length;
    }

    @Override
    public void set(int location, T data) {
        this.set(location, data, false);
    }

    @Override
    public void set(int location, T data, boolean inferType) {
        if (inferType) {
            this.inferType(data);
        }
        this.tensor[location] = data instanceof DateTime || data instanceof Date ? Long.valueOf(new DateTime(data).getMillis()) : data;
    }

    @Override
    public T get(int location, boolean realType) {
        T value = this.tensor[location];
        if (realType && this.type == TensorType.DATE && value != null) {
            if (value instanceof Double) {
                Double doubleValue = (Double)value;
                if (doubleValue == MIN_SAFE_INTEGER) {
                    return null;
                }
                return (T)new DateTime(doubleValue.longValue(), DateTimeZone.UTC);
            }
            return (T)new DateTime(value);
        }
        return value;
    }

    @Override
    public T getAxis(int i, int j) {
        return this.axes[i][j];
    }

    @Override
    public void setAxis(int i, int j, T value) {
        this.axes[i][j] = value instanceof DateTime || value instanceof Date ? Long.valueOf(new DateTime(value).getMillis()) : value;
    }

    public T put(int[] coordinates, T data) {
        this.tensor[this.loc((int[])coordinates)] = data;
        return data;
    }

    @Override
    public DataTensor<T> createMergeDT(int axisLength) {
        return this.createMergeDT(axisLength, this.hasNullValues);
    }

    @Override
    public DataTensor<T> createMergeDT(int[] axisLengths) {
        return this.createMergeDT(axisLengths, this.hasNullValues);
    }

    @Override
    public DataTensor<T> createMergeDT(int[] axisLengths, boolean hasNullValues) {
        DataTensor mergeDT = new Builder().clazz(this.clazz).axisLengths(axisLengths).initNonNullCounts(hasNullValues).build();
        mergeDT.hasNullValues = hasNullValues;
        return mergeDT;
    }

    @Override
    public DataTensor<T> createMergeDT(int axisLength, boolean hasNullValues) {
        DataTensor mergeDT = new Builder().clazz(this.clazz).axisLengths(axisLength).initNonNullCounts(hasNullValues).build();
        mergeDT.hasNullValues = hasNullValues;
        return mergeDT;
    }

    @Override
    public T getOrDefault(int[] coordinates, T defaultValue) {
        int index = this.loc(coordinates);
        if (this.tensor[index] == null) {
            this.tensor[index] = defaultValue;
        }
        return this.tensor[index];
    }

    @Override
    public void resize(int newCapacity) {
        this.tensor = Arrays.copyOf(this.tensor, newCapacity);
        this.tensorSize = newCapacity;
    }

    @Override
    public void initDoubleTensor(double value) {
        throw new NotImplementedException(RESERVED_CALL_EXCEPTION);
    }

    @Override
    public void setAsDouble(int[] coords, double value) {
        this.setAsDouble(this.loc(coords), value);
    }

    @Override
    public double getAsDouble(int location) {
        Object value = this.get(location);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value == null) {
            return Double.NaN;
        }
        throw new NotImplementedException(WRONG_CALL_EXCEPTION);
    }

    @Override
    public void setAsDouble(int location, double value) {
        Object current = this.get(location);
        if (!(current instanceof Number) && current != null) {
            throw new NotImplementedException(WRONG_CALL_EXCEPTION);
        }
        this.tensor[location] = new Double(value);
    }

    @Override
    public double getAxisAsDouble(int i, int j) {
        T axisValue = this.getAxis(i, j);
        if (axisValue instanceof Number) {
            return ((Number)axisValue).doubleValue();
        }
        if (axisValue == null) {
            return Double.NaN;
        }
        throw new NotImplementedException(WRONG_CALL_EXCEPTION);
    }

    @Override
    public double[] getAxisAsDouble(int i) {
        throw new NotImplementedException(WRONG_CALL_EXCEPTION);
    }

    @Override
    public void setAxisAsDouble(int i, int j, double value) {
        T current = this.getAxis(i, j);
        if (!(current instanceof Number) && current != null) {
            throw new NotImplementedException(WRONG_CALL_EXCEPTION);
        }
        this.setAxis(i, j, new Double(value));
    }

    @Override
    public double[] getDoubleTensor() {
        throw new NotImplementedException(WRONG_CALL_EXCEPTION);
    }

    @Override
    public double[][] getDoubleAxes() {
        throw new NotImplementedException(WRONG_CALL_EXCEPTION);
    }

    @Override
    public int getAxesLength() {
        return this.axes.length;
    }

    @Override
    public T[] getTensor() {
        return this.tensor;
    }

    @Override
    public void replaceInvalidValues() {
        if (this.type != TensorType.NUMERICAL && this.type != TensorType.UNKNOWN) {
            return;
        }
        for (int i = 0; i < this.numAxes && !this.dimension1MemorySaving; ++i) {
            for (int k = 0; k < this.axes[i].length; ++k) {
                if (this.axes[i][k] != null && !Double.isInfinite(this.getAxisAsDouble(i, k)) && !Double.isNaN(this.getAxisAsDouble(i, k))) continue;
                this.setAxis(i, k, new Double(0.0));
            }
        }
        for (int k = 0; k < this.tensor.length; ++k) {
            if (this.tensor[k] != null && !Double.isInfinite(this.getAsDouble(k)) && !Double.isNaN(this.getAsDouble(k))) continue;
            this.set(k, new Double(0.0));
        }
    }

    public static class Builder<T>
    extends DataTensor.Builder<T> {
        Class<T> clazz;

        public Builder<T> clazz(Class<T> clazz) {
            this.clazz = clazz;
            return this;
        }

        @Override
        public GenericDataTensor<T> build() {
            return new GenericDataTensor<T>(this.axisLengths, this.dimension1MemorySaving, this.initNonNullCounts, this.clazz);
        }
    }
}

