/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.executors;

import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import com.dataiku.dip.pivot.backend.sql.builders.FacetBuilder;
import com.dataiku.dip.pivot.backend.sql.executors.ExecutionContext;
import com.dataiku.dip.pivot.backend.sql.executors.SqlExecutionHelper;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.pivot.backend.sql.queries.FacetToSQL;
import com.dataiku.dip.pivot.backend.sql.utils.ConnectionPool;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.utils.DKULogger;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class FacetSQLExecutor
implements Callable<FilterFacet> {
    private ExecutionContext ctx;
    private Future<ColumnMapper> colMappingFuture;
    private List<RowFilter> otherFilters;
    private int atIndex;
    private BasicStatsBuilder.BasicStats basicStats;
    private RowFilter rf;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.charts.sql.facets");

    public FacetSQLExecutor(ExecutionContext ctx, Future<ColumnMapper> colMappingFuture, RowFilter rf, List<RowFilter> otherFilters, int atIndex, BasicStatsBuilder.BasicStats basicStats) {
        this.ctx = ctx;
        this.colMappingFuture = colMappingFuture;
        this.rf = rf;
        this.otherFilters = otherFilters;
        this.atIndex = atIndex;
        this.basicStats = basicStats;
    }

    @Override
    public FilterFacet call() throws Exception {
        ColumnMapper colMapping = this.colMappingFuture.get();
        FacetToSQL facetToSQL = new FacetToSQL(this.ctx.input, this.otherFilters, this.rf, colMapping);
        try (ConnectionPool.PooledConnection connection = this.ctx.sqlPool.get();){
            FilterFacet ff = this.getFilterFacet(facetToSQL, connection);
            if (this.rf.allValuesInSample) {
                this.applyNonRelevantValuesToFilterFacet(ff, facetToSQL, connection);
            }
            FilterFacet filterFacet = ff;
            return filterFacet;
        }
    }

    private FilterFacet getFilterFacet(FacetToSQL facetToSQL, ConnectionPool.PooledConnection connection) throws Exception {
        FilterFacet ff;
        String query = facetToSQL.buildQuery();
        logger.info((Object)("Runnning SQL query for computing facet " + (this.atIndex + 1) + ":\n" + query));
        try (ConnectionPool.ManagedStatement stmt = connection.getStatement();
             FutureAborter.AutoCloseableAbortHook ignored = FutureAborter.pushAutoCloseableHook(stmt::cancel);){
            SqlExecutionHelper.execute(connection, stmt, query, true);
            try (ResultSet rs2 = stmt.get().getResultSet();){
                FacetBuilder builder = new FacetBuilder(this.atIndex, this.rf);
                ff = builder.fromResultSet(rs2, this.basicStats != null ? this.basicStats.columnStats.get(this.rf.column) : null);
            }
            logger.debug((Object)"Statement done");
        }
        return ff;
    }

    private void applyNonRelevantValuesToFilterFacet(FilterFacet filterFacet, FacetToSQL facetToSQL, ConnectionPool.PooledConnection connection) throws Exception {
        String nonRelevantValuesQuery = facetToSQL.buildNonRelevantValuesQuery();
        if (nonRelevantValuesQuery != null) {
            try (ConnectionPool.ManagedStatement stmt = connection.getStatement();
                 FutureAborter.AutoCloseableAbortHook ignored = FutureAborter.pushAutoCloseableHook(stmt::cancel);){
                SqlExecutionHelper.execute(connection, stmt, nonRelevantValuesQuery, true);
                try (ResultSet rs2 = stmt.get().getResultSet();){
                    FacetBuilder builder = new FacetBuilder(this.atIndex, this.rf);
                    FilterFacet nonRelevantValuesFilterFacet = builder.fromResultSet(rs2, this.basicStats != null ? this.basicStats.columnStats.get(this.rf.column) : null);
                    if (this.rf.columnType == AxisDef.Type.ALPHANUM || this.rf.columnType == AxisDef.Type.DATE && this.rf.dateFilterType != ChartFilter.DateFilterType.RELATIVE && this.rf.dateFilterType != ChartFilter.DateFilterType.RANGE) {
                        this.applyNonRelevantValuesToAlphanumericalFilterFacet(filterFacet, nonRelevantValuesFilterFacet);
                    } else if (this.rf.columnType == AxisDef.Type.NUMERICAL || this.rf.columnType == AxisDef.Type.DATE) {
                        this.applyNonRelevantValuesToNumericalFilterFacet(filterFacet, nonRelevantValuesFilterFacet);
                    }
                }
            }
        }
    }

    private void applyNonRelevantValuesToAlphanumericalFilterFacet(FilterFacet ff, FilterFacet nonRelevantValuesFilterFacet) {
        int i;
        HashSet<String> ffValueIds = new HashSet<String>();
        for (i = 0; i < ff.values.size(); ++i) {
            ffValueIds.add(ff.values.get((int)i).id);
        }
        for (i = 0; i < nonRelevantValuesFilterFacet.values.size(); ++i) {
            FilterFacet.Val val = nonRelevantValuesFilterFacet.values.get(i);
            if (ffValueIds.contains(val.id)) continue;
            val.count = 0L;
            ff.values.add(val);
        }
    }

    private void applyNonRelevantValuesToNumericalFilterFacet(FilterFacet ff, FilterFacet nonRelevantValuesFilterFacet) {
        ff.minValue = Math.min(nonRelevantValuesFilterFacet.minValue, ff.minValue);
        ff.maxValue = Math.max(nonRelevantValuesFilterFacet.maxValue, ff.maxValue);
    }
}

