/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projectstandards;

import com.dataiku.dip.projectstandards.ProjectStandardsCheck;
import com.dataiku.dip.projectstandards.ProjectStandardsCheckSpecMeta;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProjectStandardsConfigurableCheckRegistry {
    private static final Map<String, ProjectStandardsCheckSpecMeta> availableCheckSpecs = Maps.newLinkedHashMap();

    public static synchronized List<ProjectStandardsCheckSpecMeta> getAllMeta() {
        return new ArrayList<ProjectStandardsCheckSpecMeta>(availableCheckSpecs.values());
    }

    public static ProjectStandardsCheckSpecMeta getMeta(ProjectStandardsCheck check) {
        return ProjectStandardsConfigurableCheckRegistry.getMeta(check.checkElementType);
    }

    public static synchronized ProjectStandardsCheckSpecMeta getMeta(String type) {
        ProjectStandardsCheckSpecMeta meta = availableCheckSpecs.get(type);
        if (meta == null) {
            throw ErrorContext.iaef((String)"Project standards check spec does not exist: '%s'.", (Object)type, (Object[])new Object[0]);
        }
        return meta;
    }

    public static synchronized void register(ProjectStandardsCheckSpecMeta meta) {
        availableCheckSpecs.put(meta.getElementType(), meta);
    }

    public static synchronized void deregister(String type) {
        availableCheckSpecs.remove(type);
    }
}

