/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.common.doc_extraction;

import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.ExtractedData;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.ProcessedDocumentResources;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class ExtractedDataWriter {
    public List<ProcessedDocumentResources> processedDocumentResourcesAccumulator = new ArrayList<ProcessedDocumentResources>();
    public static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.nlp.doc_extraction_writer");

    protected abstract void writeAppend(InputRefs.ManagedFolderDocumentRefWithMetadata var1, ExtractedData var2) throws Exception;

    public synchronized void writeAppendAndAccumulate(InputRefs.ManagedFolderDocumentRefWithMetadata document, ExtractedData extractedData) throws Exception {
        if (!extractedData.chunks.isEmpty()) {
            this.writeAppend(document, extractedData);
            document.userMetadata = null;
            document.securityToken = null;
            this.processedDocumentResourcesAccumulator.add(new ProcessedDocumentResources(document, extractedData.assetsStoragePath, extractedData.chunks.stream().map(chunk -> chunk.uuid).toList()));
        }
    }

    public abstract void handleOutdatedChunksUuids(Set<String> var1) throws Exception;

    public String buildMessageLogForDocument(InputRefs.ManagedFolderDocumentRef documentRef, String message) {
        return String.format("[%s] - %s", documentRef.filePath, message);
    }
}

