/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.common.doc_extraction;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.docextraction.Extractor;
import java.util.List;
import javax.annotation.Nullable;

public abstract class UiExtractorSettings {
    public SplitUnit splitUnit = SplitUnit.SECTION;

    public abstract Extractor.Settings toExtractorSettings(String var1, @Nullable List<AbstractSQLConnection.CustomDatabaseProperty> var2);

    public static enum SplitUnit {
        PAGE,
        CUSTOM,
        DOCUMENT,
        SECTION;

    }

    public static class VLM
    extends UiExtractorSettings {
        public int customNbPages = 1;
        public int customPagesOverlap = 0;
        public String llmId;
        public boolean useCustomPrompt = false;
        public String customPrompt = Extractor.getSummaryExtractionPrompt(null);

        public VLM() {
        }

        public VLM(String llmId, String defaultVLMExtractionPrompt) {
            this.splitUnit = SplitUnit.PAGE;
            this.llmId = llmId;
            this.customPrompt = defaultVLMExtractionPrompt;
        }

        @Override
        public Extractor.Settings.VLM toExtractorSettings(String vlmExtractionPrompt, @Nullable List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties) {
            Extractor.Settings.VLM settings = new Extractor.Settings.VLM();
            settings.llmId = this.llmId;
            if (this.splitUnit.equals((Object)SplitUnit.CUSTOM)) {
                settings.windowSize = this.customNbPages;
                settings.windowOverlap = Math.min(this.customPagesOverlap, this.customNbPages - 1);
            } else if (this.splitUnit.equals((Object)SplitUnit.PAGE)) {
                settings.windowSize = 1;
                settings.windowOverlap = 0;
            } else if (this.splitUnit.equals((Object)SplitUnit.DOCUMENT)) {
                settings.windowSize = 1;
                settings.windowOverlap = 0;
                settings.aggregateResults = true;
            }
            settings.llmPrompt = this.useCustomPrompt ? this.customPrompt : vlmExtractionPrompt;
            return settings;
        }
    }

    public static class Raw
    extends UiExtractorSettings {
        public boolean useOCR = false;
        public Extractor.OCRSettings.OCREngine ocrEngine = Extractor.OCRSettings.OCREngine.AUTO;
        public String ocrLanguages = "en";

        @Override
        public Extractor.Settings.TextFirst toExtractorSettings(String defaultVLMAnnotationPrompt, List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties) {
            Extractor.Settings.TextFirst settings = new Extractor.Settings.TextFirst();
            settings.imageHandlingMode = Extractor.ImageHandlingMode.IGNORE;
            if (this.useOCR) {
                settings.imageHandlingMode = Extractor.ImageHandlingMode.OCR;
                settings.ocrSettings = new Extractor.OCRSettings();
                settings.ocrSettings.ocrEngine = this.ocrEngine;
                settings.ocrSettings.ocrLanguages = this.ocrLanguages;
            }
            settings.dkuProperties = dkuProperties;
            return settings;
        }
    }

    public static class Structured
    extends UiExtractorSettings {
        public Integer maxSectionDepth = 6;
        public Extractor.ImageHandlingMode imageHandlingMode = Extractor.ImageHandlingMode.IGNORE;
        public Extractor.OCRSettings.OCREngine ocrEngine = Extractor.OCRSettings.OCREngine.AUTO;
        public String ocrLanguages = "en";
        public String llmId = "";
        public boolean useCustomVLMPrompt = false;
        public String customVLMPrompt = Extractor.getVlmDefaultAnnotationPromptFromTokensLimit(null);
        public boolean enableImageClassificationFiltering = true;

        @Override
        public Extractor.Settings.Structured toExtractorSettings(String defaultVLMAnnotationPrompt, List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties) {
            Extractor.Settings.Structured settings = new Extractor.Settings.Structured();
            settings.imageHandlingMode = this.imageHandlingMode;
            settings.imageValidation = this.enableImageClassificationFiltering;
            if (this.imageHandlingMode == Extractor.ImageHandlingMode.OCR) {
                settings.ocrSettings = new Extractor.OCRSettings();
                settings.ocrSettings.ocrEngine = this.ocrEngine;
                settings.ocrSettings.ocrLanguages = this.ocrLanguages;
            } else if (this.imageHandlingMode == Extractor.ImageHandlingMode.VLM_ANNOTATE) {
                settings.vlmAnnotationSettings = new Extractor.VLMAnnotationSettings();
                settings.vlmAnnotationSettings.llmId = this.llmId;
                settings.vlmAnnotationSettings.llmPrompt = this.useCustomVLMPrompt ? this.customVLMPrompt : defaultVLMAnnotationPrompt;
            }
            settings.maxSectionDepth = this.splitUnit.equals((Object)SplitUnit.DOCUMENT) ? 0 : this.maxSectionDepth;
            settings.dkuProperties = dkuProperties;
            return settings;
        }
    }
}

