/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.evaluation;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMRefEnricherService;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.common.GenericRecipeCreator;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.nlp.evaluation.AbstractGenAIEvaluationRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.evaluation.GenAIEvaluationRecipeParams;
import com.dataiku.dip.recipes.nlp.rag_embedding.RAGEmbeddingRecipeCreator;
import com.dataiku.dip.recipes.services.PDepsFixuper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.WithMessages;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractGenAIEvaluationRecipeCreator<TRecipeSchemaComputer extends RecipeSchemaComputer>
extends GenericRecipeCreator {
    @Autowired
    private LLMRefEnricherService llmRefEnricherService;

    public AbstractGenAIEvaluationRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    public RecipeCreator.CreationResult create_NT(SerializedRecipe recipe, JsonObject creationData) throws Exception {
        TRecipeSchemaComputer schemaComputer;
        Dataset inputDataset;
        Dataset metricsDataset;
        Dataset outputDataset;
        TransactionContext.assertNoAttachedTransaction();
        RecipeCreator.CreationResult creationResult = new RecipeCreator.CreationResult();
        Preconditions.checkNotNull((Object)recipe.projectKey, (Object)"There is no project key in the recipe.");
        Preconditions.checkArgument((boolean)this.meta.getType().equals(recipe.type), (Object)String.format("The recipe needs to be of type %s", this.meta.getType()));
        Preconditions.checkArgument((!recipe.getOutputsUnsafe().isEmpty() ? 1 : 0) != 0, (Object)"The recipe needs at least one output.");
        String inputDatasetSmartName = recipe.getInputsForRole((String)"main").get((int)0).ref;
        DatasetLocUtils.DatasetLoc inputDatasetLoc = DatasetLocUtils.resolveSmart(recipe.projectKey, inputDatasetSmartName);
        List<SerializedRecipe.RecipeOutput> outputMain = recipe.getOutputsForRole("main");
        String outputDatasetSmartName = outputMain.isEmpty() ? null : outputMain.get((int)0).ref;
        DatasetLocUtils.DatasetLoc outputDatasetLoc = StringUtils.isBlank(outputDatasetSmartName) ? null : DatasetLocUtils.resolveSmart(recipe.projectKey, outputDatasetSmartName);
        List<SerializedRecipe.RecipeOutput> outputMetrics = recipe.getOutputsForRole("metrics");
        if (!outputMetrics.isEmpty()) {
            outputMetrics.get((int)0).appendMode = true;
        }
        String metricsDatasetSmartName = outputMetrics.isEmpty() ? null : outputMetrics.get((int)0).ref;
        DatasetLocUtils.DatasetLoc metricsDatasetLoc = StringUtils.isBlank(metricsDatasetSmartName) ? null : DatasetLocUtils.resolveSmart(recipe.projectKey, metricsDatasetSmartName);
        try (Transaction t = this.transactionService.beginRead();){
            outputDataset = outputDatasetLoc == null ? null : this.datasetAccessService.getMandatory(outputDatasetLoc);
            metricsDataset = metricsDatasetLoc == null ? null : this.datasetAccessService.getMandatory(metricsDatasetLoc);
            inputDataset = this.datasetAccessService.getMandatory(inputDatasetLoc);
        }
        AbstractGenAIEvaluationRecipePayloadParams desc = this.getDefaultRecipeRunnerPayloadParams();
        GeneralSettingsDAO.GenerativeAISettings generativeAISettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings;
        if (StringUtils.isNotBlank((String)generativeAISettings.defaultEvalTextEmbeddingModelId)) {
            try {
                desc.embeddingLLMId = generativeAISettings.defaultEvalTextEmbeddingModelId;
                EnrichedLLMStructuredRef ref = this.llmRefEnricherService.getEnrichedLLMRef(generativeAISettings.defaultEvalTextEmbeddingModelId, this.authCtx, recipe.projectKey);
                desc.embeddingSettings.chunkSizeCharacters = RAGEmbeddingRecipeCreator.adaptDefaultChunkSizeCharacters(ref.maxTokensLimit);
                desc.embeddingSettings.chunkOverlapCharacters = RAGEmbeddingRecipeCreator.adaptDefaultOverlapCharacters(desc.embeddingSettings.chunkSizeCharacters);
            }
            catch (Exception e) {
                this.getLogger().warnV((Throwable)e, "An error happened during the setting of default Embedding Model", new Object[0]);
            }
        }
        if (StringUtils.isNotBlank((String)generativeAISettings.defaultEvalTextEmbeddingModelId)) {
            desc.completionLLMId = generativeAISettings.defaultEvalLLMCompletionModelId;
        }
        try (Transaction t = this.transactionService.beginRead();){
            JobActivity activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(new FlowRecipe(recipe)));
            schemaComputer = this.getSchemaComputer(this.authCtx, activity);
            ((RecipeSchemaComputer.RecipeSchemaComputerWithPayload)schemaComputer).setPayload(JSON.json((Object)desc));
        }
        if (outputDataset != null) {
            Schema outputSchema = ((RecipeSchemaComputer)schemaComputer).getSchemasForOutputRole_NT("main").get(0);
            outputDataset.setSchema(outputSchema);
        }
        if (metricsDataset != null) {
            Schema metricsSchema = ((RecipeSchemaComputer)schemaComputer).getSchemasForOutputRole_NT("metrics").get(0);
            metricsDataset.setSchema(metricsSchema);
        }
        GenAIEvaluationRecipeParams params = new GenAIEvaluationRecipeParams();
        String defaultEnvName = generativeAISettings.defaultLLMEvalCodeEnv;
        if (StringUtils.isNotBlank((String)defaultEnvName)) {
            params.setCodeEnvSelection(CodeEnvSelection.explicitEnv(defaultEnvName));
        }
        recipe.params = params;
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            GenAiEvaluationRecipeCreationSettings settings = (GenAiEvaluationRecipeCreationSettings)JSON.parse((JsonElement)creationData, GenAiEvaluationRecipeCreationSettings.class);
            recipe.name = this.recipeSaveService.transmogrifyName(recipe.projectKey, recipe.name);
            if (outputDataset != null) {
                WithMessages<SerializedDataset> datasetWithMessages = this.datasetSaveService.save(outputDataset.getDatasetLoc(), outputDataset.serialize(), this.authCtx);
                creationResult.messages.mergeFrom(datasetWithMessages.getMessages());
            }
            if (metricsDataset != null) {
                WithMessages<SerializedDataset> metricsDatasetWithMessages = this.datasetSaveService.save(metricsDataset.getDatasetLoc(), metricsDataset.serialize(), this.authCtx);
                creationResult.messages.mergeFrom(metricsDatasetWithMessages.getMessages());
            }
            if (StringUtils.isBlank((String)settings.zone)) {
                settings.zone = this.flowZonesService.retrieveInputZone(recipe);
            }
            new PDepsFixuper().fixupInPlace(recipe);
            this.recipeSaveService.create(recipe.projectKey, recipe, JSON.pretty((Object)desc));
            this.flowZonesService.attachObjectToZone(settings.zone, recipe.projectKey, recipe);
            rwt.commit(this.getRecipePersistenceCommitMessage(recipe.name, inputDataset.getName()));
        }
        return creationResult.withId(recipe.name);
    }

    protected abstract TRecipeSchemaComputer getSchemaComputer(AuthCtx var1, JobActivity var2);

    protected abstract AbstractGenAIEvaluationRecipePayloadParams getDefaultRecipeRunnerPayloadParams();

    protected abstract String getRecipePersistenceCommitMessage(String var1, String var2);

    protected abstract DKULogger getLogger();

    private static class GenAiEvaluationRecipeCreationSettings {
        public String zone;

        private GenAiEvaluationRecipeCreationSettings() {
        }
    }
}

