/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.extract_content;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.FinalCommitable;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.docextraction.ScreenshotterService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.recipes.InitializableAbortableRecipeRunner;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionIndexer;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionRecipeRunner;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.DocExtractionRecordManager;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.IndexerComputationResult;
import com.dataiku.dip.recipes.nlp.extract_content.ExtractContentRecipeParams;
import com.dataiku.dip.recipes.nlp.extract_content.ExtractContentRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.extract_content.ExtractContentRuleApplier;
import com.dataiku.dip.recipes.nlp.extract_content.ExtractedDataDatasetWriter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;

public class ExtractContentRecipeRunner
implements DocExtractionRecipeRunner,
InitializableAbortableRecipeRunner,
RecipeRunner,
FlowRunnable,
RecipeRunnerWithPayload,
FinalCommitable {
    @Autowired
    protected ManagedFolderDAO managedFolderDAO;
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected ScreenshotterService screenshotterService;
    @Autowired
    protected JobAuthCtxService authCtxService;
    @Autowired
    protected ConnectionsDAO connectionsDAO;
    @Autowired
    protected APITicketService ticketService;
    protected ExtractContentRecipePayloadParams desc;
    protected final ExtractContentRecipeParams recipeParams;
    private JobActivity activity;
    private final RecipeRunnableSubgraph subgraph;
    private FlowRecipe recipe;
    protected AuthCtx authCtx;

    @Override
    public void init() throws Exception {
        this.authCtx = this.authCtxService.getAuthCtx();
    }

    @Override
    public void setPayload(String payload) {
        this.desc = (ExtractContentRecipePayloadParams)JSON.parse((String)payload, ExtractContentRecipePayloadParams.class);
    }

    public ExtractContentRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = this.subgraph.getRecipe();
        this.recipeParams = this.recipe.getModel().getParamsAs(ExtractContentRecipeParams.class);
    }

    protected final boolean hasRecipeOutput(String role) {
        List<SerializedRecipe.RecipeOutput> outputs = this.recipe.getModel().getOutputsForRole(role);
        return !outputs.isEmpty();
    }

    @Override
    public void run() throws Exception {
        logger.info((Object)"Extract content recipe runner started");
        SerializedRecipe.RecipeOutput datasetRO = (SerializedRecipe.RecipeOutput)this.recipe.getModel().getOutputsForRole("main").stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Output dataset not found"));
        Dataset outputDataset = Dataset.fromSerialized((SerializedDataset)this.datasetsDAO.getMandatory(datasetRO.getLoc(this.recipe.getProjectKey())));
        if (outputDataset.getPartitioningSchema().isPartitioned()) {
            String errorMessage = String.format("Dataset %s is partitioned. This is not supported for the extract content recipe", outputDataset.getFullName());
            logger.error((Object)errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        SerializedRecipe.RecipeInput ri = (SerializedRecipe.RecipeInput)this.recipe.getModel().getInputsForRole("main").stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Folder input not found"));
        ManagedFolder inputFolder = (ManagedFolder)this.managedFolderDAO.getMandatory(ri.getLoc(this.recipe.getProjectKey()));
        FlowComputable folderAsFlowComputable = this.recipe.getSourcesWithRoles().stream().filter((Predicate<FlowComputable.FlowComputableWithRole>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$run$2(com.dataiku.dip.dataflow.graph.FlowComputable$FlowComputableWithRole ), (Lcom/dataiku/dip/dataflow/graph/FlowComputable$FlowComputableWithRole;)Z)()).findFirst().orElseThrow((Supplier<IllegalArgumentException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$run$3(), ()Ljava/lang/IllegalArgumentException;)()).computable;
        if (folderAsFlowComputable.getType() != FlowComputable.FCType.MANAGED_FOLDER) {
            throw new IllegalStateException("Extract content recipe expects a folder as input");
        }
        Optional outputFolder = this.recipe.getModel().getOutputsForRole("images").stream().findFirst();
        ManagedFolder outfolder = null;
        if (outputFolder.isPresent()) {
            SerializedRecipe.RecipeOutput ro2 = (SerializedRecipe.RecipeOutput)outputFolder.get();
            outfolder = (ManagedFolder)this.managedFolderDAO.getMandatory(ro2.getLoc(this.recipe.getProjectKey()));
        }
        ExtractContentRuleApplier ruleApplier = new ExtractContentRuleApplier(this.recipeParams, outfolder, this.authCtx, this.recipe.getProjectKey(), this.ticketService, this.activity, this.screenshotterService, this.desc.storeScreenshots, this.desc.storeImages);
        File datasetResourcesFolder = DKUApp.getFile((String[])new String[]{"dataset_resources", outputDataset.getProjectKey(), outputDataset.getName()});
        MLPaths.createIfNeededFolderAndRestrictPermissions(datasetResourcesFolder);
        DocExtractionRecordManager recordManager = new DocExtractionRecordManager(datasetResourcesFolder, this.recipe.getProjectKey());
        DocExtractionIndexer indexer = new DocExtractionIndexer(this.desc.vectorStoreUpdateMethod, recordManager);
        try (AutoDelete outputTmpDir = FlowJobUtils.getTmpFolder("extract-content-recipe", "run");){
            ExtractedDataDatasetWriter extractedDataWriter = new ExtractedDataDatasetWriter(datasetRO, outputDataset, outputTmpDir, this.authCtx, this.subgraph, this.activity, this.recipe.getProjectKey());
            IndexerComputationResult indexerResult = indexer.startIndexing();
            DocExtractionRecipeRunner.indexAndProcessDocumentsInFolder(this.recipe.getProjectKey(), inputFolder, folderAsFlowComputable, ruleApplier, indexerResult, indexer, extractedDataWriter, this.authCtx, this.activity);
            if (indexerResult.getNbKnownDocuments() > 0) {
                extractedDataWriter.handleOutdatedChunksUuids(indexer.getChunksIdsToDelete(indexerResult));
            }
            extractedDataWriter.close();
            String runID = JobContext.getCurrentJobContext().jobId;
            indexer.updateRecordManagerAndCleanOutdatedStoredAssets(indexerResult, extractedDataWriter.processedDocumentResourcesAccumulator, outfolder, this.authCtx, runID);
        }
    }

    @Override
    public void notifyBeforeAborting() {
    }

    @Override
    public void finalCommit() throws Exception {
    }

    private static /* synthetic */ IllegalArgumentException lambda$run$3() {
        return new IllegalArgumentException("Folder input not found from recipe sources");
    }

    private static /* synthetic */ boolean lambda$run$2(FlowComputable.FlowComputableWithRole source) {
        return source.role.equals("main");
    }
}

