/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.ksql;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.streaming.ContinuousActivity;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.streaming.ksql.KsqlExplainer;
import com.dataiku.dip.recipes.streaming.ksql.KsqlRESTClient;
import com.dataiku.dip.recipes.streaming.ksql.KsqlRecipePreprocessor;
import com.dataiku.dip.recipes.streaming.ksql.KsqlSynchronizer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class KsqlRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private TransactionService transactionService;
    private String code;
    private static Logger logger = Logger.getLogger((String)"dip.ksql.schema");

    public KsqlRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.code = payload;
    }

    @Override
    public boolean computesDiffItself() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RecipeSchemaService.RecipeSchemaAutoupdateResult getAutoupdateResult_NT() throws Exception {
        ContinuousActivity activity = new ContinuousActivity();
        activity.projectKey = this.recipe.projectKey;
        activity.recipeId = this.recipe.name;
        KsqlRecipePreprocessor preprocessor = new KsqlRecipePreprocessor(this.authCtx, activity, this.recipe);
        try (Transaction t = this.transactionService.beginRead();){
            this.authCtx.failIfNoSafeCode("validate a Ksql recipe");
            preprocessor.prepare_T(this.recipe, this.code);
        }
        KsqlRecipePreprocessor.KsqlScriptAnalysis script = preprocessor.analyse();
        logger.info((Object)("script=" + JSON.prettyLog((Object)script)));
        List<StreamingEndpoint> inputs = preprocessor.getInputs();
        List<StreamingEndpoint> outputs = preprocessor.getOutputs();
        if (outputs.size() == 0) {
            throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_I_O, "KSQL recipe without streaming endpoint output");
        }
        if (outputs.size() > 1 && script.countByType.getOrDefault((Object)KsqlRecipePreprocessor.KsqlScriptStatementType.SELECT, 0) > 0) {
            throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_KSQL_AMBIGUOUS_STATEMENT, "The script contains a SELECT statement but there are multiple outputs. Use INSERT INTO instead.");
        }
        if (outputs.size() == 1) {
            for (KsqlRecipePreprocessor.KsqlScriptStatement ksqlScriptStatement : script.statements) {
                if (ksqlScriptStatement.type != KsqlRecipePreprocessor.KsqlScriptStatementType.SELECT) continue;
                ksqlScriptStatement.streamName = outputs.get((int)0).id;
            }
        }
        HashMap outputsById = Maps.newHashMap();
        for (StreamingEndpoint output : outputs) {
            outputsById.put(output.id, output);
        }
        RecipeSchemaService.RecipeSchemaAutoupdateResult recipeSchemaAutoupdateResult = new RecipeSchemaService.RecipeSchemaAutoupdateResult();
        try (KsqlRESTClient client = new KsqlRESTClient(preprocessor.getEffectiveKsqlConnectionParams());){
            KsqlSynchronizer synchronizer = new KsqlSynchronizer(client);
            for (KsqlRecipePreprocessor.KsqlScriptStatement statement : script.statements) {
                StreamingEndpoint se = (StreamingEndpoint)outputsById.get(statement.streamName);
                if (se == null) {
                    logger.warn((Object)("Ksql recipe writes to a stream that doesn't belong to the recipe outputs: " + statement.streamName));
                    continue;
                }
                logger.info((Object)("Running explain query for " + se.id));
                try {
                    RecipeSchemaService.ComputableSchemaAutoupdateResult updateResult;
                    KsqlExplainer.ExplainPlanData explanation = new KsqlExplainer(client).explain(statement.select, statement.type == KsqlRecipePreprocessor.KsqlScriptStatementType.SELECT);
                    KsqlSynchronizer.CompatibilityAndReason compatibility = synchronizer.checkCompatibilityWithExplained(se, explanation.fields);
                    if (compatibility.compatibility == KsqlSynchronizer.Compatibility.INCOMPATIBLE_SCHEMA) {
                        RecipeSchemaService.ComputableSchemaAutoupdateResult updateResult2 = RecipeSchemaService.ComputableSchemaAutoupdateResult.forStreamingEnpdoint();
                        updateResult2.type = FlowComputable.FCType.STREAMING_ENDPOINT;
                        updateResult2.id = se.id;
                        updateResult2.previousSchemaWasEmpty = se.schema.getColumns().isEmpty();
                        updateResult2.incompatibilities = Lists.newArrayList((Object[])new String[]{compatibility.reason});
                        synchronizer.fillUpdateResult(updateResult2, se, explanation.fields);
                        recipeSchemaAutoupdateResult.computables.add(updateResult2);
                        ++recipeSchemaAutoupdateResult.totalIncompatibilities;
                    }
                    KafkaStreamingEndpointParams kafkaParams = se.getParamsAs(KafkaStreamingEndpointParams.class);
                    if (explanation.isTable && kafkaParams.ksqlParams.syncAs != KafkaStreamingEndpointParams.KsqlSyncType.TABLE) {
                        updateResult = this.makeUpdateResultForBadSyncType(se, KafkaStreamingEndpointParams.KsqlSyncType.TABLE);
                        recipeSchemaAutoupdateResult.computables.add(updateResult);
                        ++recipeSchemaAutoupdateResult.totalIncompatibilities;
                    } else if (!explanation.isTable && kafkaParams.ksqlParams.syncAs != KafkaStreamingEndpointParams.KsqlSyncType.STREAM) {
                        updateResult = this.makeUpdateResultForBadSyncType(se, KafkaStreamingEndpointParams.KsqlSyncType.STREAM);
                        recipeSchemaAutoupdateResult.computables.add(updateResult);
                        ++recipeSchemaAutoupdateResult.totalIncompatibilities;
                    }
                    if (StringUtils.isNotBlank((String)explanation.windowType) && !explanation.windowType.equalsIgnoreCase(kafkaParams.ksqlParams.getPropertyValue("WINDOW_TYPE", ""))) {
                        updateResult = this.makeUpdateResultForBadWindowType(se, explanation.windowType);
                        recipeSchemaAutoupdateResult.computables.add(updateResult);
                        ++recipeSchemaAutoupdateResult.totalIncompatibilities;
                        continue;
                    }
                    if (!StringUtils.isBlank((String)explanation.windowType) || kafkaParams.ksqlParams.getPropertyOrNull("WINDOW_TYPE") == null) continue;
                    updateResult = this.makeUpdateResultForBadWindowType(se, null);
                    recipeSchemaAutoupdateResult.computables.add(updateResult);
                    ++recipeSchemaAutoupdateResult.totalIncompatibilities;
                }
                catch (KsqlRESTClient.KsqlStatementException e) {
                    logger.info((Object)("Unable to run explain of query to " + statement.streamName));
                    throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, e.getMessage());
                    return recipeSchemaAutoupdateResult;
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"Unable to check statements schemas", (Throwable)e);
            throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_KSQL_REST_ERROR, "Failed to check statements schemas: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    private RecipeSchemaService.ComputableSchemaAutoupdateResult makeUpdateResultForBadSyncType(StreamingEndpoint se, KafkaStreamingEndpointParams.KsqlSyncType syncType) {
        RecipeSchemaService.ComputableSchemaAutoupdateResult updateResult = RecipeSchemaService.ComputableSchemaAutoupdateResult.forStreamingEnpdoint();
        updateResult.type = FlowComputable.FCType.STREAMING_ENDPOINT;
        updateResult.id = se.id;
        updateResult.previousSchemaWasEmpty = false;
        updateResult.incompatibilities = syncType == KafkaStreamingEndpointParams.KsqlSyncType.TABLE ? Lists.newArrayList((Object[])new String[]{"Statement produces a ktable, endpoint is a kstream"}) : Lists.newArrayList((Object[])new String[]{"Statement produces a kstream, endpoint is a ktable"});
        updateResult.getKsqlParams().syncAs = syncType;
        return updateResult;
    }

    private RecipeSchemaService.ComputableSchemaAutoupdateResult makeUpdateResultForBadWindowType(StreamingEndpoint se, String windowType) {
        RecipeSchemaService.ComputableSchemaAutoupdateResult updateResult = RecipeSchemaService.ComputableSchemaAutoupdateResult.forStreamingEnpdoint();
        updateResult.type = FlowComputable.FCType.STREAMING_ENDPOINT;
        updateResult.id = se.id;
        updateResult.previousSchemaWasEmpty = false;
        if (StringUtils.isNotBlank((String)windowType)) {
            updateResult.incompatibilities = Lists.newArrayList((Object[])new String[]{"Statement is windowed (" + windowType + "), but the output endpoint is not"});
            updateResult.getKsqlParams().windowType = KafkaStreamingEndpointParams.KsqlWindowType.valueOf(windowType);
        } else {
            updateResult.incompatibilities = Lists.newArrayList((Object[])new String[]{"Statement is not windowed, but the output endpoint is"});
            updateResult.getKsqlParams().windowType = KafkaStreamingEndpointParams.KsqlWindowType.NONE;
        }
        return updateResult;
    }
}

