/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.remoterun;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.code.ProjectLibPathHelper;
import com.dataiku.dip.dataflow.AbstractJobKernelSession;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;

public class ProjectLibsBundler {
    public static final String PROJECT_PYTHON_LIBS = "project-python-libs";
    public static final String PROJECT_R_SRC = "project-r-src";
    private static DKULogger logger = DKULogger.getLogger((String)"dku.remoterun.projectlibs");

    public static void prepareProjectLibsBundleForJob(String projectKey, File targetTmpDir) throws IOException {
        DSSGitModel.ExternalLibraries externalLibraries;
        ProjectLibPathHelper.ProjectLibsPaths plp = new ProjectLibPathHelper.ProjectLibsPaths();
        plp.projectKey = projectKey;
        try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead(IsolationLevel.YOLO);){
            RelFile externalLibrariesFile = new RelFile(new String[]{"projects", projectKey, "lib", "external-libraries.json"});
            externalLibraries = (DSSGitModel.ExternalLibraries)t.readObjectDefault(externalLibrariesFile, DSSGitModel.ExternalLibraries.class);
        }
        for (String foreignProjectKey : externalLibraries.getNonNullLibrariesFromProjects()) {
            ProjectLibsBundler.prepareProjectLibsBundleForProject(foreignProjectKey, targetTmpDir, plp);
        }
        ProjectLibsBundler.prepareProjectLibsBundleForProject(projectKey, targetTmpDir, plp);
        JSON.prettyToFile((Object)plp, (File)new File(targetTmpDir, "project-lib-paths.json"));
    }

    public static void prepareProjectLibsBundleForNonJob(String projectKey, AuthCtx authCtx, File targetTmpDir) throws IOException, DKUSecurityException {
        DSSGitModel.ExternalLibraries externalLibraries;
        ProjectLibPathHelper.ProjectLibsPaths plp = new ProjectLibPathHelper.ProjectLibsPaths();
        plp.projectKey = projectKey;
        try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead();){
            RelFile externalLibrariesFile = new RelFile(new String[]{"projects", projectKey, "lib", "external-libraries.json"});
            externalLibraries = (DSSGitModel.ExternalLibraries)t.readObjectDefault(externalLibrariesFile, DSSGitModel.ExternalLibraries.class);
        }
        for (String foreignProjectKey : externalLibraries.getNonNullLibrariesFromProjects()) {
            block29: {
                if (DKUApp.getProcessType() == MainLoggingConfigurator.ProcessType.CAK) {
                    APITicketService ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
                    try (APITicketService.TicketUsage tu = ticketService.getAndUseSingleTicket();
                         TicketBasedIntercomAPIClient apiClient = AbstractJobKernelSession.backendIntercomAPIClient(tu);){
                        apiClient.postFormToJSON("/dip/api/tintercom/permissions/check-project-privilege", Void.class, new Object[]{"projectKey", projectKey, "privilege", Privileges.ProjectLevelPrivilegeType.READ_CONF.toString()});
                        break block29;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead();){
                    ((IPermissionsService)SpringUtils.getBean(IPermissionsService.class)).checkProjectPrivileges(authCtx, foreignProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                }
            }
            ProjectLibsBundler.prepareProjectLibsBundleForProject(foreignProjectKey, targetTmpDir, plp);
        }
        ProjectLibsBundler.prepareProjectLibsBundleForProject(projectKey, targetTmpDir, plp);
        JSON.prettyToFile((Object)plp, (File)new File(targetTmpDir, "project-lib-paths.json"));
    }

    private static void prepareProjectLibsBundleForProject(String projectKeyToCopyFrom, File tmpDir, ProjectLibPathHelper.ProjectLibsPaths plp) throws IOException {
        try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead(IsolationLevel.YOLO);){
            RelFile dstDirInOutput;
            RelFile chunkFolder;
            RelFile libFolder = new RelFile(new String[]{"projects", projectKeyToCopyFrom, "lib"});
            RelFile externalLibrariesFile = libFolder.appendChildPath("external-libraries.json");
            DSSGitModel.ExternalLibraries externalLibraries = (DSSGitModel.ExternalLibraries)t.readObjectDefault(externalLibrariesFile, DSSGitModel.ExternalLibraries.class);
            NativeFS outputFs = NativeFS.from((File)tmpDir).skipFileTypeCheck(false).atomicWrite(true).rejectSymlinks(true).build();
            for (String pythonPathChunk : externalLibraries.pythonPath) {
                chunkFolder = libFolder.appendChildPath(pythonPathChunk);
                if (!t.isDirectory(chunkFolder)) continue;
                dstDirInOutput = new RelFile(new String[]{PROJECT_PYTHON_LIBS, projectKeyToCopyFrom}).appendChildPath(pythonPathChunk);
                logger.debugV("Copying project %s lib chunk %s to %s", new Object[]{projectKeyToCopyFrom, chunkFolder, outputFs.resolve(dstDirInOutput)});
                FSUtils.newRecursiveSync().from((ReadOnlyFS)t, chunkFolder).to((ReadWriteFS)outputFs, dstDirInOutput).run();
                plp.pythonPath.add(dstDirInOutput.getFullPath());
            }
            for (String rsrcPathChunk : externalLibraries.rsrcPath) {
                chunkFolder = libFolder.appendChildPath(rsrcPathChunk);
                if (!t.isDirectory(chunkFolder)) continue;
                dstDirInOutput = new RelFile(new String[]{PROJECT_R_SRC, projectKeyToCopyFrom}).appendChildPath(rsrcPathChunk);
                logger.debugV("Copying project %s lib chunk %s to %s", new Object[]{projectKeyToCopyFrom, chunkFolder, outputFs.resolve(dstDirInOutput)});
                FSUtils.newRecursiveSync().from((ReadOnlyFS)t, chunkFolder).to((ReadWriteFS)outputFs, dstDirInOutput).run();
                plp.rsrcPath.add(dstDirInOutput.getFullPath());
            }
        }
    }
}

