/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.futures.FutureThreadWithAbortMessage;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.reports.ScenarioReporter;
import com.dataiku.dip.scheduler.reports.ScenarioReporterRunner;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRegistry;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.File;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class ScenarioThread
extends FutureThread<ReportItem>
implements FutureThreadWithAbortMessage {
    private final Scenario scenario;
    private final ScenariosService scenariosService;
    private final ScenarioRun scenarioRun;
    private final ScenarioRunContext scenarioRunContext;
    private String abortMessage;
    private final FuturePayload futurePayload;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.scenario.run_thread");

    public static FuturePayload buildFuturePayload(Scenario scenario, ScenarioRun scenarioRun) {
        String trigger;
        FuturePayload fp = new FuturePayload();
        fp.action = "run_scenario";
        String effectiveRunAsUser = ScenarioThread.getEffectiveRunAsUser(scenarioRun);
        fp.withExtra("effectiveRunAsUser", (Object)effectiveRunAsUser);
        if (scenarioRun.trigger != null && scenarioRun.trigger.trigger != null) {
            trigger = scenarioRun.trigger.trigger.name;
            fp.withExtra("trigger", (Object)trigger);
        } else {
            trigger = "";
        }
        fp.displayName = "Scenario " + scenario.getId() + " running in " + scenario.getProjectKey() + " (run as user: " + effectiveRunAsUser + " - trigger: " + trigger + ")";
        fp.targets.add(DSSFuturePayloadUtils.forTaggableObject(scenario));
        return fp;
    }

    private static String getEffectiveRunAsUser(ScenarioRun scenarioRun) {
        return scenarioRun.getRunAsUser().getAssociatedDSSUserOrIdentifier();
    }

    public ScenarioThread(Scenario scenario, ScenarioRun scenarioRun, ScenariosService scenariosService, ScenarioRunContext scenarioRunContext) {
        super(scenarioRun.getRunAsUser());
        this.scenario = scenario;
        this.scenarioRun = scenarioRun;
        this.scenariosService = scenariosService;
        this.scenarioRunContext = scenarioRunContext;
        this.futurePayload = ScenarioThread.buildFuturePayload(scenario, scenarioRun);
    }

    public String getPayloadForStartDoneMessage() {
        return "scenario:" + this.scenario.getFullId();
    }

    public ScenarioRun getScenarioRun() {
        return this.scenarioRun;
    }

    public void abort(String message) {
        this.interrupt();
        super.abort();
        this.abortMessage = message;
    }

    public static void checkInterrupted() throws InterruptedException {
        FutureProgressState.checkInterrupt();
        Thread thread = Thread.currentThread();
        if (thread instanceof ScenarioThread) {
            ScenarioThread scenarioThread = (ScenarioThread)((Object)thread);
            if (scenarioThread.aborted) {
                throw new InterruptedException("Scenario aborted by the user");
            }
        }
    }

    public FuturePayload getPayload() {
        return this.futurePayload;
    }

    public double getDangerosity() {
        return 0.0;
    }

    public ReportItem getResult() {
        return this.scenarioRun.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws Exception {
        this.scenarioRunContext.setScenarioRun(this.scenarioRun);
        this.scenarioRunContext.startLogAppender();
        a = ErrorContext.pushWithNDC((String)("scenario " + this.scenarioRun.getScenario().getProjectKey() + "." + this.scenarioRun.getScenario().getId() + "#" + this.scenarioRun.getRunId()));
        try {
            try {
                JSON.prettyToFile((Object)this.scenarioRun, (File)ScenarioRunContext.getScenarioRunFile(this.scenarioRun));
                reporterRunners = Lists.newArrayList();
                for (ScenarioReporter var4_9 : this.scenario.getReporters()) {
                    if (var4_9.isActive()) {
                        reporterRunners.add(ScenarioReporterRunner.build(var4_9, this.scenarioRun, this.scenario));
                        continue;
                    }
                    ScenarioThread.logger.info((Object)("Reporter " + var4_9.getName() + " is not active."));
                }
                for (ScenarioReporterRunner var4_11 : reporterRunners) {
                    failure = null;
                    start = System.currentTimeMillis();
                    outcome = null;
                    try {
                        outcome = var4_11.sendOnStart();
                        if (var4_11.getReporter().phase != ScenarioReporter.Phase.START) continue;
                        rs = new ScenarioRun.ReporterState();
                        rs.reporterName = var4_11.getReporter().getName();
                        rs.messagingType = var4_11.getReporter().getMessaging().type;
                        v0 = outcome != null;
                        ** GOTO lbl54
                    }
                    catch (Throwable e) {
                        try {
                            ScenarioThread.logger.warn((Object)"Failure during report on start", e);
                            failure = e;
                            if (var4_11.getReporter().phase != ScenarioReporter.Phase.START) continue;
                            rs = new ScenarioRun.ReporterState();
                            rs.reporterName = var4_11.getReporter().getName();
                            rs.messagingType = var4_11.getReporter().getMessaging().type;
                            if (outcome != null) {
                                v1 = true;
                            }
                            v1 = false;
                        }
                        catch (Throwable var10_25) {
                            if (var4_11.getReporter().phase != ScenarioReporter.Phase.START) throw var10_25;
                            rs = new ScenarioRun.ReporterState();
                            rs.reporterName = var4_11.getReporter().getName();
                            rs.messagingType = var4_11.getReporter().getMessaging().type;
                            rs.activated = outcome != null;
                            rs.messages = outcome;
                            rs.started = start;
                            rs.ended = System.currentTimeMillis();
                            if (failure != null) {
                                rs.error = new SerializedError(failure, true);
                            }
                            this.scenarioRun.reportersStates.add(rs);
                            throw var10_25;
                        }
lbl54:
                        // 1 sources

                        rs.activated = v0;
                        rs.messages = outcome;
                        rs.started = start;
                        rs.ended = System.currentTimeMillis();
                        if (failure != null) {
                            rs.error = new SerializedError(failure, true);
                        }
                        this.scenarioRun.reportersStates.add(rs);
                        continue;
                        rs.activated = v1;
                        rs.messages = outcome;
                        rs.started = start;
                        rs.ended = System.currentTimeMillis();
                        if (failure != null) {
                            rs.error = new SerializedError(failure, true);
                        }
                        this.scenarioRun.reportersStates.add(rs);
                    }
                }
                try {
                    scenarioRunner = ScenarioRegistry.buildRunner(this.scenario);
                    try {
                        scenarioRunner.run(this.scenarioRun);
                    }
                    finally {
                        try {
                            this.scenariosService.cleanupScenarioRun(this.scenarioRun);
                        }
                        catch (Exception var4_12) {
                            ScenarioThread.logger.error((Object)"Failed to perform cleanup in scenario", (Throwable)var4_12);
                        }
                    }
                }
                catch (Throwable e) {
                    ScenarioThread.logger.error((Object)"Failed to run the scenario", e);
                    if (this.scenarioRun.getResult() == null) {
                        var4_14 = new ReportTargetItem.ScenarioItem(this.scenario.getProjectKey(), this.scenario.getId());
                        this.scenarioRun.withResult(new ReportItem.ScenarioDone(var4_14).withThrown(e).withOutcome(ReportItem.Outcome.FAILED));
                    }
                }
                finally {
                    if (this.scenarioRun.getResult() != null && this.scenarioRun.getResult() instanceof ReportItem.ScenarioDone && StringUtils.isNotBlank((String)this.abortMessage)) {
                        ((ReportItem.ScenarioDone)this.scenarioRun.getResult()).withAbortMessage(this.abortMessage);
                    }
                    try {
                        this.scenariosService.endScenarioRun(this.scenarioRun);
                    }
                    catch (SQLException e) {
                        ScenarioThread.logger.error((Object)"Failed to register the scenario termination", (Throwable)e);
                    }
                }
                for (ScenarioReporterRunner var4_18 : reporterRunners) {
                    failure = null;
                    start = System.currentTimeMillis();
                    outcome = null;
                    try {
                        outcome = var4_18.sendOnEnd();
                        if (var4_18.getReporter().phase != ScenarioReporter.Phase.END) continue;
                        rs = new ScenarioRun.ReporterState();
                        rs.reporterName = var4_18.getReporter().getName();
                        rs.messagingType = var4_18.getReporter().getMessaging().type;
                        v2 = outcome != null;
                        ** GOTO lbl141
                    }
                    catch (Throwable e) {
                        try {
                            ScenarioThread.logger.warn((Object)"Failure during report on end of scenario", e);
                            failure = e;
                            if (var4_18.getReporter().phase != ScenarioReporter.Phase.END) continue;
                            rs = new ScenarioRun.ReporterState();
                            rs.reporterName = var4_18.getReporter().getName();
                            rs.messagingType = var4_18.getReporter().getMessaging().type;
                            if (outcome != null) {
                                v3 = true;
                            }
                            v3 = false;
                        }
                        catch (Throwable var16_31) {
                            if (var4_18.getReporter().phase != ScenarioReporter.Phase.END) throw var16_31;
                            rs = new ScenarioRun.ReporterState();
                            rs.reporterName = var4_18.getReporter().getName();
                            rs.messagingType = var4_18.getReporter().getMessaging().type;
                            rs.activated = outcome != null;
                            rs.messages = outcome;
                            rs.started = start;
                            rs.ended = System.currentTimeMillis();
                            if (failure != null) {
                                rs.error = new SerializedError(failure, true);
                            }
                            this.scenarioRun.reportersStates.add(rs);
                            throw var16_31;
                        }
lbl141:
                        // 1 sources

                        rs.activated = v2;
                        rs.messages = outcome;
                        rs.started = start;
                        rs.ended = System.currentTimeMillis();
                        if (failure != null) {
                            rs.error = new SerializedError(failure, true);
                        }
                        this.scenarioRun.reportersStates.add(rs);
                        continue;
                        rs.activated = v3;
                        rs.messages = outcome;
                        rs.started = start;
                        rs.ended = System.currentTimeMillis();
                        if (failure != null) {
                            rs.error = new SerializedError(failure, true);
                        }
                        this.scenarioRun.reportersStates.add(rs);
                    }
                }
            }
            finally {
                this.scenarioRunContext.clearScenarioRun();
                JSON.prettyToFile((Object)this.scenarioRun, (File)ScenarioRunContext.getScenarioRunFile(this.scenarioRun));
            }
            this.scenariosService.runScenarioRunPostTriggerActions(this.scenarioRun, this.jobId);
            return;
        }
        finally {
            if (a != null) {
                a.close();
            }
        }
    }

    public void postRunCleanup() {
        this.scenariosService.runScenarioRunPostActions(this.scenarioRun);
    }
}

