/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.runnables;

import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.scheduler.runnables.CustomPythonRunnablesService;
import com.dataiku.dip.scheduler.runnables.DSSRunnable;
import com.dataiku.dip.scheduler.runnables.DSSRunnableDesc;
import com.dataiku.dip.scheduler.runnables.DSSRunnableMeta;
import com.dataiku.dip.scheduler.runnables.LoadedPythonRunnable;
import com.dataiku.dip.scheduler.runnables.LoadedRunnable;
import com.dataiku.dip.scheduler.runnables.PythonDSSRunnable;
import com.dataiku.dip.scheduler.runnables.PythonRunnableDesc;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PythonRunnableMeta
implements DSSRunnableMeta {
    private final LoadedPythonRunnable loaded;

    public PythonRunnableMeta(LoadedPythonRunnable loaded, CustomPythonRunnablesService pythonRunnablesService) {
        this.loaded = loaded;
    }

    @Override
    public String getType() {
        return this.loaded.getType();
    }

    @Override
    public String getLabel() {
        if (((PythonRunnableDesc)this.loaded.desc).meta != null && StringUtils.isNotBlank((String)((PythonRunnableDesc)this.loaded.desc).meta.label)) {
            return ((PythonRunnableDesc)this.loaded.desc).meta.label;
        }
        return this.loaded.runnableType;
    }

    @Override
    public DSSRunnable buildRunnable(AuthCtx authCtx, String projectKey, JsonObject params) {
        PythonDSSRunnable runnable = new PythonDSSRunnable(authCtx, projectKey, this.loaded, params);
        SpringUtils.getInstance().autowire((Object)runnable);
        return runnable;
    }

    @Override
    public boolean runOutOfCore() {
        return false;
    }

    @Override
    public List<ParamDesc> getParams() {
        ArrayList allParams = Lists.newArrayList();
        allParams.addAll(((PythonRunnableDesc)this.loaded.desc).adminParams);
        allParams.addAll(((PythonRunnableDesc)this.loaded.desc).params);
        return allParams;
    }

    @Override
    public LoadedRunnable<? extends DSSRunnableDesc> getLoadedDesc() {
        return this.loaded;
    }
}

