/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.datasets.consistency.ConsistencyCheckRunner;
import com.dataiku.dip.datasets.consistency.DatasetConsistencyChecker;
import com.dataiku.dip.recipes.consistency.RecipeConsistencyCheckRequest;
import com.dataiku.dip.recipes.consistency.RecipeConsistencyCheckRunner;
import com.dataiku.dip.scheduler.ScenarioThread;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class CheckConsistencyStepRunner
implements StepRunner {
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    private final Scenario scenario;
    private final CheckConsistencyStepParams params;
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return CheckConsistencyStepParams.class;
        }

        @Override
        public String getType() {
            return "check_consistency";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new CheckConsistencyStepRunner(scenario, step, step.getParamsAs(CheckConsistencyStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            return "Consistency check";
        }

        @Override
        public String buildId(Step step) {
            return "check_consistency";
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private Map<String, NodeState> stateByNode = new HashMap<String, NodeState>();
    private AuthCtx authCtx;
    private StepRun stepRun;
    private int warningCount;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.checkconsistency");

    CheckConsistencyStepRunner(Scenario scenario, Step step, CheckConsistencyStepParams params) {
        SpringUtils.getInstance().autowire((Object)this);
        this.scenario = scenario;
        this.params = params;
    }

    private void incrementalMarkComputable(FlowComputable computable, boolean recheckAll, Set<String> checkedNodeIds) throws Exception {
        boolean needsRecheck;
        String nodeId = GraphIds.forComputable(computable);
        String nodeIdWithSuccessors = nodeId + String.valueOf(computable.getSuccessors());
        if (checkedNodeIds.contains(nodeIdWithSuccessors)) {
            return;
        }
        checkedNodeIds.add(nodeIdWithSuccessors);
        NodeState nodeState = this.stateByNode.get(nodeId);
        assert (nodeState != null);
        boolean bl = needsRecheck = nodeState.state == State.UNCHECKED || nodeState.state == State.FAILED_CHECK || recheckAll;
        if (nodeState.state == State.CHECKED && nodeState.datasetCheckResult != null && nodeState.datasetCheckResult.anyMessage) {
            needsRecheck = true;
        }
        if (needsRecheck) {
            logger.infoV(" Checking computable %s", new Object[]{computable.getFullId()});
            this.checkComputable(computable);
        }
        for (GraphNode graphNode : computable.getSuccessors()) {
            if (!(graphNode instanceof FlowRecipe)) continue;
            ScenarioThread.checkInterrupted();
            this.incrementalMarkRecipe((FlowRecipe)graphNode, recheckAll, checkedNodeIds);
        }
    }

    private void incrementalMarkRecipe(FlowRecipe recipe, boolean recheckAll, Set<String> checkedNodeIds) throws Exception {
        boolean needsRecheck;
        String recipeNodeId = GraphIds.forRecipe(recipe);
        if (checkedNodeIds.contains(recipeNodeId)) {
            return;
        }
        checkedNodeIds.add(recipeNodeId);
        NodeState recipeState = this.stateByNode.get(recipeNodeId);
        assert (recipeState != null);
        boolean bl = needsRecheck = recipeState.state == State.UNCHECKED || recipeState.state == State.FAILED_CHECK || recheckAll;
        if (recipeState.state == State.CHECKED && recipeState.recipeCheckResult != null && recipeState.recipeCheckResult.anyFatal()) {
            needsRecheck = true;
        }
        if (needsRecheck) {
            logger.infoV(" Checking recipe %s", new Object[]{recipe.getFullId()});
            this.checkRecipe(recipe);
        }
        for (FlowComputable recipeOutput : recipe.getTargets()) {
            ScenarioThread.checkInterrupted();
            this.incrementalMarkComputable(recipeOutput, recheckAll, checkedNodeIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRecipe(FlowRecipe recipe) throws InterruptedException {
        String nodeId = GraphIds.forRecipe(recipe);
        NodeState nodeState = this.stateByNode.get(nodeId);
        String projectKey = recipe.getProjectKey();
        RecipeConsistencyCheckRequest recipesOptions = new RecipeConsistencyCheckRequest(false, true, true);
        ReportTargetItem.RecipeItem reportTargetItem = new ReportTargetItem.RecipeItem(projectKey, recipe.getName());
        ReportItem.CheckedFlowElementConsistency reportItem = (ReportItem.CheckedFlowElementConsistency)new ReportItem.CheckedFlowElementConsistency(reportTargetItem).withStart(DateTime.now().getMillis());
        RecipeConsistencyCheckRunner runner = new RecipeConsistencyCheckRunner();
        try {
            nodeState.recipeCheckResult = runner.checkWithFlow_NT(this.authCtx, recipe, recipesOptions);
            this.handleCheckResult(nodeState, reportItem, nodeState.recipeCheckResult, nodeId);
        }
        catch (InterruptedException iex) {
            throw iex;
        }
        catch (Throwable ex) {
            logger.warn((Object)("Check failed for recipe: " + recipe.getFullId()), ex);
            nodeState.state = State.FAILED_CHECK;
            ++this.warningCount;
            reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.WARNING).withThrown(ex);
        }
        finally {
            AnyLoc loc = AnyLoc.resolveFull(recipe.getFullId());
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(loc, null, null, this.stepRun.getScenarioRun(), this.stepRun, reportItem);
        }
    }

    private ReportTargetItem getReportTargetItem(FlowComputable computable, String projectKey, AnyLoc loc) throws Exception {
        switch (computable.getType()) {
            case DATASET: {
                return new ReportTargetItem.DatasetItem(projectKey, loc.getId());
            }
            case MANAGED_FOLDER: {
                return new ReportTargetItem.ManagedFolderItem(projectKey, loc.getId());
            }
            case SAVED_MODEL: {
                return new ReportTargetItem.SavedModelItem(projectKey, loc.getId());
            }
            case MODEL_EVALUATION_STORE: {
                return new ReportTargetItem.ModelEvaluationStoreItem(projectKey, loc.getId());
            }
            case RETRIEVABLE_KNOWLEDGE: {
                return new ReportTargetItem.RetrievableKnowledgeItem(projectKey, loc.getId());
            }
            case STREAMING_ENDPOINT: {
                return new ReportTargetItem.StreamingEndpointItem(projectKey, loc.getId());
            }
        }
        throw new Exception("Unknown type " + String.valueOf((Object)computable.getType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkComputable(FlowComputable computable) throws Exception {
        String nodeId = GraphIds.forComputable(computable);
        NodeState nodeState = this.stateByNode.get(nodeId);
        DatasetConsistencyChecker.DatasetConsistencyCheckRequest datasetsRequest = new DatasetConsistencyChecker.DatasetConsistencyCheckRequest(false, true);
        AnyLoc loc = AnyLoc.resolveFull(computable.getFullId());
        String projectKey = this.scenario.getProjectKey();
        ReportTargetItem reportTargetItem = this.getReportTargetItem(computable, projectKey, loc);
        ReportItem.CheckedFlowElementConsistency reportItem = (ReportItem.CheckedFlowElementConsistency)new ReportItem.CheckedFlowElementConsistency(reportTargetItem).withStart(DateTime.now().getMillis());
        try {
            switch (computable.getType()) {
                case DATASET: {
                    FlowDataset fds = (FlowDataset)computable;
                    nodeState.datasetCheckResult = ConsistencyCheckRunner.checkWithFlow_NT(this.authCtx, fds, datasetsRequest);
                    this.handleCheckResult(nodeState, reportItem, nodeState.datasetCheckResult, nodeId);
                    return;
                }
                case MANAGED_FOLDER: 
                case SAVED_MODEL: 
                case MODEL_EVALUATION_STORE: 
                case RETRIEVABLE_KNOWLEDGE: {
                    nodeState.state = State.CHECKED;
                    reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
                    logger.infoV("Check of %s successfully completed", new Object[]{nodeId});
                    return;
                }
                case STREAMING_ENDPOINT: {
                    throw new IllegalStateException("Streaming endpoints are not built");
                }
            }
            return;
        }
        catch (InterruptedException iex) {
            throw iex;
        }
        catch (Throwable ex) {
            logger.warn((Object)("Check failed for computable: " + computable.getFullId()), ex);
            nodeState.state = State.FAILED_CHECK;
            ++this.warningCount;
            reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.WARNING).withThrown(ex);
            return;
        }
        finally {
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(loc, null, null, this.stepRun.getScenarioRun(), this.stepRun, reportItem);
        }
    }

    private void handleCheckResult(NodeState nodeState, ReportItem.CheckedFlowElementConsistency reportItem, InfoMessage.InfoMessages infoMessages, String nodeId) {
        if (infoMessages.anyFatal()) {
            nodeState.state = State.FAILED_CHECK;
            ++this.warningCount;
            reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.WARNING).withThrown(infoMessages.firstFatal().asCodedException());
            logger.warnV("Check of %s completed with failures: %s", new Object[]{nodeId, infoMessages.report()});
        } else {
            nodeState.state = State.CHECKED;
            reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.SUCCESS);
            if (infoMessages.warning) {
                logger.warnV("Check of %s completed with warning: %s", new Object[]{nodeId, infoMessages.report()});
            } else {
                logger.infoV("Check of %s successfully completed", new Object[]{nodeId});
            }
        }
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        ProjectFlowGraph graph;
        String scenarioProjectKey = this.scenario.getProjectKey();
        this.authCtx = stepRun.scenarioRun.getRunAsUser();
        this.stepRun = stepRun;
        try (Transaction t = this.transactionService.beginRead();){
            graph = this.graphService.getProjectGraphWithOrphans(scenarioProjectKey);
        }
        for (FlowComputable computable : graph.listComputables()) {
            this.stateByNode.put(GraphIds.forComputable(computable), new NodeState(State.UNCHECKED, computable));
        }
        for (FlowRecipe recipe : graph.listRecipes()) {
            this.stateByNode.put(GraphIds.forRecipe(recipe), new NodeState(State.UNCHECKED, recipe));
        }
        this.warningCount = 0;
        HashSet<String> checkedNodeIds = new HashSet<String>();
        for (FlowComputable sourceComputable : graph.listSourceComputables()) {
            ScenarioThread.checkInterrupted();
            if (checkedNodeIds.contains(sourceComputable.getFullId())) continue;
            logger.infoV("Starting check on computable %s", new Object[]{sourceComputable.getFullId()});
            this.incrementalMarkComputable(sourceComputable, false, checkedNodeIds);
        }
        for (FlowRecipe sourceRecipe : graph.listSourceRecipes()) {
            ScenarioThread.checkInterrupted();
            if (checkedNodeIds.contains(sourceRecipe.getFullId())) continue;
            this.incrementalMarkRecipe(sourceRecipe, false, checkedNodeIds);
        }
        if (this.warningCount > 0) {
            stepReportItem.withOutcome(this.params.handleWarningsAs);
        } else {
            stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
        }
    }

    public static class CheckConsistencyStepParams
    extends NonFatalStepParams
    implements StepParams {
        public ReportItem.Outcome handleWarningsAs = ReportItem.Outcome.WARNING;
    }

    private static class NodeState {
        private State state;
        private GenericRecipesValidationService.RecipeValidationResult recipeCheckResult;
        private DatasetConsistencyChecker.DatasetConsistencyCheckResult datasetCheckResult;

        private NodeState(State state, FlowRecipe recipe) {
            this.state = state;
        }

        private NodeState(State state, FlowComputable computable) {
            this.state = state;
        }
    }

    public static enum State {
        UNCHECKED,
        CHECKED,
        FAILED_CHECK;

    }
}

