/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthorizationMatrix;
import com.dataiku.dip.security.SecurityAuditService;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.ProjectsPermissionsChangedEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.collect.ListMultimap;
import com.dataiku.dss.shadelib.com.google.common.collect.Multimap;
import com.dataiku.dss.shadelib.com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class PermissionsWatcher {
    @Autowired
    private SecurityAuditService securityAuditService;
    @Autowired
    private PubSubService pubSub;
    private Map<String, Map<String, SerializedProject.PermissionItem>> usersPermissionsOnStart;
    private Map<String, Map<String, SerializedProject.PermissionItem>> usersPermissionsOnEnd;
    private Map<String, Map<String, SerializedProject.PermissionItem>> pendingUserEmailPermissionsOnStart;
    private Map<String, Map<String, SerializedProject.PermissionItem>> pendingUserEmailPermissionsOnEnd;
    private boolean started;
    static DKULogger logger = DKULogger.getLogger((String)"dip.security.permissionswatcher");

    protected abstract List<SerializedProject> getProjectsUnsafe() throws IOException;

    protected abstract List<UsersDAO.User> getUsersUnsafe() throws IOException;

    public void start() throws IOException {
        assert (!this.started);
        this.usersPermissionsOnStart = this.computeUserAuthorizationIndex();
        this.pendingUserEmailPermissionsOnStart = this.computePendingUserEmailAuthorizationIndex();
        this.started = true;
    }

    public void stop() throws IOException {
        logger.info((Object)"Compute permissions at the end of the transaction");
        if (!this.started) {
            throw new IllegalStateException("Watcher was not started");
        }
        this.usersPermissionsOnEnd = this.computeUserAuthorizationIndex();
        this.pendingUserEmailPermissionsOnEnd = this.computePendingUserEmailAuthorizationIndex();
        ProjectsPermissionChanges diff = this.computePermissionsDiff();
        if (diff.isEmpty()) {
            logger.info((Object)"No permissions changed.");
        } else {
            this.pubSub.publishAfterTransaction((DSSEvent)new ProjectsPermissionsChangedEvent(diff, PermissionsWatcher.getTriggeringUser()));
        }
    }

    private Map<String, Map<String, SerializedProject.PermissionItem>> computeUserAuthorizationIndex() throws IOException {
        HashMap<String, Map<String, SerializedProject.PermissionItem>> ret = new HashMap<String, Map<String, SerializedProject.PermissionItem>>();
        AuthorizationMatrix.PerUser perUser = this.securityAuditService.getPerUserGrants(this.getProjectsUnsafe(), this.getUsersUnsafe());
        for (int u = 0; u < perUser.users.size(); ++u) {
            String user = perUser.users.get((int)u).login;
            HashMap<String, SerializedProject.PermissionItem> userPermissions = new HashMap<String, SerializedProject.PermissionItem>();
            for (AuthorizationMatrix.ProjectGrants grants : perUser.projectsGrants) {
                String projectKey = grants.projectKey;
                AuthorizationMatrix.ProjectGrant grant = grants.grants.get(u);
                if (grant == null) continue;
                userPermissions.put(projectKey, grant.item);
            }
            ret.put(user, userPermissions);
        }
        if (logger.isTraceEnabled()) {
            logger.traceV("Computed user index: %s", new Object[]{JSON.log(ret)});
        }
        return ret;
    }

    private Map<String, Map<String, SerializedProject.PermissionItem>> computePendingUserEmailAuthorizationIndex() throws IOException {
        HashMap<String, Map<String, SerializedProject.PermissionItem>> ret = new HashMap<String, Map<String, SerializedProject.PermissionItem>>();
        List<SerializedProject> projects = this.getProjectsUnsafe();
        AuthorizationMatrix.PerPendingUserEmail perPendingUserEmail = this.securityAuditService.getPerPendingUserEmailGrants(projects);
        for (int i = 0; i < perPendingUserEmail.pendingUserEmails.size(); ++i) {
            String pendingUserEmail = perPendingUserEmail.pendingUserEmails.get(i);
            HashMap<String, SerializedProject.PermissionItem> pendingUserEmailPermissions = new HashMap<String, SerializedProject.PermissionItem>();
            for (AuthorizationMatrix.ProjectGrants grants : perPendingUserEmail.projectsGrants) {
                String projectKey = grants.projectKey;
                AuthorizationMatrix.ProjectGrant grant = grants.grants.get(i);
                if (grant == null) continue;
                pendingUserEmailPermissions.put(projectKey, grant.item);
            }
            ret.put(pendingUserEmail, pendingUserEmailPermissions);
        }
        if (logger.isTraceEnabled()) {
            logger.traceV("Computed pending user email index: %s", new Object[]{JSON.log(ret)});
        }
        return ret;
    }

    private ProjectsPermissionChanges computePermissionsDiff() {
        ProjectsPermissionChanges diff = new ProjectsPermissionChanges();
        String triggeredByUser = PermissionsWatcher.getTriggeringUser();
        Sets.SetView watchedUsers = Sets.intersection(this.usersPermissionsOnStart.keySet(), this.usersPermissionsOnEnd.keySet());
        if (watchedUsers.size() != this.usersPermissionsOnStart.size() || watchedUsers.size() != this.usersPermissionsOnEnd.size()) {
            logger.warn((Object)"Users added to or removed from the watch scope during the permission update will be ignored");
            logger.warn((Object)("Watched users before update: " + JSON.log(this.usersPermissionsOnStart.keySet())));
            logger.warn((Object)("Watched users after update: " + JSON.log(this.usersPermissionsOnEnd.keySet())));
        } else {
            logger.debug((Object)("Watched users: " + JSON.log(this.usersPermissionsOnStart.keySet())));
        }
        for (String user : watchedUsers) {
            Map<String, SerializedProject.PermissionItem> permissionsBefore = this.usersPermissionsOnStart.get(user);
            Map<String, SerializedProject.PermissionItem> permissionsAfter = this.usersPermissionsOnEnd.get(user);
            Sets.SetView affectedProjects = Sets.union(permissionsBefore.keySet(), permissionsAfter.keySet());
            for (String projectKey : affectedProjects) {
                SerializedProject.PermissionItem projectBefore = permissionsBefore.get(projectKey);
                SerializedProject.PermissionItem projectAfter = permissionsAfter.get(projectKey);
                logger.trace(() -> "u= " + user + " p=" + projectKey + " b=" + String.valueOf(projectBefore) + " a= " + String.valueOf(projectAfter));
                if (projectBefore == null && projectAfter == null || Objects.equals(projectBefore, projectAfter)) continue;
                diff.changes.add(new ProjectPermissionChange(user, projectKey, projectBefore, projectAfter, triggeredByUser));
            }
        }
        Sets.SetView watchedPendingUserEmails = Sets.union(this.pendingUserEmailPermissionsOnStart.keySet(), this.pendingUserEmailPermissionsOnEnd.keySet());
        for (String pendingUserEmail : watchedPendingUserEmails) {
            Map<String, SerializedProject.PermissionItem> permissionsBefore = this.pendingUserEmailPermissionsOnStart.get(pendingUserEmail);
            Map<String, SerializedProject.PermissionItem> permissionsAfter = this.pendingUserEmailPermissionsOnEnd.get(pendingUserEmail);
            Object affectedProjects = permissionsBefore == null ? permissionsAfter.keySet() : (permissionsAfter == null ? permissionsBefore.keySet() : Sets.union(permissionsBefore.keySet(), permissionsAfter.keySet()));
            for (String projectKey : affectedProjects) {
                SerializedProject.PermissionItem projectBefore = permissionsBefore != null ? permissionsBefore.get(projectKey) : null;
                SerializedProject.PermissionItem projectAfter = permissionsAfter != null ? permissionsAfter.get(projectKey) : null;
                logger.traceV("pue=%s p=%s b=%s a=%s", new Object[]{pendingUserEmail, projectKey, projectBefore, projectAfter});
                if (projectBefore == null && projectAfter == null || Objects.equals(projectBefore, projectAfter)) continue;
                diff.pendingUserEmailChanges.add(new ProjectPermissionChange(pendingUserEmail, projectKey, projectBefore, projectAfter, triggeredByUser));
            }
        }
        return diff;
    }

    private static String getTriggeringUser() {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        AuthCtx user = t.getUser();
        if (user == null) {
            logger.info((Object)"Failed to get user login");
            return null;
        }
        return user.getAssociatedDSSUser();
    }

    public static class ProjectsPermissionChanges {
        public List<ProjectPermissionChange> changes = new ArrayList<ProjectPermissionChange>();
        public List<ProjectPermissionChange> pendingUserEmailChanges = new ArrayList<ProjectPermissionChange>();

        public Set<String> getUsers() {
            HashSet<String> ret = new HashSet<String>();
            for (ProjectPermissionChange c2 : this.changes) {
                ret.add(c2.user);
            }
            return ret;
        }

        public Set<String> getProjectKeys() {
            return Stream.concat(this.changes.stream(), this.pendingUserEmailChanges.stream()).map(c2 -> c2.projectKey).collect(Collectors.toSet());
        }

        public Multimap<String, ProjectPermissionChange> getChangesPerUser() {
            ListMultimap changesPerUser = Multimaps.newListMultimap(new HashMap(), ArrayList::new);
            for (ProjectPermissionChange c2 : this.changes) {
                changesPerUser.put((Object)c2.user, (Object)c2);
            }
            return changesPerUser;
        }

        public Multimap<String, ProjectPermissionChange> getPendingUserEmailChangesPerEmail() {
            ListMultimap changesPerEmail = Multimaps.newListMultimap(new HashMap(), ArrayList::new);
            for (ProjectPermissionChange c2 : this.pendingUserEmailChanges) {
                changesPerEmail.put((Object)c2.user, (Object)c2);
            }
            return changesPerEmail;
        }

        public Map<String, Set<String>> getProjectKeysByUser() {
            HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
            for (ProjectPermissionChange c2 : this.changes) {
                Set keys = ret.computeIfAbsent(c2.user, u -> new HashSet());
                keys.add(c2.projectKey);
            }
            return ret;
        }

        public boolean isEmpty() {
            return this.changes.isEmpty() && this.pendingUserEmailChanges.isEmpty();
        }
    }

    public static class ProjectPermissionChange {
        public String user;
        public String projectKey;
        public SerializedProject.PermissionItem before;
        public SerializedProject.PermissionItem after;
        @Nullable
        public String triggeredByUser;

        public ProjectPermissionChange(String user, String projectKey, SerializedProject.PermissionItem before, SerializedProject.PermissionItem after, @Nullable String triggeredByUser) {
            this.user = user;
            this.projectKey = projectKey;
            this.before = before;
            this.after = after;
            this.triggeredByUser = triggeredByUser;
        }
    }
}

