/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.audit.targets;

import com.dataiku.dip.connections.CredentialsRemoteFetchConfigurationProvider;
import com.dataiku.dip.processors.ConnectionPathTargetProcessor;
import com.dataiku.dip.processors.ConnectionPathTargetProcessorSettings;
import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;

public class ConnectionPathAuditTargetProcessor
extends ConnectionPathTargetProcessor<AuditObj> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auditmechanism.fsLikeTarget");

    public ConnectionPathAuditTargetProcessor(ConnectionPathTargetProcessorSettings settings) {
        super(settings, false);
    }

    @Override
    public synchronized void process(AuditObj req) throws Exception {
        if (this.invalidConfiguration) {
            return;
        }
        this.getLogger().trace((Object)("Processing: " + JSON.log((Object)req)));
        try (CredentialsRemoteFetchConfigurationProvider.FetchAsAuthCtx authCtxForRemote = CredentialsRemoteFetchConfigurationProvider.fetchAs(this.authCtx);){
            JsonObject jo = req.get();
            this.process_internal(jo, req.topic, req.routingKey);
        }
    }

    @Override
    public DKULogger getLogger() {
        return logger;
    }

    @Override
    public String getProcessorName() {
        return "fs audit target";
    }
}

