/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.impersonation;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.ProcessDiedException;
import com.dataiku.dip.security.impersonation.UIFSudoHelper;
import com.dataiku.dip.security.impersonation.UserImpersonationUtils;
import com.dataiku.dip.security.process.WrapperIsolatedProcess;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class FilesystemACLHandler {
    private final MUSACLHandlingMode mode = MUSACLHandlingMode.valueOf(ApplicationConfigurator.getIniValue((String)"mus", (String)"fs_acl_handling_mode", (String)"EXECWRAPPER"));
    private final File permissionsHelper;
    private final File execWrapper;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.security.fsacl");

    public FilesystemACLHandler() throws IOException {
        String permissionsHelperLocation = ApplicationConfigurator.getIniValue((String)"mus", (String)"permissions_helper_location");
        this.permissionsHelper = permissionsHelperLocation != null ? new File(permissionsHelperLocation) : ApplicationConfigurator.getResourceFile((String)"security/dss-permissions-helper.sh");
        String wrapperLocation = ApplicationConfigurator.getIniValue((String)"mus", (String)"exec_wrapper_location");
        this.execWrapper = wrapperLocation != null ? new File(wrapperLocation) : new File(ApplicationConfigurator.getFile((String)"security"), "execwrapper.sh");
    }

    public void ensureWorldTraversableOnly(File directory) throws IOException {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.GROUP_EXECUTE);
        perms.add(PosixFilePermission.OTHERS_EXECUTE);
        FilesystemACLHandler.chmod(directory, perms);
    }

    public void chmod644(File file) throws IOException {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        perms.add(PosixFilePermission.GROUP_READ);
        perms.add(PosixFilePermission.OTHERS_READ);
        FilesystemACLHandler.chmod(file, perms);
    }

    public void chmod700(File file) throws IOException {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        FilesystemACLHandler.chmod(file, perms);
    }

    public void ensureStudioPrivate(File directory) throws IOException {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        FilesystemACLHandler.chmod(directory, perms);
    }

    public void setExclusiveAndStudioFullAccessOnDirectory(File directory, String toUnixUser) throws DKUSecurityException {
        try {
            this.chown(directory, toUnixUser);
            String dssUser = UserImpersonationUtils.getDSSUser();
            Validate.notNull((Object)dssUser);
            WrapperIsolatedProcess.MUSExecutionHandlingMode execMode = WrapperIsolatedProcess.MUSExecutionHandlingMode.valueOf(ApplicationConfigurator.getIniValue((String)"mus", (String)"execution_handling_mode", (String)"EXECWRAPPER"));
            if (execMode == WrapperIsolatedProcess.MUSExecutionHandlingMode.DIRECT_SUDO) {
                this.setfacl(directory, true, Lists.newArrayList((Object[])new String[]{toUnixUser}), Lists.newArrayList((Object[])new String[]{"u::rwx", "g::---", "o:---", "d:u:" + dssUser + ":rwx", "u:" + dssUser + ":rwx", "d:u:" + toUnixUser + ":rwx", "u:" + toUnixUser + ":rwx", "d:m:rwx"}));
            } else {
                this.setfacl(directory, true, new ArrayList<String>(), Lists.newArrayList((Object[])new String[]{"u::rwx", "g::---", "o:---", "d:u:" + dssUser + ":rwx", "u:" + dssUser + ":rwx"}));
            }
        }
        catch (ProcessDiedException e) {
            throw new DKUSecurityException("Failed to protect folder " + String.valueOf(directory) + " to " + toUnixUser, (Throwable)e);
        }
        catch (IOException e) {
            throw new DKUSecurityException("While setting up folder " + String.valueOf(directory) + " to " + toUnixUser + ", " + e.getMessage(), e.getCause());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DKUSecurityException("Failed to protect folder " + String.valueOf(directory) + " to " + toUnixUser, (Throwable)e);
        }
    }

    public void grantAdditionalFullAccess(File directory, String toUnixUser) throws IOException, InterruptedException {
        this.grantAdditionalFullAccess(directory, toUnixUser, true);
    }

    public void grantAdditionalFullAccess(File directory, String toUnixUser, boolean recursive) throws IOException, InterruptedException {
        String dssUser = UserImpersonationUtils.getDSSUser();
        Validate.notNull((Object)dssUser);
        this.setfacl(directory, recursive, Lists.newArrayList((Object[])new String[]{toUnixUser}), Lists.newArrayList((Object[])new String[]{"d:u:" + toUnixUser + ":rwx", "d:u:" + dssUser + ":rwx", "u:" + toUnixUser + ":rwx", "u:" + dssUser + ":rwx"}));
    }

    public void setMaskRWX(File directory) throws IOException, InterruptedException {
        this.setfacl(directory, true, new ArrayList<String>(), Lists.newArrayList((Object[])new String[]{"m::rwx"}));
    }

    public void grantAdditionalReadRecursiveAccess(File directory, String toUnixUser) throws IOException, InterruptedException {
        String dssUser = UserImpersonationUtils.getDSSUser();
        Validate.notNull((Object)dssUser);
        this.setfacl(directory, true, Lists.newArrayList((Object[])new String[]{toUnixUser}), Lists.newArrayList((Object[])new String[]{"u:" + toUnixUser + ":r-x", "u:" + dssUser + ":rwx"}));
    }

    private void chown(File directory, String toUnixUser) throws IOException, InterruptedException {
        if (DKUtils.isOsWindows()) {
            return;
        }
        assert (toUnixUser != null);
        List<String> args = UIFSudoHelper.getSudoCommand();
        switch (this.mode) {
            case EXECWRAPPER: {
                args.addAll(Lists.newArrayList((Object[])new String[]{this.execWrapper.getAbsolutePath(), "acls", "chown", "--path", directory.getAbsolutePath(), "--owner", toUnixUser}));
                break;
            }
            case PERMISSIONS_HELPER: {
                args.addAll(Lists.newArrayList((Object[])new String[]{this.permissionsHelper.getAbsolutePath(), ApplicationConfigurator.getBaseFolder(), "chown", directory.getAbsolutePath(), toUnixUser}));
            }
        }
        UIFSudoHelper.execWithSudoErrorSniffer(args, "chown");
    }

    private void setfacl(File directory, boolean recursive, List<String> affectedUsers, List<String> perms) throws IOException, InterruptedException {
        if (DKUtils.isOsWindows()) {
            return;
        }
        List<String> args = UIFSudoHelper.getSudoCommand();
        switch (this.mode) {
            case EXECWRAPPER: {
                args.addAll(Lists.newArrayList((Object[])new String[]{this.execWrapper.getAbsolutePath(), "acls", "setfacl", "--path", directory.getAbsolutePath()}));
                for (String p : perms) {
                    args.add("--perm");
                    args.add(p);
                }
                for (String p : affectedUsers) {
                    args.add("--affected-user");
                    args.add(p);
                }
                if (!recursive) break;
                args.add("--recursive");
                break;
            }
            case PERMISSIONS_HELPER: {
                assert (recursive);
                args.addAll(Lists.newArrayList((Object[])new String[]{this.permissionsHelper.getAbsolutePath(), ApplicationConfigurator.getBaseFolder(), "setfacl", directory.getAbsolutePath(), StringUtils.join(perms, (String)",")}));
            }
        }
        UIFSudoHelper.execWithSudoErrorSniffer(args, "setfacl");
    }

    private static void chmod(File directory, Set<PosixFilePermission> perms) throws IOException {
        if (DKUtils.isOsWindows()) {
            return;
        }
        logger.info((Object)("chmod " + String.valueOf(directory) + ": " + JSON.log(perms)));
        Files.setPosixFilePermissions(Paths.get(directory.getCanonicalPath(), new String[0]), perms);
    }

    public static enum MUSACLHandlingMode {
        EXECWRAPPER,
        PERMISSIONS_HELPER;

    }
}

