/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.businessapps.BusinessAppStoreService;
import com.dataiku.dip.businessapps.BusinessAppsDAO;
import com.dataiku.dip.businessapps.BusinessAppsService;
import com.dataiku.dip.businessapps.model.BusinessApp;
import com.dataiku.dip.businessapps.model.BusinessAppDescriptor;
import com.dataiku.dip.businessapps.model.BusinessAppInstanceSettings;
import com.dataiku.dip.businessapps.model.BusinessAppSettings;
import com.dataiku.dip.businessapps.model.CreateOrUpgradeInstanceParams;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.security.trust.TrustedCodeService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendsManager;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class BusinessAppsController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private BusinessAppStoreService businessAppStoreService;
    @Autowired
    private BusinessAppsService businessAppsService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private WebAppBackendsManager webAppBackendsManager;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private TrustedCodeService trustedCodeService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.businessapps.controller");

    @AuditedCall(value={"msgType", "business-app-get", "businessAppId", "${businessAppId}"})
    @RequestMapping(value={"/api/business-apps/get"})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam String businessAppId) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        BusinessAppsController.writeJSON((HttpServletResponse)resp, (Object)this.businessAppStoreService.getMandatory(businessAppId));
    }

    @AuditedCall(value={"msgType", "business-app-get-summary", "businessAppId", "${businessAppId}"})
    @RequestMapping(value={"/api/business-apps/get-summary"})
    public void getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String businessAppId) throws Exception {
        InstalledBusinessAppUISummary summary;
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            BusinessApp app = this.businessAppsService.getMandatory(businessAppId, BusinessAppsDAO.ReadOption.READ_DESCRIPTOR, BusinessAppsDAO.ReadOption.READ_SETTINGS);
            this.permissionsService.checkBusinessAppPrivileges(authCtx, app, BusinessAppsService.BusinessAppPrivilegeType.USE);
            summary = new InstalledBusinessAppUISummary();
            summary.appId = app.desc.id;
            summary.appVersion = app.desc.version;
            summary.label = app.desc.name;
            summary.description = app.desc.description;
            summary.canCreateInstance = this.permissionsService.hasBusinessAppPrivilege(authCtx, app.settings, BusinessAppsService.BusinessAppPrivilegeType.CREATE);
            summary.defaultRunAsUser = app.settings.defaultRunAsUser;
            summary.allowRunAsUserOverride = app.settings.allowRunAsUserOverride;
            summary.objectImgHash = app.getLastUpdateDate();
            summary.instances = this.listInstances(authCtx, app.desc.id);
            summary.instanceCount = summary.instances.size();
            summary.instanceOwners = summary.instances.stream().map(instance -> {
                try {
                    return this.usersService.getPublicUser(instance.ownerLogin);
                }
                catch (IOException e) {
                    logger.warn((Object)("Unable to get user " + instance.ownerLogin));
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet()).stream().toList();
        }
        BusinessAppsController.writeJSON((HttpServletResponse)resp, (Object)summary);
    }

    @AuditedCall(value={"msgType", "business-apps-store-list-usable"})
    @RequestMapping(value={"/api/business-apps/list-usable"})
    public void listUsable(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        BusinessAppsController.writeJSON((HttpServletResponse)resp, this.businessAppStoreService.getUsableList(authCtx));
    }

    @AuditedCall(value={"msgType", "business-apps-store-list"})
    @RequestMapping(value={"/api/business-apps/list"})
    public void listStore(HttpServletRequest req, HttpServletResponse resp, boolean forceFetch) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        if (forceFetch) {
            this.businessAppStoreService.forceFetch(authCtx);
        }
        BusinessAppsController.writeJSON((HttpServletResponse)resp, (Object)this.businessAppStoreService.getStateList());
    }

    @AuditedCall(value={"msgType", "admin-business-app-install-from-store", "businessAppId", "${businessAppId}"})
    @RequestMapping(value={"/api/business-apps/install-from-store"})
    public void install(HttpServletRequest req, HttpServletResponse resp, String businessAppId) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getUser(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        BusinessAppsController.writeJSON((HttpServletResponse)resp, this.businessAppStoreService.downloadAndInstall(businessAppId, authCtx));
    }

    @AuditedCall(value={"msgType", "admin-business-app-upload"})
    @RequestMapping(value={"/api/business-apps/upload"}, method={RequestMethod.POST})
    public void uploadBusinessApp(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        AuthCtx authCtx;
        logger.info((Object)("Uploading new Business Application from file " + filePart.getOriginalFilename()));
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        AutoDelete tmpDir = DSSTempUtils.getTempFolder((String)"business-app-uploads");
        FileUtils.copyInputStreamToFile((InputStream)filePart.getInputStream(), (File)BusinessAppStoreService.getBusinessAppArchive((File)tmpDir));
        logger.info((Object)"Business Application received, installing it");
        BusinessAppsController.writeJSON((HttpServletResponse)resp, this.businessAppStoreService.startUploadAndInstall(tmpDir, authCtx));
    }

    @AuditedCall(value={"msgType", "admin-business-app-save-settings", "businessAppId", "${businessAppId}"})
    @RequestMapping(value={"/api/business-apps/save-settings"}, method={RequestMethod.POST})
    public void saveSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String businessAppId, @RequestParam String data) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        this.businessAppsService.saveSettings(businessAppId, (BusinessAppSettings)JSON.parse((String)data, BusinessAppSettings.class));
    }

    @AuditedCall(value={"msgType", "admin-business-app-delete", "businessAppId", "${businessAppId}"})
    @RequestMapping(value={"/api/business-apps/delete"})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @RequestParam String businessAppId, @RequestParam(required=false, defaultValue="false") boolean force) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        BusinessAppsController.writeJSON((HttpServletResponse)resp, this.businessAppsService.delete(authCtx, businessAppId, force));
    }

    @AuditedCall(value={"msgType", "business-apps-list-instances", "businessAppId", "${businessAppId}"})
    @RequestMapping(value={"/api/business-apps/list-instances"})
    public void listInstances(HttpServletRequest req, HttpServletResponse resp, @RequestParam String businessAppId) throws Exception {
        List<BusinessAppUIInstance> businessAppInstances;
        if (StringUtils.isBlank((String)businessAppId)) {
            throw new IllegalArgumentException("Business Application ID is required");
        }
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkBusinessAppPrivileges(authCtx, businessAppId, BusinessAppsService.BusinessAppPrivilegeType.USE);
            BusinessApp app = this.businessAppsService.getMandatory(businessAppId, BusinessAppsDAO.ReadOption.READ_DESCRIPTOR);
            businessAppInstances = this.listInstances(authCtx, app.desc.id);
        }
        BusinessAppsController.writeJSON((HttpServletResponse)resp, businessAppInstances);
    }

    @AuditedCall(value={"msgType", "business-apps-get-instance", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/business-apps/get-instance"})
    public void getInstance(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        BusinessAppUIInstance appUIInstance;
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SerializedProject sp = this.projectsService.getMandatory(projectKey);
            if (StringUtils.isBlank((String)sp.businessAppId)) {
                throw new IllegalArgumentException(String.format("%s is not a Business Application instance", projectKey));
            }
            this.permissionsService.checkBusinessAppPrivileges(authCtx, sp.businessAppId, BusinessAppsService.BusinessAppPrivilegeType.USE);
            BusinessApp app = this.businessAppsService.getMandatory(sp.businessAppId, BusinessAppsDAO.ReadOption.READ_DESCRIPTOR, BusinessAppsDAO.ReadOption.READ_SETTINGS);
            appUIInstance = this.createBusinessAppInstance(authCtx, app, sp);
        }
        BusinessAppsController.writeJSON((HttpServletResponse)resp, (Object)appUIInstance);
    }

    @AuditedCall(value={"msgType", "business-apps-save-instance-settings", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/business-apps/save-instance-settings"}, method={RequestMethod.POST})
    public void saveInstanceSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data) throws Exception {
        BusinessAppsService.SaveInstanceSettingsResult result;
        AuthCtx authCtx;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            result = this.businessAppsService.saveInstanceSettings(authCtx, projectKey, (BusinessAppInstanceSettings)JSON.parse((String)data, BusinessAppInstanceSettings.class));
            if (result.modified) {
                t.commit("Saved instance settings");
            }
        }
        if (result.modified && result.webAppFingerprint != null) {
            this.trustedCodeService.trustBusinessApplicationWebApp_NT(authCtx, projectKey, result.webAppId, result.webAppFingerprint);
        }
    }

    @AuditedCall(value={"msgType", "business-apps-upgrade-instance", "businessAppId", "${businessAppId}", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/business-apps/upgrade-instance"})
    public void upgradeInstance(HttpServletRequest req, HttpServletResponse resp, @RequestParam String businessAppId, @RequestParam String projectKey) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.permissionsService.checkBusinessAppPrivileges((AuthCtx)authCtx, businessAppId, BusinessAppsService.BusinessAppPrivilegeType.CREATE);
            SerializedProject sp = this.projectsService.getMandatory(projectKey);
            if (sp.projectType != SerializedProject.ProjectType.BUSINESS_APP) {
                throw new IllegalStateException("Project '" + projectKey + "' is not a Business Application instance");
            }
            if (!businessAppId.equals(sp.businessAppId)) {
                throw new IllegalStateException("Project '" + projectKey + "' is not a Business Application instance of '" + businessAppId + "'");
            }
            BusinessAppsController.writeJSON((HttpServletResponse)resp, this.businessAppsService.upgradeInstance(authCtx, businessAppId, projectKey));
        }
    }

    @AuditedCall(value={"msgType", "business-apps-create-instance", "businessAppId", "${businessAppId}", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/business-apps/create-instance"})
    public void createInstance(HttpServletRequest req, HttpServletResponse resp, @RequestParam String businessAppId, @RequestParam String projectKey, @RequestParam String projectName, @RequestParam String shortDesc, @RequestParam(required=false) String runAsUser) throws Exception {
        CreateOrUpgradeInstanceParams createInstanceParams = new CreateOrUpgradeInstanceParams();
        createInstanceParams.businessAppId = businessAppId;
        createInstanceParams.projectKey = projectKey;
        createInstanceParams.projectName = projectName;
        createInstanceParams.shortDesc = shortDesc;
        createInstanceParams.runAsUser = runAsUser;
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkBusinessAppPrivileges(authCtx, businessAppId, BusinessAppsService.BusinessAppPrivilegeType.CREATE);
            BusinessAppsController.writeJSON((HttpServletResponse)resp, this.businessAppsService.createInstance((DSSAuthCtx)authCtx, createInstanceParams));
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/business-apps/check-instances-deletability"})
    @ResponseBody
    public InfoMessage.InfoMessages checkInstancesDeletability(HttpServletRequest req, HttpServletResponse resp, @RequestParam String businessAppId, @RequestParam List<String> projectKeys) throws Exception {
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkBusinessAppPrivileges(authCtx, businessAppId, BusinessAppsService.BusinessAppPrivilegeType.CREATE);
            for (String projectKey : projectKeys) {
                this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
                SerializedProject sp = this.projectsService.getOrNullUnsafe(projectKey);
                if (sp == null) {
                    throw new NotFoundException("Instance '" + projectKey + "' does not exist");
                }
                if (sp.projectType != SerializedProject.ProjectType.BUSINESS_APP) {
                    throw new IllegalArgumentException("Project '" + projectKey + "' is not a Business Application instance");
                }
                if (!businessAppId.equals(sp.businessAppId)) {
                    throw new IllegalArgumentException("Project '" + projectKey + "' is not a Business Application instance of '" + businessAppId + "'");
                }
                TaggableObjectsDeletionService.DeletionResult deletionResult = this.projectsService.checkProjectDeletability(projectKey, false);
                ret.mergeFrom((InfoMessage.InfoMessages)deletionResult);
            }
        }
        return ret;
    }

    @AuditedCall(value={"msgType", "business-apps-delete-instances", "businessAppId", "${businessAppId}"})
    @RequestMapping(value={"/api/business-apps/delete-instances"})
    @ResponseBody
    public InfoMessage.InfoMessages deleteInstances(HttpServletRequest req, HttpServletResponse resp, @RequestParam String businessAppId, @RequestParam List<String> projectKeys, @RequestParam boolean clearManagedDatasets, @RequestParam boolean clearOutputManagedFolders, @RequestParam boolean clearManagedKnowledgeBanks, @RequestParam boolean clearJobAndScenarioLogs) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkBusinessAppPrivileges(authCtx, businessAppId, BusinessAppsService.BusinessAppPrivilegeType.CREATE);
        }
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        for (String projectKey : projectKeys) {
            ret.mergeFrom(this.projectsService.projectDeletionAttempt(authCtx, projectKey, clearManagedDatasets, clearOutputManagedFolders, clearManagedKnowledgeBanks, clearJobAndScenarioLogs));
        }
        return ret;
    }

    private List<BusinessAppUIInstance> listInstances(AuthCtx authCtx, String businessAppId) throws IOException, CodedException {
        BusinessApp businessApp = this.businessAppsService.getMandatory(businessAppId, BusinessAppsDAO.ReadOption.READ_DESCRIPTOR, BusinessAppsDAO.ReadOption.READ_SETTINGS);
        return this.businessAppsService.listInstancesUnsafe(authCtx, businessAppId).stream().map(sp -> this.createBusinessAppInstance(authCtx, businessApp, (SerializedProject)sp)).filter(Objects::nonNull).toList();
    }

    @Nullable
    private BusinessAppUIInstance createBusinessAppInstance(AuthCtx authCtx, BusinessApp app, SerializedProject sp) {
        ProjectsService.UIProject uiProject;
        String businessAppId = app.desc.id;
        try {
            uiProject = this.projectsService.summarizeBusinessAppInstance(authCtx, sp);
        }
        catch (DKUSecurityException | IOException e) {
            logger.warnV(e, "Unable to summarize instance '%s' of Business Application '%s'", new Object[]{sp.projectKey, businessAppId});
            return null;
        }
        BusinessAppUIInstance instance = new BusinessAppUIInstance(uiProject);
        instance.businessAppInstalledVersion = app.desc.version;
        instance.allowRunAsUserOverride = app.settings.allowRunAsUserOverride;
        if (StringUtils.isNotBlank((String)sp.businessAppWebAppId)) {
            try {
                WebAppBackendInstance.BackendState state = this.webAppBackendsManager.getState(sp.projectKey, sp.businessAppWebAppId, true);
                instance.hasWebAppBackend = state != null;
                instance.isWebAppBackendRunning = state != null && state.futureId != null && state.futureInfo != null && (state.futureInfo.hasResult || state.futureInfo.alive);
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Unable to read backend state for instance '%s' of Business Application '%s'", new Object[]{sp.projectKey, businessAppId});
            }
            try {
                String runAsLogin;
                WebApp webApp = this.webAppsService.getMandatoryUnsafe_noCode(sp.projectKey, sp.businessAppWebAppId);
                instance.runAsLogin = runAsLogin = webApp != null && webApp.params != null ? webApp.params.runAs : null;
                instance.runAsDisplayName = this.getUserDisplayName(runAsLogin);
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Unable to read runAs user for instance '%s' of Business Application '%s'", new Object[]{sp.projectKey, businessAppId});
            }
        }
        return instance;
    }

    private String getUserDisplayName(String userLogin) throws IOException {
        UsersDAO.User ud;
        if (StringUtils.isNotBlank((String)userLogin) && (ud = this.usersService.getInternalUserOrNullUnsafe(userLogin)) != null && StringUtils.isNotBlank((String)ud.displayName)) {
            return ud.displayName;
        }
        return userLogin;
    }

    public static class InstalledBusinessAppUISummary {
        public String appId;
        public String appVersion;
        public String label;
        public String description;
        public List<String> tags = Lists.newArrayList();
        public String defaultRunAsUser;
        public boolean allowRunAsUserOverride;
        public long objectImgHash;
        public String imgColor;
        public int instanceCount;
        public List<PublicUser> instanceOwners;
        public boolean canCreateInstance;
        public BusinessAppDescriptor manifest;
        public List<BusinessAppUIInstance> instances;
    }

    public static class BusinessAppUIInstance {
        public final String projectKey;
        public final String name;
        public final String description;
        public final String businessAppId;
        public final String businessAppVersion;
        public String businessAppInstalledVersion;
        public final long objectImgHash;
        public final String imgColor;
        public final Integer imgPattern;
        public final Boolean showInitials;
        public final String ownerLogin;
        public final String ownerDisplayName;
        public final List<PublicUser> contributors;
        public String runAsLogin;
        public String runAsDisplayName;
        public boolean allowRunAsUserOverride;
        public final boolean isAdmin;
        public final boolean canWriteProjectContent;
        public String webAppId;
        public boolean hasWebAppBackend;
        public boolean isWebAppBackendRunning;

        public BusinessAppUIInstance(ProjectsService.UIProject ps2) {
            this.projectKey = ps2.projectKey;
            this.name = ps2.name;
            this.description = StringUtils.defaultIfBlank((String)ps2.shortDesc, (String)ps2.description);
            this.businessAppId = ps2.businessAppId;
            this.businessAppVersion = ps2.businessAppVersion;
            this.objectImgHash = ps2.objectImgHash;
            this.imgColor = ps2.imgColor;
            this.imgPattern = ps2.imgPattern;
            this.showInitials = ps2.showInitials;
            this.ownerLogin = ps2.ownerLogin;
            this.ownerDisplayName = ps2.ownerDisplayName;
            this.contributors = ps2.contributors;
            this.isAdmin = ps2.isProjectAdmin;
            this.canWriteProjectContent = ps2.canWriteProjectContent;
            this.webAppId = ps2.businessAppWebAppId;
        }
    }
}

