/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.HDFSAbleConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.hive.HiveCodes;
import com.dataiku.dip.hive.HiveMetastoreSynchronizer;
import com.dataiku.dip.hive.HiveMetastoreSynchronizerFactory;
import com.dataiku.dip.hive.massimport.HiveImportabilityChecker;
import com.dataiku.dip.hive.massimport.MetastoreTableToDatasetResyncer;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningUtils;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetMetricsStatusService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DatasetStatusController
extends DIPInternalControllerBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private DatasetMetricsStatusService metricsStatusService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private VariablesService variablesService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.datasets.controller");

    @AuditedCall(value={"msgType", "dataset-read-meta", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/list-partitions-with-name"})
    public void listPartitions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName) throws Exception {
        Dataset dataset = null;
        AuthCtx liu = null;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.projectsService.checkDatasetReadAccessRegardlessOfContext(liu, new AnyLoc(projectKey, datasetName));
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetOrConnectionTesting((AuthCtx)liu, (String)projectKey, (String)datasetName));
        ArrayList<String> list = new ArrayList<String>();
        try (DatasetHandler dh = DatasetHandlerFactory.build(liu, dataset);){
            for (Partition p : PartitioningUtils.sort(dh.listPartitions(), true)) {
                list.add(p.id());
            }
        }
        DatasetStatusController.writeJSON((HttpServletResponse)resp, list);
    }

    @AuditedCall(value={"msgType", "dataset-sync-to-hive", "datasets", "${datasets}"})
    @RequestMapping(value={"/api/datasets/synchronize-hive-metastore"})
    public void synchronizeMetastore(HttpServletRequest req, HttpServletResponse resp, String datasets) throws Exception {
        AuthCtx authCtx;
        List refs = (List)JSON.parse((String)datasets, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        HashMap<String, Dataset> datasetsMap = new HashMap<String, Dataset>(refs.size());
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                AnyLoc loc = ref.getLoc().resolved();
                Dataset dataset = this.datasetAccessService.getMandatory(loc);
                datasetsMap.put(dataset.getFullName(), dataset);
            }
        }
        InfoMessage.InfoMessages allMessages = new InfoMessage.InfoMessages();
        for (Dataset dataset : datasetsMap.values()) {
            try {
                InfoMessage.InfoMessages messages;
                try (HiveMetastoreSynchronizer hms = HiveMetastoreSynchronizerFactory.getSynchronizer(authCtx);){
                    messages = hms.synchronizeOneDataset(dataset, false, false, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.OTHER, null, true);
                }
                messages.summarize();
                allMessages.mergeFrom(messages);
            }
            catch (Exception e) {
                allMessages.withFatalV((InfoMessage.MessageCode)HiveCodes.ERR_HIVE_TABLE_NOT_SYNCHRONIZED, "Failed to synchronize Hive table of dataset %s.%s : %s", new Object[]{dataset.getProjectKey(), dataset.getName(), ExceptionUtils.getMessageWithCauses((Throwable)e)});
                logger.error((Object)("Failed to sync " + dataset.getProjectKey() + "." + dataset.getName()), (Throwable)e);
            }
        }
        allMessages.summarize();
        DatasetStatusController.writeJSON((HttpServletResponse)resp, (Object)allMessages);
    }

    @AuditedCall(value={"msgType", "dataset-sync-to-hive", "datasets", "${datasets}"})
    @RequestMapping(value={"/api/datasets/synchronize-one-hive-metastore"})
    public void synchronizeOneMetastore(HttpServletRequest req, HttpServletResponse resp, @RequestParam String ref, @RequestParam String params) throws Exception {
        InfoMessage.InfoMessages messages;
        Dataset dataset;
        AuthCtx authCtx;
        TaggableObjectsService.TaggableObjectRef datasetRef = (TaggableObjectsService.TaggableObjectRef)JSON.parse((String)ref, TaggableObjectsService.TaggableObjectRef.class);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            AnyLoc loc = datasetRef.getLoc().resolved();
            dataset = this.datasetAccessService.getMandatory(loc);
        }
        dataset.setParams((DatasetHandler.DatasetParams)JSON.parse((String)params, DatasetHandlerFactory.getMeta(dataset).paramsClass()));
        try (HiveMetastoreSynchronizer hms = HiveMetastoreSynchronizerFactory.getSynchronizer(authCtx);){
            messages = hms.synchronizeOneDataset(dataset, false, false, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.OTHER, null, true);
        }
        DatasetStatusController.writeJSON((HttpServletResponse)resp, (Object)messages);
    }

    @AuditedCall(value={"msgType", "dataset-sync-from-hive", "projectKey", "${projectKey}", "datasetName", "${name}"})
    @RequestMapping(value={"/api/datasets/update-from-hive"})
    public void updateFromHive(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name) throws Exception {
        Dataset dataset;
        AuthCtx user;
        MetastoreTableToDatasetResyncer htd = new MetastoreTableToDatasetResyncer();
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = this.authService.getMandatoryUser(req);
            dataset = this.datasetAccessService.getMandatory(projectKey, name);
        }
        HiveImportabilityChecker.HiveTableImportCandidate htic = htd.prepareResyncTable_NT(user, dataset);
        t = this.transactionService.beginWriteForUI(req);
        try {
            htd.saveResyncTable(user, dataset, htic);
            DatasetStatusController.writeJSON((HttpServletResponse)resp, (Object)htic);
            t.commit("Resynchronized dataset " + dataset.getFullName() + " from its Hive definition");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/datasets/check-hive-sync"})
    public void checkHiveSync(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name) throws Exception {
        HDFSAbleConnection hdfsConnection;
        Dataset dataset;
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            dataset = this.datasetAccessService.getMandatory(projectKey, name);
            DSSConnection connection = this.connectionsDAO.getMandatoryConnection(authCtx, dataset.getParams().getConnection());
            if (!DatasetInspector.canHDFS(dataset)) {
                throw ErrorContext.iaef((String)"Not an hadoop dataset: %s", (Object)dataset.getType(), (Object[])new Object[0]);
            }
            hdfsConnection = (HDFSAbleConnection)((Object)connection);
        }
        MetastoreTableToDatasetResyncer htd = new MetastoreTableToDatasetResyncer();
        MetastoreTableToDatasetResyncer.DatasetHiveTableUpToDateState ret = htd.checkDatasetUpToDateState(authCtx, dataset, hdfsConnection);
        ret.importability.dataset = ret.importability.newDataset;
        DatasetStatusController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "dataset-read-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/datasets/get-refreshed-summary-status"})
    public void getRefreshedSummaryStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam boolean computeRecords, @RequestParam boolean forceRecompute) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkReadDashboardPerm(user, projectKey, ITaggingService.TaggableType.DATASET, datasetName);
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            DatasetStatusController.writeJSON((HttpServletResponse)resp, this.metricsStatusService.refreshSummary_F(user, dataset, computeRecords, forceRecompute));
        }
    }

    @AuditedCall(value={"msgType", "dataset-read-status", "projectKey", "${projectKey}", "datasets", "${datasets}"})
    @RequestMapping(value={"/api/datasets/refresh-summaries"})
    public void refreshSummaries(HttpServletRequest req, HttpServletResponse resp, @RequestParam String datasets, @RequestParam boolean computeRecords, @RequestParam boolean forceRecompute) throws Exception {
        AuthCtx authCtx;
        this.checkNotBlank(datasets, "No datasets", new Object[0]);
        List refs = (List)JSON.parse((String)datasets, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        ArrayList<Dataset> dss = new ArrayList<Dataset>(refs.size());
        try (Transaction t = this.transactionService.beginRead();){
            AnyLoc loc;
            authCtx = this.authService.getMandatoryUser(req);
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                if (ref.type != ITaggingService.TaggableType.DATASET) {
                    throw new IllegalArgumentException("Expect only datasets");
                }
                loc = ref.getLoc().resolved();
                this.projectsService.checkPerm(req, loc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                try {
                    loc = ref.getLoc().resolved();
                    dss.add(this.datasetAccessService.getMandatory(loc.getProjectKey(), loc.getId()));
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to refresh dataset status", (Throwable)e);
                }
            }
        }
        FutureResponse<InfoMessage.InfoMessages> future = this.metricsStatusService.refreshMultiSummaries_F(authCtx, dss, computeRecords, forceRecompute);
        DatasetStatusController.writeJSON((HttpServletResponse)resp, future);
    }
}

