/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.admin;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.analysis.ml.hf.ModelCacheService;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class AdminModelCacheController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ModelCacheService modelCacheService;
    @Autowired
    private FutureService futureService;

    @AuditedCall(value={"msgType", "admin-clear-model-cache"})
    @RequestMapping(value={"/api/admin/model-cache"}, method={RequestMethod.DELETE})
    @ResponseBody
    public FutureResponse<Void> clearCache(HttpServletRequest req) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
        }
        return this.futureService.runFuture(new SimpleFutureThread<Void>(authCtx){

            @Override
            protected Void compute() throws Exception {
                AdminModelCacheController.this.modelCacheService.clear();
                return null;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"clear-model-cache", (String)"Clear model cache");
            }
        }, 0L, new TypeToken<FutureResponse<Void>>(){});
    }

    @AuditedCall(value={"msgType", "admin-model-cache-get-details"})
    @RequestMapping(value={"/api/admin/model-cache-details"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public FutureResponse<ModelCacheService.ModelCacheDetails> getModelCacheDetails(HttpServletRequest req) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
        }
        return this.futureService.runFuture(new SimpleFutureThread<ModelCacheService.ModelCacheDetails>(authCtx, "model-cache-details"){

            @Override
            protected ModelCacheService.ModelCacheDetails compute() throws Exception {
                return AdminModelCacheController.this.modelCacheService.getCacheDetails();
            }

            public FuturePayload getPayload() {
                return null;
            }
        }, 0L, new TypeToken<FutureResponse<ModelCacheService.ModelCacheDetails>>(){});
    }

    @AuditedCall(value={"msgType", "admin-import-model-cache"})
    @RequestMapping(value={"/api/admin/model-cache"}, produces={"application/json"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<ModelCacheService.ModelImportResult> importModel(HttpServletRequest req, @RequestParam List<MultipartFile> files) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
        }
        final ModelCacheService.ModelImportResult importResult = new ModelCacheService.ModelImportResult();
        final ArrayList<AutoDelete> modelsToImport = new ArrayList<AutoDelete>();
        for (MultipartFile modelArchive : files) {
            try {
                InputStream modelArchiveInputStream = modelArchive.getInputStream();
                try {
                    AutoDelete extractedDir = DSSTempUtils.getTempFolder((String)"model-import", (String)SecretKeyGenerator.generate((int)16));
                    modelsToImport.add(extractedDir);
                    logger.info((Object)("Extracting archive to: " + extractedDir.getAbsolutePath()));
                    DKUFileUtils.unzipInputStream((File)extractedDir, (InputStream)modelArchiveInputStream);
                }
                finally {
                    if (modelArchiveInputStream == null) continue;
                    modelArchiveInputStream.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed during model extraction", (Throwable)e);
                modelsToImport.forEach(AutoDelete::close);
                throw e;
            }
        }
        return this.futureService.runFuture(new SimpleFutureThread<ModelCacheService.ModelImportResult>(authCtx){

            @Override
            protected ModelCacheService.ModelImportResult compute() {
                for (AutoDelete modelToImport : modelsToImport) {
                    AdminModelCacheController.this.modelCacheService.importModel(authCtx, (File)modelToImport, importResult);
                    modelToImport.close();
                }
                return importResult;
            }

            public FuturePayload getPayload() {
                return null;
            }
        }, 0L, new TypeToken<FutureResponse<ModelCacheService.ModelImportResult>>(){});
    }

    @AuditedCall(value={"msgType", "admin-model-cache-delete-model"})
    @RequestMapping(value={"/api/admin/model-cache/delete-model"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public void deleteModel(HttpServletRequest req, @RequestParam String modelKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        ModelCacheService.ModelStorageDefinition modelDefinition = new ModelCacheService.ModelStorageDefinition(modelKey);
        this.modelCacheService.deleteModel(modelDefinition);
    }

    @AuditedCall(value={"msgType", "admin-model-cache-export-model"})
    @RequestMapping(value={"/api/admin/model-cache/export"}, method={RequestMethod.GET})
    public void exportModel(HttpServletRequest req, HttpServletResponse resp, @RequestParam String modelKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdminNoXSRF(req);
        }
        ModelCacheService.ModelStorageDefinition modelDefinition = new ModelCacheService.ModelStorageDefinition(modelKey);
        if (this.modelCacheService.modelIsDownloaded(modelDefinition)) {
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + modelDefinition.getFolderName() + ".zip\"");
            resp.setStatus(200);
            this.modelCacheService.zipModelToStream(modelDefinition, new BufferedOutputStream((OutputStream)resp.getOutputStream()));
        } else {
            resp.setStatus(404);
            resp.getWriter().write("Model '" + modelKey + "' not found.");
        }
    }
}

