/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.services.UsersService;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataStewardService {
    @Autowired
    private UsersService usersService;
    static Logger logger = Logger.getLogger((String)"dku.datasets.data-steward");

    @Nullable
    public static String getDataStewardLoginOrDefault(SerializedDataset sd) {
        String dataSteward = sd.getDataSteward();
        return StringUtils.isNotBlank((String)dataSteward) ? dataSteward : DataStewardService.getDefaultDataStewardLogin(sd);
    }

    @Nullable
    public PublicUser getDataStewardUser(SerializedDataset sd) throws IOException {
        String dataSteward = sd.getDataSteward();
        return StringUtils.isNotBlank((String)dataSteward) ? this.usersService.getPublicUser(dataSteward) : null;
    }

    @Nullable
    public static String getDefaultDataStewardLogin(SerializedDataset sd) {
        return sd.creationTag == null ? null : sd.creationTag.getLastAuthor();
    }

    @Nullable
    public PublicUser getDefaultDataStewardUser(SerializedDataset sd) throws IOException {
        String dsLogin = DataStewardService.getDefaultDataStewardLogin(sd);
        if (dsLogin == null) {
            return null;
        }
        return this.usersService.getPublicUser(dsLogin);
    }

    @Nullable
    public PublicUser getDefaultDataStewardUser_safe(SerializedDataset sd) {
        try {
            return this.getDefaultDataStewardUser(sd);
        }
        catch (IOException e) {
            logger.warn((Object)("Unable to dataset steward info for " + sd.getFullName()), (Throwable)e);
            return null;
        }
    }
}

