/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.custompython.CustomJavaDatasetMeta;
import com.dataiku.dip.datasets.custompython.CustomPythonDatasetMeta;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractHDFSableDatasetHandler;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.datasets.fs.FileFormatDatasetTestHandler;
import com.dataiku.dip.datasets.iceberg.IcebergDatasetHandler;
import com.dataiku.dip.datasets.iceberg.IcebergDatasetMeta;
import com.dataiku.dip.datasets.iceberg.IcebergDatasetTestHandler;
import com.dataiku.dip.exceptions.DSSInternalErrorException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.formats.delta.DeltaFormat;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.FileBucket;
import com.dataiku.dip.partitioning.FilePartition;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.FilePartitioningDetector;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class PartitionsDetectionService {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets");

    public FilePartitioningTestResult testFilePartitioning(AuthCtx authCtx, Dataset dataset, boolean doDetection) throws Exception {
        FSLikeDatasetTestHandler.FSLikeDatasetTestResult test;
        if (!DatasetHandlerFactory.getMeta(dataset).isFS()) {
            throw new DSSInternalErrorException("Can't test file partitioning on dataset " + dataset.getName() + ": not FS-like");
        }
        try (FileFormatDatasetTestHandler testHandler = DatasetHandlerFactory.buildTestHandlerAs(authCtx, dataset, FileFormatDatasetTestHandler.class);){
            String datasetFormatType = dataset.getFormatType();
            test = testHandler.detectFormats(authCtx);
            dataset.setFormatType(datasetFormatType);
        }
        if (!test.connectionOK) {
            throw new IllegalArgumentException("Can't connect: " + test.connectionError.detailedMessage);
        }
        if ("HTTP".equals(dataset.getType())) {
            return new FilePartitioningTestResult();
        }
        try (AbstractFSDatasetHandler handler = (AbstractFSDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);){
            FilePartitioningTestResult result = new FilePartitioningTestResult();
            HashSet<String> matchedFilePaths = new HashSet<String>();
            if (dataset.getPartitioningSchema() != null) {
                result.configuredSchemeContent = new HashMap<String, PartitionContent>();
                try {
                    for (FilePartition fp : FilePartitioner.listPartitions(authCtx, dataset)) {
                        PartitionContent out = new PartitionContent();
                        out.id = fp.id();
                        out.buckets = fp.buckets.size();
                        for (FileBucket fb : fp.buckets) {
                            for (FSPath path : fb.paths) {
                                ++out.nbFiles;
                                out.totalSize += path.getSize();
                                out.filePaths.add(path.path());
                                matchedFilePaths.add(path.path());
                            }
                        }
                        result.configuredSchemeContent.put(out.id, out);
                    }
                }
                catch (DataStoreIOException e) {
                    logger.warn((Object)("Could not list current partitions:" + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
            }
            if (doDetection) {
                result.didDetectScheme = true;
                try {
                    PartitioningScheme detectedScheme = null;
                    if (handler instanceof AbstractHDFSableDatasetHandler && DeltaFormat.META.getType().equals(dataset.getFormatType())) {
                        try {
                            detectedScheme = ((AbstractHDFSableDatasetHandler)handler).getDeltaPartitioning();
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Unable to get partitioning directly from Delta metadata, inspecting file paths", (Throwable)e);
                        }
                    }
                    if (detectedScheme == null) {
                        detectedScheme = FilePartitioningDetector.autodetect(authCtx, dataset);
                    }
                    if (detectedScheme != null) {
                        result.detectedScheme = detectedScheme;
                        result.detectedSchemeContent = new HashMap<String, PartitionContent>();
                        dataset.setPartitioningScheme(detectedScheme);
                        for (FilePartition fp : FilePartitioner.listPartitions(authCtx, dataset)) {
                            PartitionContent out = new PartitionContent();
                            out.id = fp.id();
                            out.buckets = fp.buckets.size();
                            for (FileBucket fb : fp.buckets) {
                                for (FSPath path : fb.paths) {
                                    ++out.nbFiles;
                                    out.totalSize += path.getSize();
                                    out.filePaths.add(path.path());
                                    matchedFilePaths.add(path.path());
                                }
                            }
                            result.detectedSchemeContent.put(out.id, out);
                        }
                    }
                }
                catch (DataStoreIOException e) {
                    logger.warn((Object)"Trying to detect partitioning on an empty dataset?", (Throwable)e);
                }
            }
            try {
                for (FSPath path : handler.enumerateFilesystem()) {
                    if (matchedFilePaths.contains(path.path())) continue;
                    result.unmatchedFilesPaths.add(path.path());
                }
            }
            catch (DataStoreIOException e) {
                logger.warn((Object)"Trying to detect partitioning on an empty dataset?", (Throwable)e);
            }
            FilePartitioningTestResult filePartitioningTestResult = result;
            return filePartitioningTestResult;
        }
    }

    public FilePartitioningTestResult testGeneralPartitioning(AuthCtx authCtx, Dataset dataset) throws Exception {
        DatasetHandler.DatasetMeta<?, ?> meta = DatasetHandlerFactory.getMeta(dataset);
        if (meta instanceof CustomPythonDatasetMeta || meta instanceof CustomJavaDatasetMeta) {
            try (DatasetHandler datasetHandler = DatasetHandlerFactory.build(authCtx, dataset);){
                SpringUtils.getInstance().autowire((Object)datasetHandler);
                FilePartitioningTestResult result = new FilePartitioningTestResult();
                result.configuredSchemeContent = Maps.newHashMap();
                for (Partition partition : datasetHandler.listPartitions()) {
                    result.configuredSchemeContent.put(partition.id(), new PartitionContent());
                }
                FilePartitioningTestResult filePartitioningTestResult = result;
                return filePartitioningTestResult;
            }
        }
        throw new IllegalArgumentException("Can't test file partitioning on dataset " + dataset.getName() + " : wrong type");
    }

    public IcebergPartitioningTestResult testIcebergPartitioning(AuthCtx authCtx, Dataset dataset, boolean doDetection) throws Exception {
        IcebergDatasetTestHandler.TestResult test;
        if (!DatasetHandlerFactory.getMeta(dataset).equals(IcebergDatasetMeta.INSTANCE)) {
            throw new DSSInternalErrorException("Can't test iceberg partitioning on dataset " + dataset.getName() + ": not iceberg");
        }
        try (IcebergDatasetTestHandler testHandler = DatasetHandlerFactory.buildTestHandlerAs(authCtx, dataset, IcebergDatasetTestHandler.class);){
            test = testHandler.test(false, false, 0);
        }
        if (!test.connectionOk) {
            throw new IllegalArgumentException("Can't connect: " + test.connectionError.detailedMessage);
        }
        try (IcebergDatasetHandler handler = (IcebergDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);){
            IcebergPartitioningTestResult result = new IcebergPartitioningTestResult();
            if (dataset.getPartitioningSchema() != null) {
                // empty if block
            }
            if (doDetection) {
                result.didDetectScheme = true;
                result.detectedScheme = handler.getIcebergPartitioning();
            }
            IcebergPartitioningTestResult icebergPartitioningTestResult = result;
            return icebergPartitioningTestResult;
        }
    }

    public static class FilePartitioningTestResult {
        public List<String> unmatchedFilesPaths = new ArrayList<String>();
        public Map<String, PartitionContent> configuredSchemeContent;
        public boolean didDetectScheme;
        public PartitioningScheme detectedScheme;
        public Map<String, PartitionContent> detectedSchemeContent;
    }

    public static class PartitionContent {
        public String id;
        public int buckets;
        public int nbFiles;
        public long totalSize;
        public List<String> filePaths = new ArrayList<String>();
    }

    public static class IcebergPartitioningTestResult {
        public boolean didDetectScheme;
        public PartitioningScheme detectedScheme;
    }
}

