/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.deployer;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractGlobalLightStatus;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractInfraBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractPublishedItemLightStatus;
import com.dataiku.dip.deployer.common.datamodel.actual.InfraLightStatus;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.deployer.projectdeployer.datamodel.actual.ConsistencyChecksReport;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeployment;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.AbstractProjectDeploymentInfra;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.MultiAutomationNodeInfra;
import com.dataiku.dip.deployer.projectdeployer.datamodel.config.SingleAutomationNodeInfra;
import com.dataiku.dip.deployer.projectdeployer.deployments.ProjectDeploymentsService;
import com.dataiku.dip.deployer.projectdeployer.infra.AutomationNodeInfrasService;
import com.dataiku.dip.deployer.projectdeployer.published.PublishedProjectsService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.deployer.AbstractDeployerController;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss_gh.api.models.governance_status.DSSItemGovernanceStatus;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class ProjectDeployerController
extends AbstractDeployerController<AbstractProjectDeployment, AbstractPublishedItemBasicInfo.PublishedProjectBasicInfo, AbstractProjectDeploymentInfra> {
    @Autowired
    private ProjectDeploymentsService projectDeploymentsService;
    @Autowired
    private PublishedProjectsService publishedProjectsService;
    @Autowired
    private AutomationNodeInfrasService automationNodeInfrasService;
    @Autowired
    private AuditTrailService auditTrailService;

    public ProjectDeployerController() {
        super("Project");
    }

    protected ProjectDeploymentsService getDeploymentsService() {
        return this.projectDeploymentsService;
    }

    protected PublishedProjectsService getPublishedItemsService() {
        return this.publishedProjectsService;
    }

    protected AutomationNodeInfrasService getInfrasService() {
        return this.automationNodeInfrasService;
    }

    @Override
    protected boolean hasLicenseFlag(AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus licenseFeatures) {
        return licenseFeatures.bundlesAllowed;
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-services-list"})
    @RequestMapping(value={"/api/project-deployer/published-projects/list-light-status"})
    public void listPublishedLightStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listPublishedLightStatus(req, resp);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-services-list"})
    @RequestMapping(value={"/api/project-deployer/published-projects/list-basic-info"})
    public void listPublishedBasicInfo(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listPublishedBasicInfo(req, resp);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-services-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/project-deployer/published-projects/get-light-status"})
    public void getPublishedLightStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        super.getPublishedLightStatus(req, resp, projectKey);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-services-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/project-deployer/published-projects/get-settings"})
    public void getPublishedSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        super.getPublishedSettings(req, resp, projectKey);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-service-create", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/project-deployer/published-projects/create"})
    public void createPublished(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String label) throws Exception {
        super.createPublished(req, resp, projectKey, label);
    }

    @Override
    @AuditInline
    @RequestMapping(value={"/api/project-deployer/published-projects/save"})
    public void savePublished(HttpServletRequest req, HttpServletResponse resp, @RequestParam String project) throws Exception {
        super.savePublished(req, resp, project);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-service-delete", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/project-deployer/published-projects/delete"})
    public void deletePublished(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        super.deletePublished(req, resp, projectKey);
    }

    @AuditedCall(value={"msgType", "projectdeployer-project-bundle-upload", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/project-deployer/bundles/upload"})
    public void uploadBundle(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(value="file") MultipartFile filePart) throws Exception {
        AuthCtx user;
        this.checkLicense();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.publishedProjectsService.publishBundleFromStream_NT_Check(user, projectKey, filePart.getInputStream()));
    }

    @AuditedCall(value={"msgType", "projectdeployer-project-bundle-get-details", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/project-deployer/bundles/get-details"})
    public void getBundleDetails(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String bundleId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.publishedProjectsService.getBundleDetails_NT(projectKey, bundleId, user));
    }

    @AuditedCall(value={"msgType", "projectdeployer-project-bundle-get-details-for-deployment", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/project-deployer/bundles/get-details-extended"})
    public void getBundleDetailsExtended(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String bundleId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.publishedProjectsService.getBundleDetailsExtended_NT(projectKey, bundleId, user));
    }

    @AuditedCall(value={"msgType", "projectdeployer-project-bundle-get-governance-status", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/project-deployer/bundles/get-governance-status"})
    public void getGovernanceStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String bundleId) throws Exception {
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        DSSItemGovernanceStatus dssItemGovernanceStatus = this.publishedProjectsService.getGovernanceStatusForSinglePublishedPackage_NT_Check(projectKey, bundleId, user);
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)dssItemGovernanceStatus);
    }

    @AuditedCall(value={"msgType", "projectdeployer-project-bundle-delete", "projectKey", "${projectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/project-deployer/bundles/delete"})
    public void deleteBundle(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String bundleId) throws Exception {
        this.deletePackage(req, resp, projectKey, bundleId);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-infras-list"})
    @RequestMapping(value={"/api/project-deployer/infras/list-light-status"})
    public void listInfrasLightStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listInfrasLightStatus(req, resp);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-infras-list"})
    @RequestMapping(value={"/api/project-deployer/infras/list-basic-info"})
    public void listInfrasBasicInfo(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listInfrasBasicInfo(req, resp);
    }

    @AuditedCall(value={"msgType", "projectdeployer-infra-list-connections", "infraId", "${infraId}", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/project-deployer/infras/list-connections-names"})
    public void listConnectionsNames(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId, @RequestParam(required=false) String deploymentId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, this.publishedProjectsService.listConnectionsNames_NT(infraId, deploymentId, user));
    }

    @AuditedCall(value={"msgType", "projectdeployer-infra-list-container-exec-names", "infraId", "${infraId}", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/project-deployer/infras/list-container-exec-names"})
    public void listContainerExecNames(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId, @RequestParam(required=false) String deploymentId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, this.publishedProjectsService.listContainerExecNames_NT(infraId, deploymentId, user));
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-infra-get-light-status", "infraId", "${infraId}"})
    @RequestMapping(value={"/api/project-deployer/infras/get-light-status"})
    public void getInfraLightStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId) throws Exception {
        super.getInfraLightStatus(req, resp, infraId);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-infra-get-settings", "infraId", "${infraId}"})
    @RequestMapping(value={"/api/project-deployer/infras/get-settings"})
    public void getInfraSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId) throws Exception {
        super.getInfraSettings(req, resp, infraId);
    }

    @AuditedCall(value={"msgType", "projectdeployer-infra-create", "infraId", "${infraId}", "stage", "${stage}"})
    @RequestMapping(value={"/api/project-deployer/infras/create"})
    public void createInfra(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId, @RequestParam String stage, @RequestParam String type, @RequestParam(required=false) String automationNodeUrl, @RequestParam(required=false) String apiKey, @RequestParam(required=false) String governCheckPolicy) throws Exception {
        AbstractProjectDeploymentInfra newInfra;
        this.checkLicense();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            AbstractDeploymentInfra.GovernCheckPolicy resolvedGovernCheckPolicy = StringUtils.isBlank((CharSequence)governCheckPolicy) ? AbstractDeploymentInfra.GovernCheckPolicy.NO_CHECK : AbstractDeploymentInfra.GovernCheckPolicy.valueOf(governCheckPolicy);
            AbstractDeploymentInfra.InfraType infraType = AbstractDeploymentInfra.InfraType.valueOf(type);
            switch (infraType) {
                case AUTOMATION_NODE: {
                    if (automationNodeUrl == null) {
                        throw ErrorContext.iae((String)"automationNodeUrl is required");
                    }
                    if (apiKey == null) {
                        throw ErrorContext.iae((String)"apiKey is required");
                    }
                    newInfra = new SingleAutomationNodeInfra(infraId, stage, user.getIdentifier(), automationNodeUrl, apiKey, resolvedGovernCheckPolicy);
                    break;
                }
                case MULTI_AUTOMATION_NODE: {
                    newInfra = new MultiAutomationNodeInfra(infraId, stage, user.getIdentifier(), resolvedGovernCheckPolicy);
                    break;
                }
                default: {
                    throw ErrorContext.iae((String)("Unsupported infra type: " + type));
                }
            }
            this.getInfrasService().create_Check(newInfra, user);
            t.commitV("Created infra: %s, of type: %s", new Object[]{newInfra.id, infraType.name()});
        }
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)newInfra);
    }

    @Override
    protected AbstractProjectDeploymentInfra getInfra(String infra) {
        return (AbstractProjectDeploymentInfra)JSON.parse((String)infra, AbstractProjectDeploymentInfra.class);
    }

    @Override
    @AuditInline
    @RequestMapping(value={"/api/project-deployer/infras/save"})
    public void saveInfra(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infra) throws Exception {
        super.saveInfra(req, resp, infra);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-infra-delete", "infraId", "${infraId}"})
    @RequestMapping(value={"/api/project-deployer/infras/delete"})
    public void deleteInfra(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId) throws Exception {
        super.deleteInfra(req, resp, infraId);
    }

    @AuditedCall(value={"msgType", "projectdeployer-infra-project-folder-hierarchy", "infraId", "${infraId}"})
    @RequestMapping(value={"/api/project-deployer/infras/project-folder-hierarchy"})
    public void getProjectFolderHierarchy(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId) throws IOException, UnauthorizedException, CodedException {
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.automationNodeInfrasService.getProjectFolderHierarchy_Check_NT(user, infraId));
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-infra-status", "infraId", "${infraId}"})
    @RequestMapping(value={"/api/project-deployer/infras/check-status"})
    public void checkInfraStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId) throws Exception {
        super.checkInfraStatus(req, resp, infraId);
    }

    @AuditedCall(value={"msgType", "projectdeployer-infra-get-project-keys", "infraId", "${infraId}"})
    @RequestMapping(value={"/api/project-deployer/infras/get-project-keys"})
    public void getProjectKeys(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, this.automationNodeInfrasService.getProjectKeys_NT(user, infraId));
    }

    @AuditedCall(value={"msgType", "projectdeployer-infra-list-user-logins", "infraId", "${infraId}"})
    @RequestMapping(value={"/api/project-deployer/infras/list-user-logins"})
    @ResponseBody
    public List<String> getUserLogins(HttpServletRequest req, @RequestParam String infraId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        return this.automationNodeInfrasService.listUserLogins_NT(user, infraId);
    }

    @AuditedCall(value={"msgType", "projectdeployer-infra-get-automation-nodes-from-nodes-directory", "infraId", "${infraId}"})
    @RequestMapping(value={"/api/project-deployer/infras/get-automation-nodes-from-nodes-directory"})
    @ResponseBody
    public List<MultiAutomationNodeInfra.AutomationNodeRef> getAutomationNodesFromNodesDirectory(HttpServletRequest req, @RequestParam String infraId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.automationNodeInfrasService.getSettingsMandatoryUnsafe_CheckAdmin(infraId, user);
        }
        return this.automationNodeInfrasService.getAutomationNodesFromNodesDirectory();
    }

    @AuditedCall(value={"msgType", "projectdeployer-infra-list-other-automation-node-urls"})
    @RequestMapping(value={"/api/project-deployer/infras/list-other-automation-node-urls"})
    @ResponseBody
    public Map<String, List<String>> listOtherAutomationNodeUrls(HttpServletRequest req, @RequestParam String infraId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.getInfrasService().getAutomationNodeInfra_CheckRead(user, infraId);
            Map<String, List<String>> map = this.automationNodeInfrasService.listOtherAutomationNodeUrls(user, infraId);
            return map;
        }
    }

    @AuditedCall(value={"msgType", "projectdeployer-infra-generate-personal-api-key", "infraId", "${infraId}"})
    @RequestMapping(value={"/api/project-deployer/infras/generate-personal-api-key"}, method={RequestMethod.POST})
    public void generatePersonalAPIKeyForInfra(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId, @RequestParam String label, @RequestParam String description, @RequestParam(required=false) String forUser) throws Exception {
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.automationNodeInfrasService.generatePersonalAPIKey_Check(user, infraId, label, description, forUser));
    }

    @RequestMapping(value={"/api/project-deployer/infras/run-consistency-checks"})
    @ResponseBody
    public ConsistencyChecksReport runConsistencyChecks(HttpServletRequest req, @RequestParam String infraId) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        return this.getInfrasService().runConsistencyChecks(user, infraId);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-deployments-list-tags"})
    @RequestMapping(value={"/api/project-deployer/deployments/list-tags"})
    public void listDeploymentsTags(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listDeploymentsTags(req, resp);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-deployments-list"})
    @RequestMapping(value={"/api/project-deployer/deployments/list-basic-info"})
    public void listDeploymentsBasicInfo(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listDeploymentsBasicInfo(req, resp);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-deployments-list"})
    @RequestMapping(value={"/api/project-deployer/deployments/list-light-status"})
    public void listDeploymentsLightStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        super.listDeploymentsLightStatus(req, resp);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-deployment-get", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/project-deployer/deployments/get-light-status"})
    public void getDeploymentLightStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        super.getDeploymentLightStatus(req, resp, deploymentId);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-deployment-get", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/project-deployer/deployments/get-settings"})
    public void getDeploymentSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        super.getDeploymentSettings(req, resp, deploymentId);
    }

    @AuditedCall(value={"msgType", "projectdeployer-deployment-copy", "deploymentId", "${deploymentId}", "newDeploymentId", "${newDeploymentId}", "newInfraId", "${newInfraId}", "newDeployedProjectKey", "${newDeployedProjectKey}", "newProjectFolderId", "${newProjectFolderId}"})
    @RequestMapping(value={"/api/project-deployer/deployments/copy"})
    public void copyDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam String newDeploymentId, @RequestParam String newInfraId, @RequestParam(required=false) String newDeployedProjectKey, @RequestParam(required=false) String newProjectFolderId) throws Exception {
        AbstractProjectDeployment deployment;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            String deplId = this.projectDeploymentsService.copy_Check(user, deploymentId, newDeploymentId, newInfraId, newDeployedProjectKey, newProjectFolderId);
            deployment = (AbstractProjectDeployment)this.projectDeploymentsService.getSettingsMandatoryUnsafe_Check(deplId, user);
            t.commitV("Created Project deployment: %s", new Object[]{deployment.id});
        }
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)deployment);
    }

    @AuditedCall(value={"msgType", "projectdeployer-deployment-create", "deploymentId", "${deploymentId}", "publishedProjectKey", "${publishedProjectKey}", "infraId", "${infraId}", "bundleId", "${bundleId}", "deployedProjectKey", "${deployedProjectKey}", "projectFolderId", "${projectFolderId}"})
    @RequestMapping(value={"/api/project-deployer/deployments/create"})
    public void createDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam String publishedProjectKey, @RequestParam String infraId, @RequestParam String bundleId, @RequestParam(required=false) String deployedProjectKey, @RequestParam(required=false) String projectFolderId) throws Exception {
        AbstractProjectDeployment deployment;
        AbstractInfraBasicInfo infraBasicInfo;
        AuthCtx user;
        this.checkLicense();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectDeploymentsService.checkDeployPermissions(infraId, publishedProjectKey, user);
            infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)infraId, (AuthCtx)user).infraBasicInfo;
        }
        this.projectDeploymentsService.doGovernanceCheck_NT(infraBasicInfo, publishedProjectKey, Collections.singletonList(bundleId));
        t = this.transactionService.beginWriteForUI(req);
        try {
            String deplId = this.projectDeploymentsService.create_Check(user, deploymentId, publishedProjectKey, infraId, bundleId, deployedProjectKey, projectFolderId);
            deployment = (AbstractProjectDeployment)this.projectDeploymentsService.getSettingsMandatoryUnsafe_Check(deplId, user);
            t.commitV("Created Project deployment: %s", new Object[]{deployment.id});
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)deployment);
    }

    @AuditInline
    @RequestMapping(value={"/api/project-deployer/deployments/save"})
    public void saveDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deployment) throws Exception {
        AbstractInfraBasicInfo infraBasicInfo;
        AuthCtx user;
        AbstractProjectDeployment updatedDeployment = (AbstractProjectDeployment)JSON.parse((String)deployment, AbstractProjectDeployment.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.getDeploymentsService().checkDeployPermissions(updatedDeployment.id, user);
            infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)updatedDeployment.infraId, (AuthCtx)user).infraBasicInfo;
        }
        this.saveDeployment(req, resp, user, updatedDeployment, infraBasicInfo, updatedDeployment.publishedProjectKey, Collections.singletonList(updatedDeployment.bundleId));
    }

    @AuditedCall(value={"msgType", "projectdeployer-deployment-set-bundle", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/project-deployer/deployments/switch-bundle"})
    public void switchVersion(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam String bundleId) throws Exception {
        AbstractInfraBasicInfo infraBasicInfo;
        AbstractProjectDeployment deployment;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.getDeploymentsService().checkDeployPermissions(deploymentId, user);
            deployment = (AbstractProjectDeployment)this.getDeploymentsService().getSettingsMandatoryUnsafe_Check(deploymentId, user);
            infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)deployment.infraId, (AuthCtx)user).infraBasicInfo;
        }
        this.switchVersion(req, resp, user, deploymentId, bundleId, infraBasicInfo, deployment.publishedProjectKey);
    }

    @AuditInline
    @RequestMapping(value={"/api/project-deployer/deployments/get-project-standards-status-deployment-id"})
    public void getProjectStandardsStatusForDeploymentId(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        try {
            AbstractInfraBasicInfo.AbstractProjectDeploymentInfraBasicInfo infraBasicInfo;
            AbstractProjectDeployment deployment;
            AuthCtx user;
            this.checkProjectStandardsLicense();
            try (Transaction t = this.transactionService.beginRead();){
                user = this.authService.getMandatoryUser(req);
                deployment = (AbstractProjectDeployment)this.getDeploymentsService().getSettingsMandatoryUnsafe_Check(deploymentId, user);
                String infraId = deployment.infraId;
                infraBasicInfo = (AbstractInfraBasicInfo.AbstractProjectDeploymentInfraBasicInfo)this.getInfrasService().getLightStatusUnsafe_Check((String)infraId, (AuthCtx)user).infraBasicInfo;
            }
            InfoMessage.InfoMessages projectStandardMessages = this.projectDeploymentsService.verifyProjectStandards(infraBasicInfo, deployment, user, false);
            ProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)projectStandardMessages);
        }
        catch (Exception e) {
            this.auditTrailService.failure("projectdeployer-deployment-project-standards-status-get", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "projectdeployer-status-bundle-on-infra", "infraId", "${infraId}", "publishedProjectKey", "${publishedProjectKey}", "bundleId", "${bundleId}"})
    @RequestMapping(value={"/api/project-deployer/deployments/get-project-standards-status-bundle-on-infra"})
    public void getProjectStandardsStatusForBundleOnInfra(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId, @RequestParam String publishedProjectKey, @RequestParam String bundleId) throws Exception {
        AbstractInfraBasicInfo.AbstractProjectDeploymentInfraBasicInfo infraBasicInfo;
        AuthCtx user;
        this.checkProjectStandardsLicense();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            infraBasicInfo = (AbstractInfraBasicInfo.AbstractProjectDeploymentInfraBasicInfo)this.getInfrasService().getLightStatusUnsafe_Check((String)infraId, (AuthCtx)user).infraBasicInfo;
        }
        InfoMessage.InfoMessages projectStandardMessages = this.projectDeploymentsService.verifyProjectStandards(infraBasicInfo, publishedProjectKey, bundleId, user, false);
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)projectStandardMessages);
    }

    @AuditInline
    @RequestMapping(value={"/api/project-deployer/deployments/get-governance-status-deployment-id"})
    public void getGovernanceStatusForDeploymentId(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam(required=false) String infraId, @RequestParam(required=false) String bundleId) throws Exception {
        try {
            AbstractInfraBasicInfo infraBasicInfo;
            String usedInfraId;
            AbstractProjectDeployment deployment;
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx user = this.authService.getMandatoryUser(req);
                deployment = (AbstractProjectDeployment)this.getDeploymentsService().getSettingsMandatoryUnsafe_Check(deploymentId, user);
                usedInfraId = StringUtils.isBlank((CharSequence)infraId) ? deployment.infraId : infraId;
                infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)usedInfraId, (AuthCtx)user).infraBasicInfo;
            }
            ArrayList<String> bundleIds = new ArrayList<String>();
            if (!StringUtils.isEmpty((CharSequence)bundleId)) {
                bundleIds.add(bundleId);
            } else {
                bundleIds.add(deployment.bundleId);
            }
            InfoMessage.InfoMessages governanceMessages = this.projectDeploymentsService.getGovernanceMessages_NT(infraBasicInfo, deployment.publishedProjectKey, bundleIds);
            ProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)governanceMessages);
            this.auditTrailService.generic("projectdeployer-deployment-governance-status-get").with("deploymentId", deployment.id).with("publishedProjectKey", deployment.publishedProjectKey).with("infraId", usedInfraId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("projectdeployer-deployment-governance-status-get", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/project-deployer/deployments/get-governance-status-deployment"})
    public void getGovernanceStatusForDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deployment) throws Exception {
        try {
            AbstractInfraBasicInfo infraBasicInfo;
            AbstractProjectDeployment parsedDeployment = (AbstractProjectDeployment)JSON.parse((String)deployment, AbstractProjectDeployment.class);
            try (Transaction t = this.transactionService.beginRead();){
                AuthCtx user = this.authService.getMandatoryUser(req);
                infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)parsedDeployment.infraId, (AuthCtx)user).infraBasicInfo;
            }
            InfoMessage.InfoMessages governanceMessage = this.projectDeploymentsService.getGovernanceMessages_NT(infraBasicInfo, parsedDeployment.publishedProjectKey, Collections.singletonList(parsedDeployment.bundleId));
            ProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)governanceMessage);
            this.auditTrailService.generic("projectdeployer-deployment-governance-status-get").with("deploymentId", parsedDeployment.id).with("publishedProjectKey", parsedDeployment.publishedProjectKey).with("infraId", parsedDeployment.infraId).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("projectdeployer-deployment-governance-status-get", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "projectdeployer-deployment-governance-status-get", "publishedProjectKey", "${publishedProjectKey}", "infraId", "${infraId}"})
    @RequestMapping(value={"/api/project-deployer/deployments/get-governance-status-new-deployment"})
    public void getGovernanceStatusForNewDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String publishedProjectKey, @RequestParam String infraId, @RequestParam String bundleId) throws Exception {
        AbstractInfraBasicInfo infraBasicInfo;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            infraBasicInfo = this.getInfrasService().getLightStatusUnsafe_Check((String)infraId, (AuthCtx)user).infraBasicInfo;
        }
        InfoMessage.InfoMessages governanceMessages = this.projectDeploymentsService.getGovernanceMessages_NT(infraBasicInfo, publishedProjectKey, Collections.singletonList(bundleId));
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)governanceMessages);
    }

    @AuditedCall(value={"msgType", "projectdeployer-deployment-delete", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/project-deployer/deployments/delete"})
    public void deleteDeployment(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        super.deleteDeployment(req, resp, deploymentId, false);
    }

    @AuditedCall(value={"msgType", "projectdeployer-get-status"})
    @RequestMapping(value={"/api/project-deployer/global-light-status"})
    public void getGlobalLightStatus(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List<InfraLightStatus> infraStatusList;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            infraStatusList = this.automationNodeInfrasService.listLightStatusUnsafe_Check(authCtx);
        }
        List<AbstractDeploymentLightStatus> deploymentStatusList = this.projectDeploymentsService.listLightStatusUnsafe_NT_Check(authCtx);
        List<AbstractPublishedItemLightStatus> publishedProjectStatusList = this.publishedProjectsService.listLightStatusUnsafe_NT_Check(authCtx);
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)new AbstractGlobalLightStatus.ProjectDeployerGlobalLightStatus(deploymentStatusList, infraStatusList, publishedProjectStatusList));
    }

    @AuditedCall(value={"msgType", "projectdeployer-deployment-get-scenario-runs", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/project-deployer/deployments/scenario-runs-in-date-range"})
    public void getScenarioRunsWithinDateRange(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam(value="fromDate") String fromDateStr, @RequestParam(value="toDate") String toDateStr) throws Exception {
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, this.projectDeploymentsService.getScenarioRunsWithinDateRange_NT_Check(user, deploymentId, fromDateStr, toDateStr));
    }

    @AuditedCall(value={"msgType", "projectdeployer-deployment-update", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/project-deployer/deployments/update"})
    public void update(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, this.projectDeploymentsService.executeOneStepSync_NT_Check(user, deploymentId));
    }

    @AuditedCall(value={"msgType", "projectdeployer-deployment-get", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/project-deployer/deployments/get-heavy-status"})
    public void getHeavyStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws UnauthorizedException, IOException {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, (Object)this.projectDeploymentsService.getHeavyStatus_Unsafe_NT_Check(user, deploymentId));
    }

    @AuditedCall(value={"msgType", "projectdeployer-deployment-list"})
    @RequestMapping(value={"/api/project-deployer/deployments/list-heavy-status"})
    public void listHeavyStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String infraId) throws UnauthorizedException, IOException {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        ProjectDeployerController.writeJSON((HttpServletResponse)resp, this.projectDeploymentsService.listHeavyStatusUnsafe_NT_Check(user, infraId));
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-deployment-list-logs", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/project-deployer/deployments/list-logs"})
    public void getLogsList(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        super.getLogsList(req, resp, deploymentId);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-deployment-get-log", "deploymentId", "${deploymentId}", "logName", "${logName}"})
    @RequestMapping(value={"/api/project-deployer/deployments/get-log"})
    public void getLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam String logName) throws Exception {
        super.getLog(req, resp, deploymentId, logName);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-deployment-stream-log", "deploymentId", "${deploymentId}", "logName", "${logName}"})
    @RequestMapping(value={"/api/project-deployer/deployments/stream-log"})
    public void streamLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam String logName) throws Exception {
        super.streamLog(req, resp, deploymentId, logName);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-deployment-get-logs-zip", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/project-deployer/deployments/all-logs-zip"})
    public void getAllLogsZip(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        super.getAllLogsZip(req, resp, deploymentId);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-deployment-get-last-action", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/project-deployer/deployments/get-last-action"})
    public void getLastDeploymentAction(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        super.getLastDeploymentAction(req, resp, deploymentId);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-deployment-peek-action-progress", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/project-deployer/deployments/peek-action-progress"})
    public void peekDeploymentActionProgress(HttpServletRequest req, HttpServletResponse resp, String deploymentId, @RequestParam(required=false) String jobId) throws Exception {
        super.peekDeploymentActionProgress(req, resp, deploymentId, jobId);
    }

    @AuditedCall(value={"msgType", "projectdeployer-deployment-abort-action", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/project-deployer/deployments/abort-action"})
    public void abortDeploymentAction(HttpServletRequest req, HttpServletResponse resp, String deploymentId) throws Exception {
        super.abortDeploymentAction(req, deploymentId);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-deployment-get-update", "deploymentId", "${deploymentId}", "startTimestamp", "${startTimestamp}"})
    @RequestMapping(value={"/api/project-deployer/deployments/get-update"})
    public void getDeploymentUpdate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam String startTimestamp) throws Exception {
        super.getDeploymentUpdate(req, resp, deploymentId, startTimestamp);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-deployment-list-update-heads", "deploymentId", "${deploymentId}"})
    @RequestMapping(value={"/api/project-deployer/deployments/list-update-heads"})
    public void listDeploymentUpdateHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId) throws Exception {
        super.listDeploymentUpdateHeads(req, resp, deploymentId);
    }

    @Override
    @AuditedCall(value={"msgType", "projectdeployer-deployment-get-update-settings-diff", "deploymentId", "${deploymentId}", "startTimestamp", "${startTimestamp}"})
    @RequestMapping(value={"/api/project-deployer/deployments/get-update-settings-diff"})
    public void getUpdateSettingsDiff(HttpServletRequest req, HttpServletResponse resp, @RequestParam String deploymentId, @RequestParam String startTimestamp) throws Exception {
        super.getUpdateSettingsDiff(req, resp, deploymentId, startTimestamp);
    }
}

