/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.hive.HProxyKernelHandle;
import com.dataiku.dip.hive.HProxyKernelsManager;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.JSON;
import com.dataiku.hproxy.model.hive.HiveConfEntry;
import com.dataiku.hproxy.model.hive.ValidationQuery;
import com.dataiku.hproxy.model.hive.ValidationResult;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class HProxyIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private TicketAuthService ticketAuthService;
    @Autowired
    private HProxyKernelsManager hproxyKernelsManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/hproxy/check-pig-script"})
    public void checkPigScript(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String script) throws Exception {
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);){
            HProxyKernelHandle hproxyKernel = (HProxyKernelHandle)this.hproxyKernelsManager.acquireKernel(new ClusterSelector().selectForProject(tu.getAuthCtx(), projectKey));
            try {
                com.dataiku.hproxy.model.pig.ValidationResult rawPigResponse = (com.dataiku.hproxy.model.pig.ValidationResult)hproxyKernel.getAPIClient().postFormToJSON("pig/check", com.dataiku.hproxy.model.pig.ValidationResult.class, new Object[]{"query", script});
                HProxyIntercomController.writeJSON((HttpServletResponse)resp, (Object)rawPigResponse);
            }
            finally {
                this.hproxyKernelsManager.releaseKernel(hproxyKernel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/hproxy/check-hive-script"})
    public void checkHiveScript(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String initQuery, @RequestParam String execQuery, @RequestParam String extraConf, @RequestParam boolean isExplainPlan, @RequestParam boolean useGlobalMetastore, @RequestParam boolean onlyCheckInsertOverwrites) throws Exception {
        List extraConfPairs = StringUtils.isNotBlank((String)extraConf) ? (List)JSON.parse((String)extraConf, (TypeToken)new TypeToken<List<SimpleKeyValue>>(){}) : new ArrayList();
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);){
            HProxyKernelHandle hproxyKernel = (HProxyKernelHandle)this.hproxyKernelsManager.acquireKernel(new ClusterSelector().selectForProject(tu.getAuthCtx(), projectKey));
            boolean kernelReleased = false;
            try {
                ValidationQuery query = new ValidationQuery(execQuery, initQuery);
                query.isExplainPlan = isExplainPlan;
                query.onlyCheckInsertOverwrites = onlyCheckInsertOverwrites;
                query.useGlobalMetastore = useGlobalMetastore;
                for (SimpleKeyValue conf : extraConfPairs) {
                    query.extraConf.add(new HiveConfEntry(conf.key, conf.value));
                }
                int validationTimeout = DKUApp.getParams().getIntParam("dku.hive.queryValidationTimeoutMS", Integer.valueOf(300000));
                ValidationResult rawHiveResponse = (ValidationResult)hproxyKernel.getAPIClient().postFormToJSON("hive/check", validationTimeout, ValidationResult.class, new Object[]{"query", JSON.json((Object)query)});
                this.hproxyKernelsManager.releaseKernel(hproxyKernel);
                kernelReleased = true;
                HProxyIntercomController.writeJSON((HttpServletResponse)resp, (Object)rawHiveResponse);
            }
            catch (SocketTimeoutException e) {
                logger.warn((Object)"Hive query validation timeout", (Throwable)e);
                HProxyIntercomController.writeJSON((HttpServletResponse)resp, (Object)ValidationResult.makeValidationTimeoutResult());
            }
            finally {
                if (!kernelReleased) {
                    this.hproxyKernelsManager.releaseAndKillKernel(hproxyKernel);
                }
            }
        }
    }
}

