/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.notifications.EmailNotificationsSender;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.notifications.backend.AbstractAccessRequestEvent;
import com.dataiku.dip.server.notifications.backend.AbstractRequestEvent;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import freemarker.template.TemplateException;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRequestAccessEmailBuilder<T extends AbstractAccessRequestEvent> {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private UsersService usersService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    protected static final Logger logger = Logger.getLogger((String)"dku.notifications.access-request-email-builder");

    abstract String makeSubject(T var1, PublicUser var2, String var3);

    protected abstract String makeBody(T var1, PublicUser var2, SerializedProject var3, String var4) throws IOException, TemplateException;

    protected void sendToUser(T evt, String user) throws Exception {
        String objectDisplayName;
        SerializedProject project;
        PublicUser dstUser;
        PublicUser srcUser;
        try (Transaction ignored = this.transactionService.beginRead();){
            srcUser = this.usersService.getPublicUser(((AbstractAccessRequestEvent)evt).getUserLogin());
            dstUser = this.usersService.getPublicUser(user);
            if (StringUtils.isBlank((String)dstUser.email)) {
                return;
            }
            project = this.projectsService.getMandatory(((AbstractAccessRequestEvent)evt).getProjectKey());
            if (((AbstractRequestEvent)evt).getObjectType().needsNameEnrichment()) {
                TaggableObjectsService.TaggableObject to = this.taggableObjectsReadService.getOrNullUnsafe(((AbstractAccessRequestEvent)evt).getProjectKey(), ((AbstractRequestEvent)evt).getObjectType().toTaggableType().orElse(null), ((AbstractRequestEvent)evt).getObjectId());
                objectDisplayName = to.getDisplayName();
            } else {
                objectDisplayName = ((AbstractRequestEvent)evt).getObjectId();
            }
        }
        UserSettingsService.EmailNotificationsSettings params = new UserSettingsService.EmailNotificationsSettings();
        params.enabled = true;
        params.subject = "Dataiku \u2022 " + this.makeSubject(evt, srcUser, objectDisplayName);
        EmailNotificationsSender sender = new EmailNotificationsSender();
        logger.info((Object)("Sending email to " + dstUser.login));
        sender.sendToUser(dstUser.email, params, this.makeBody(evt, srcUser, project, objectDisplayName));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getObjectIconPath(T request) {
        switch (((AbstractRequestEvent)request).getObjectType()) {
            case DATASET: {
                String datasetType;
                try (Transaction ignored = this.transactionService.beginRead();){
                    SerializedDataset dataset = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(((AbstractAccessRequestEvent)request).getProjectKey(), ((AbstractRequestEvent)request).getObjectId());
                    datasetType = dataset.getSubtype().toLowerCase();
                }
                catch (IOException e) {
                    logger.warn((Object)"Unknown dataset type", (Throwable)e);
                    return "datasets/dku-icon-flow-colored-dataset.png";
                }
                switch (datasetType) {
                    case "alloydb": {
                        return "datasets/dku-icon-flow-colored-alloydb.png";
                    }
                    case "bigquery": {
                        return "datasets/dku-icon-flow-colored-google-bigquery.png";
                    }
                    case "cassandra": {
                        return "datasets/dku-icon-flow-colored-cassandra.png";
                    }
                    case "databricks": {
                        return "datasets/dku-icon-flow-colored-databricks.png";
                    }
                    case "elasticsearch": {
                        return "datasets/dku-icon-flow-colored-elastic-search.png";
                    }
                    case "gcs": {
                        return "datasets/dku-icon-flow-colored-google-gcp-cloud-storage.png";
                    }
                    case "greenplum": {
                        return "datasets/dku-icon-flow-colored-greenplum.png";
                    }
                    case "filesinfolder": {
                        return "datasets/dku-icon-flow-colored-dataset-files-in-folder.png";
                    }
                    case "filesystem": {
                        return "datasets/dku-icon-flow-colored-server-file-system.png";
                    }
                    case "ftp": {
                        return "datasets/dku-icon-flow-colored-data-ftp.png";
                    }
                    case "hdfs": {
                        return "datasets/dku-icon-flow-colored-hdfs.png";
                    }
                    case "inline": {
                        return "datasets/dku-icon-flow-colored-edit.png";
                    }
                    case "mongodb": {
                        return "datasets/dku-icon-flow-colored-mongo.png";
                    }
                    case "mysql": {
                        return "datasets/dku-icon-flow-colored-mysql.png";
                    }
                    case "oracle": {
                        return "datasets/dku-icon-flow-colored-oracle.png";
                    }
                    case "postgresql": {
                        return "datasets/dku-icon-flow-colored-postgresql.png";
                    }
                    case "redshift": {
                        return "datasets/dku-icon-flow-colored-amazon-redshift.png";
                    }
                    case "s3": {
                        return "datasets/dku-icon-flow-colored-amazon-web-s3.png";
                    }
                    case "saphana": {
                        return "datasets/dku-icon-flow-colored-sap-hana.png";
                    }
                    case "scp": {
                        return "datasets/dku-icon-flow-colored-data-scp.png";
                    }
                    case "sftp": {
                        return "datasets/dku-icon-data-sftp.png";
                    }
                    case "snowflake": {
                        return "datasets/dku-icon-flow-colored-snowflake-brand.png";
                    }
                    case "sqlserver": {
                        return "datasets/dku-icon-flow-colored-sql-server.png";
                    }
                    case "synapse": {
                        return "datasets/dku-icon-flow-colored-microsoft-azure-synapse.png";
                    }
                    case "teradata": {
                        return "datasets/dku-icon-flow-colored-terradata.png";
                    }
                    case "twitter": {
                        return "datasets/dku-icon-flow-colored-twitter.png";
                    }
                    case "uploadedfiles": {
                        return "datasets/dku-icon-flow-colored-arrow-circle-dataset-upload.png";
                    }
                    case "vertica": {
                        return "datasets/dku-icon-flow-colored-vertica.png";
                    }
                }
                return "datasets/dku-icon-flow-colored-dataset.png";
            }
            case MANAGED_FOLDER: {
                return "datasets/dku-icon-flow-colored-dataset-files-in-folder.png";
            }
            case SAVED_MODEL: {
                String string;
                String defaultSavedModelIcon = "ml/dku-icon-flow-colored-machine-learning-regression.png";
                Transaction ignored = this.transactionService.beginRead();
                try {
                    SavedModel model = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(((AbstractAccessRequestEvent)request).getProjectKey(), ((AbstractRequestEvent)request).getObjectId());
                    string = model.getObjectIconPath();
                    if (ignored == null) return string;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored == null) throw throwable;
                        try {
                            ignored.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        logger.warn((Object)"Unknown saved model type", (Throwable)e);
                        return defaultSavedModelIcon;
                    }
                }
                ignored.close();
                return string;
            }
            case MODEL_EVALUATION_STORE: {
                return "ml/dku-icon-flow-colored-model-evaluation-store.png";
            }
            case RETRIEVABLE_KNOWLEDGE: {
                return "llm/dku-icon-flow-colored-knowledge-bank.png";
            }
        }
        return "";
    }

    protected String getObjectLink(T request, HrefContext href) {
        switch (((AbstractRequestEvent)request).getObjectType()) {
            case DATASET: {
                return href.dataset(((AbstractAccessRequestEvent)request).getProjectKey(), ((AbstractRequestEvent)request).getObjectId());
            }
            case MANAGED_FOLDER: {
                return href.folder(((AbstractAccessRequestEvent)request).getProjectKey(), ((AbstractRequestEvent)request).getObjectId());
            }
            case SAVED_MODEL: {
                return href.savedModel(((AbstractAccessRequestEvent)request).getProjectKey(), ((AbstractRequestEvent)request).getObjectId());
            }
            case MODEL_EVALUATION_STORE: {
                return href.modelEvaluationStore(((AbstractAccessRequestEvent)request).getProjectKey(), ((AbstractRequestEvent)request).getObjectId());
            }
            case RETRIEVABLE_KNOWLEDGE: {
                return href.retrievableKnowledge(((AbstractAccessRequestEvent)request).getProjectKey(), ((AbstractRequestEvent)request).getObjectId());
            }
            case PROJECT: {
                return href.project(((AbstractAccessRequestEvent)request).getProjectKey());
            }
            case APP: {
                return href.application(((AbstractRequestEvent)request).getObjectId());
            }
        }
        throw new IllegalArgumentException("Unknown request type: " + String.valueOf((Object)((AbstractRequestEvent)request).getObjectType()));
    }
}

